/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class ItemsEditor
implements SelectionListener,
JQueryConstants {
    protected AbstractNewHTMLWidgetWizardPage page;
    protected TabFolder tab = null;
    protected Composite control = null;
    protected int selected = -1;
    protected int number = -1;
    protected boolean isSwitching = false;
    protected ItemData[] items = new ItemData[8];
    protected int minNumber = 0;
    protected int maxNumber = 8;
    protected int initValue = 3;

    public ItemsEditor(AbstractNewHTMLWidgetWizardPage page, int minNumber, int maxNumber) {
        this(page, minNumber, maxNumber, 3);
    }

    public ItemsEditor(AbstractNewHTMLWidgetWizardPage page, int minNumber, int maxNumber, int initValue) {
        this.page = page;
        this.minNumber = minNumber;
        this.maxNumber = maxNumber;
        this.initValue = initValue;
        int i = 0;
        while (i < maxNumber) {
            this.items[i] = new ItemData();
            ++i;
        }
    }

    public int getNumber() {
        return this.number;
    }

    public ItemData getSelected() {
        return this.selected < 0 ? null : this.items[this.selected];
    }

    public void createEditors() {
        IFieldEditor number = JQueryFieldEditorFactory.createItemsNumberEditor(WizardMessages.numberOfItemsLabel, this.minNumber, this.maxNumber, this.initValue);
        this.page.addEditor(number, null);
        this.createItemEditors();
        this.setNumber(Integer.parseInt(number.getValueAsString()));
        this.setSelected(0);
    }

    public Composite createControl(Composite parent, String folderName) {
        if (parent == null) {
            this.createEditors();
            return null;
        }
        Group panel = new Group(parent, 2048);
        panel.setText(folderName);
        GridData d = new GridData(768);
        d.horizontalSpan = 3;
        panel.setLayoutData((Object)d);
        GridLayout layout = new GridLayout(3, false);
        panel.setLayout((Layout)layout);
        IFieldEditor number = JQueryFieldEditorFactory.createItemsNumberEditor(WizardMessages.numberOfItemsLabel, this.minNumber, this.maxNumber, this.initValue);
        this.page.addEditor(number, (Composite)panel);
        this.tab = new TabFolder((Composite)panel, 0);
        d = new GridData(768);
        d.horizontalSpan = 3;
        this.tab.setLayoutData((Object)d);
        this.tab.addSelectionListener((SelectionListener)this);
        this.control = new Composite((Composite)this.tab, 0);
        this.control.setLayoutData((Object)new GridData(768));
        this.control.setLayout((Layout)new GridLayout(3, false));
        this.createItemEditors();
        this.setNumber(Integer.parseInt(number.getValueAsString()));
        this.setSelected(0);
        return panel;
    }

    protected void createItemEditors() {
    }

    protected final void addItemEditor(IFieldEditor editor) {
        this.page.addEditor(editor, this.control);
    }

    /*
     * Unable to fully structure code
     */
    public void setNumber(int n) {
        sel = this.selected;
        if (this.number == n) {
            return;
        }
        if (n == 0 || this.number == 0) {
            this.setEditorEnablement(n > 0);
        }
        this.number = n;
        if (this.tab != null) ** GOTO lbl14
        this.setSelected(sel);
        return;
lbl-1000:
        // 1 sources

        {
            b = this.tab.getItem(this.tab.getItemCount() - 1);
            b.getParent().setSelection(b);
            b.setControl(null);
            b.dispose();
lbl14:
            // 2 sources

            ** while (this.tab.getItemCount() > n && this.tab.getItemCount() > 1)
        }
lbl15:
        // 1 sources

        i = this.tab.getItemCount();
        while (i < n) {
            b1 = new TabItem(this.tab, 0);
            b1.setText("    " + (char)(49 + i) + "    ");
            b1.setControl((Control)this.control);
            ++i;
        }
        if (sel >= n) {
            sel = n - 1;
        }
        if (this.selected != sel) {
            this.tab.setSelection(sel);
            this.setSelected(sel);
        }
    }

    public void setSelected(int n) {
        if (this.selected != n && n >= 0) {
            this.selected = n;
            this.isSwitching = true;
            this.fillEditorValues();
            this.isSwitching = false;
        }
    }

    protected void setEditorEnablement(boolean b) {
        if (this.control == null) {
            return;
        }
        ItemData s = this.items[0];
        for (String editorID : s.values.keySet()) {
            this.page.getEditor(editorID).setEnabled(b);
        }
    }

    protected void fillEditorValues() {
        ItemData s = this.getSelected();
        for (String editorID : s.values.keySet()) {
            this.page.getEditor(editorID).setValue((Object)s.getValue(editorID));
        }
        if (this.page.getLeftPanel() != null) {
            this.updateEnablement();
        }
    }

    public boolean onPropertyChange(String editorID, String value) {
        if ("number-of-items".equals(editorID)) {
            this.setNumber(Integer.parseInt(value));
            return true;
        }
        if (this.getSelected() != null && this.getSelected().getValue(editorID) != null) {
            this.getSelected().setValue(editorID, value);
            return true;
        }
        return false;
    }

    public void updateEnablement() {
    }

    public void widgetSelected(SelectionEvent e) {
        this.setSelected(this.tab.getSelectionIndex());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public static class ItemData {
        Map<String, String> values = new HashMap<String, String>();

        public void setValue(String editorID, String value) {
            this.values.put(editorID, value);
        }

        public String getValue(String editorID) {
            return this.values.get(editorID);
        }
    }
}

