/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import java.util.List;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.views.palette.IPalettePageAdapter;
import org.jboss.tools.jst.web.ui.palette.CustomPaletteEditPartFactory;
import org.jboss.tools.jst.web.ui.palette.MobilePaletteEditPartFactory;
import org.jboss.tools.jst.web.ui.palette.PaletteDragSourceListener;
import org.jboss.tools.jst.web.ui.palette.model.PaletteItem;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;

public class PaletteViewer
extends org.eclipse.gef.ui.palette.PaletteViewer {
    private IPalettePageAdapter viewPart;
    PaletteDragSourceListener listener;
    static Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance(), ModelTransfer.getInstance()};

    public PaletteViewer(IPalettePageAdapter viewPart, PaletteModel model) {
        this.viewPart = viewPart;
        if (model.getType().equals(PaletteModel.TYPE_MOBILE)) {
            this.setEditPartFactory((EditPartFactory)new MobilePaletteEditPartFactory());
        } else {
            this.setEditPartFactory((EditPartFactory)new CustomPaletteEditPartFactory());
        }
    }

    void addDragStartSupport() {
        this.listener = new PaletteDragSourceListener((EditPartViewer)this);
        DragSource dragSource = new DragSource(this.getControl(), 3);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener((DragSourceListener)this.listener);
    }

    public void setActiveTool(ToolEntry tool) {
        IFigure fig;
        EditPart part = this.getFocusEditPart();
        if (part instanceof GraphicalEditPart && (fig = ((GraphicalEditPart)part).getFigure()) instanceof Clickable) {
            part.setSelected(0);
            ((Clickable)fig).getModel().setArmed(false);
            ((Clickable)fig).getModel().setPressed(false);
            ((Clickable)fig).getModel().setSelected(false);
        }
        super.setActiveTool(null);
        if (tool instanceof PaletteItem && !this.listener.isDragging()) {
            this.insertIntoEditor((PaletteItem)tool);
        }
    }

    private void insertIntoEditor(PaletteItem item) {
        this.viewPart.insertIntoEditor(item.getXModelObject());
    }

    public void setEnabled(boolean enabled) {
        EditPart root = this.getContents();
        List v = root.getChildren();
        if (v != null) {
            int max = v.size();
            int i = 0;
            while (i < max) {
                this.setCategoryEnabled((EditPart)v.get(i), enabled);
                ++i;
            }
        }
    }

    private void setCategoryEnabled(EditPart part, boolean enabled) {
        List v = part.getChildren();
        if (v != null) {
            int max = v.size();
            int i = 0;
            while (i < max) {
                IFigure fig;
                Object obj = v.get(i);
                if (obj instanceof GraphicalEditPart && (fig = ((GraphicalEditPart)obj).getFigure()) instanceof Clickable) {
                    ((Clickable)fig).setEnabled(enabled);
                }
                ++i;
            }
        }
    }
}

