/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import java.util.List;
import java.util.Properties;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.jst.web.ui.palette.PaletteViewer;
import org.jboss.tools.jst.web.ui.palette.model.PaletteItem;

public class PaletteDragSourceListener
extends DragSourceAdapter {
    EditPartViewer viewer;
    boolean isDragging = false;

    public PaletteDragSourceListener(EditPartViewer viewer) {
        this.viewer = viewer;
    }

    boolean isDragging() {
        return this.isDragging;
    }

    public void dragStart(DragSourceEvent event) {
        XModelObject object;
        XModelTransferBuffer.getInstance().enable();
        List list = ((PaletteViewer)this.viewer).getSelectedEditParts();
        XModelObject xModelObject = object = list.size() == 0 ? null : this.getObject(list.get(0));
        if (object == null) {
            event.doit = false;
            return;
        }
        Properties p = new Properties();
        p.setProperty("isDrag", "true");
        XActionInvoker.invoke((String)"CopyActions.Copy", (XModelObject)object, (Properties)p);
        this.isDragging = true;
    }

    public void dragSetData(DragSourceEvent event) {
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            XModelObject object;
            List list = ((PaletteViewer)this.viewer).getSelectedEditParts();
            XModelObject xModelObject = object = list.size() == 0 ? null : this.getObject(list.get(0));
            if (object != null) {
                int i;
                String[] d = new String[2];
                d[0] = object.getAttributeValue("start text");
                if (d[0] == null) {
                    d[0] = "";
                }
                d[1] = object.getAttributeValue("end text");
                if (d[1] == null) {
                    d[1] = "";
                }
                String defaultPrefix = object.getAttributeValue("default prefix");
                String tag = object.getAttributeValue("name");
                if (defaultPrefix == null) {
                    defaultPrefix = object.getParent().getAttributeValue("default prefix");
                }
                if (defaultPrefix != null && tag != null) {
                    JSPPaletteInsertHelper.applyPrefix(d, "", tag, "xxx", defaultPrefix);
                }
                if ((i = d[0].indexOf(124)) >= 0) {
                    d[0] = String.valueOf(d[0].substring(0, i)) + d[0].substring(i + 1);
                }
                event.data = String.valueOf(d[0]) + d[1];
            } else {
                event.data = "data";
            }
        } else {
            event.data = "model object";
        }
    }

    public void dragFinished(DragSourceEvent event) {
        event.data = null;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PaletteDragSourceListener.this.isDragging = false;
            }
        });
    }

    XModelObject getObject(Object part) {
        if (part instanceof PaletteEditPart) {
            PaletteEditPart entry = (PaletteEditPart)part;
            Object item = entry.getModel();
            if (item instanceof PaletteItem) {
                return ((PaletteItem)item).getXModelObject();
            }
        } else if (ModelPlugin.isDebugEnabled()) {
            WebUiPlugin.getPluginLog().logInfo(part.getClass().getName());
        }
        return null;
    }

    public void dragFinish(DragSourceEvent event) {
        XModelTransferBuffer.getInstance().disable();
    }
}

