/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette;

import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PopUpHelper;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.jst.web.ui.palette.MobileDrawerFigure;

class JQueryMobileVersionPopUp
extends PopUpHelper {
    private MobileDrawerFigure.VersionFigure figureToShowNear;

    public JQueryMobileVersionPopUp(Control c, MobileDrawerFigure.VersionFigure figureToShowNear) {
        super(c, 16388);
        this.figureToShowNear = figureToShowNear;
        this.getShell().setBackground(ColorConstants.menuBackground);
        this.getShell().setForeground(ColorConstants.menuForeground);
    }

    protected void hookShellListeners() {
        this.getShell().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                JQueryMobileVersionPopUp.this.hide();
            }
        });
        this.getShell().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    JQueryMobileVersionPopUp.this.hide();
                }
            }
        });
    }

    public boolean isShowing() {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            return this.getShell().isVisible();
        }
        return false;
    }

    private Viewport getViewport(IFigure figure) {
        IFigure parent = figure;
        while (parent != null) {
            if (parent instanceof Viewport) {
                return (Viewport)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void displayToolTip(IFigure hoverSource, IFigure tip) {
        this.getLightweightSystem().setContents(tip);
        Dimension shellSize = this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
        Rectangle rect = hoverSource.getClientArea();
        Viewport vp = this.getViewport(hoverSource);
        Point viewportLocation = vp.getViewLocation().getSWTPoint();
        Point displayPoint = new Point(rect.x - 5, rect.y + 10 + rect.height - viewportLocation.y);
        Point absolute = this.control.toDisplay(new Point(displayPoint.x, displayPoint.y));
        this.setShellBounds(absolute.x, absolute.y, shellSize.width, shellSize.height);
        this.show();
        this.getShell().forceFocus();
    }

    public void show(String[] versions) {
        String currentVersion = this.figureToShowNear.getVersion();
        Panel panel = new Panel();
        panel.setLayoutManager((LayoutManager)new GridLayout(1, false));
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            String version = stringArray[n2];
            ItemFigure label = new ItemFigure(version);
            panel.add((IFigure)label);
            if (version.equals(currentVersion)) {
                label.setSelected(true);
            }
            ++n2;
        }
        this.displayToolTip((IFigure)this.figureToShowNear, (IFigure)panel);
    }

    public void close() {
        this.hide();
    }

    public class ItemFigure
    extends Clickable {
        private Color backColor;
        private Color foreColor;

        public ItemFigure(final String text) {
            super((IFigure)new Label(text));
            this.backColor = ColorConstants.menuBackgroundSelected;
            this.foreColor = ColorConstants.menuForegroundSelected;
            this.setRolloverEnabled(true);
            this.setRequestFocusEnabled(false);
            this.setFocusTraversable(false);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    JQueryMobileVersionPopUp.this.hide();
                    JQueryMobileVersionPopUp.this.figureToShowNear.setVersion(text);
                }
            });
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            ButtonModel model = this.getModel();
            if (this.isRolloverEnabled() && model.isMouseOver() || this.isSelected()) {
                graphics.setBackgroundColor(this.backColor);
                graphics.fillRectangle(this.getClientArea().getCopy().getExpanded(1, 1));
                graphics.setForegroundColor(this.foreColor);
                graphics.drawRectangle(this.getClientArea().getCopy().getExpanded(1, 1));
            }
        }
    }
}

