/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.operation;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelFactory;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.project.ProjectHome;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.context.RegisterServerContext;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.helpers.IWebProjectTemplate;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectContext;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.operation.Messages;
import org.jboss.tools.jst.web.ui.operation.WebNatureOperation;

public abstract class WebProjectCreationOperation
extends WebNatureOperation {
    protected IWebProjectTemplate template = this.createTemplate();
    protected XModel templateModel = null;
    protected File projectFile = null;
    public static final String WARNING_MESSAGE = "COD_MESSAGE";
    public static final String WARNING_TITLE = "COD_TITLE";
    public static final String BTN_CANCEL = "BTN_CANCEL";
    public static final String BTN_OK = "BTN_OK";

    public WebProjectCreationOperation(IProject project, IPath projectLocation, RegisterServerContext registry, Properties properties) {
        super(project, projectLocation, registry, properties);
    }

    public WebProjectCreationOperation(NewWebProjectContext context) {
        this(context.getProject(), context.getLocationPath(), context.getRegisterServerContext(), context.getActionProperties());
        this.setProperty("WebNatureOperation.PROJECT_NAME_ID", context.getActionProperties().getProperty("name"));
        this.setProperty("WebNatureOperation.PROJECT_LOCATION_ID", context.getActionProperties().getProperty("location"));
        this.setProperty("WebNatureOperation.USE_DEFAULT_LOCATION_ID", context.getActionProperties().getProperty("use default path"));
        this.setProperty("WebNatureOperation.TEMPLATE_ID", context.getActionProperties().getProperty("template"));
        this.setProperty("WebNatureOperation.TEMPLATE_VERSION_ID", context.getActionProperties().getProperty("version"));
        this.setProperty("WebNatureOperation.SERVLET_VERSION_ID", context.getActionProperties().getProperty("servlet version"));
        this.setProperty("WebNatureOperation.REGISTER_WEB_CONTEXT_ID", context.getActionProperties().getProperty("register web context"));
        this.setProperty("WebNatureOperation.RUNTIME_NAME", context.getRegisterServerContext().getRuntimeName());
        this.setProperty("WebNatureOperation.JAVA_SOURCES_LOCATION_ID", this.getJavaSources());
        String contextRoot = context.getRegisterServerContext().getApplicationName();
        if (contextRoot != null && contextRoot.length() > 0) {
            this.setProperty("WebNatureOperation.CONTEXT_ROOT", contextRoot);
        }
    }

    protected abstract IWebProjectTemplate createTemplate();

    protected abstract void copyTemplate() throws Exception;

    @Override
    protected void preCreateWebNature() throws CoreException {
        Properties properties = this.getWizardPropertiesAsIs();
        properties.setProperty("location", this.getProject().getLocation().toString());
        try {
            this.createTemplateModel();
            this.copyTemplate();
        }
        catch (Exception e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = e.getClass().getName();
            }
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.common.model.ui", 1, message, (Throwable)e));
        }
        this.copyProjectFile(properties);
    }

    @Override
    protected void createWebNature() throws CoreException {
        XModelObject webxml;
        Properties properties = this.getWizardPropertiesAsIs();
        properties.setProperty("location", this.getProject().getLocation().toString());
        EclipseResourceUtil.addNatureToProject((IProject)this.getProject(), (String)this.getNatureID());
        IModelNature project = (IModelNature)this.getProject().getNature(this.getNatureID());
        this.model = project.getModel();
        XModelObject fso = FileSystemsHelper.getFileSystems((XModel)this.model);
        properties.setProperty("skipWizard", "yes");
        properties.setProperty("name", this.getProject().getName());
        XActionInvoker.invoke((String)"CreateStrutsProject", (XModelObject)fso, (Properties)properties);
        XModelObject web = this.model.getByPath("Web");
        if (web != null && properties.containsKey("servlet version")) {
            this.model.changeObjectAttribute(web, "servlet version", properties.getProperty("servlet version"));
        }
        if ((webxml = WebAppHelper.getWebApp((XModel)this.model)) != null) {
            this.model.changeObjectAttribute(webxml, "display-name", this.getProject().getName());
        }
    }

    @Override
    protected void postCreateWebNature() {
    }

    protected void copyProjectFile(Properties p) {
        String templateFolder = String.valueOf(this.template.getProjectTemplatesLocation(this.getProperty("WebNatureOperation.TEMPLATE_VERSION_ID"))) + "/" + this.getProperty("WebNatureOperation.TEMPLATE_ID") + "/";
        File sf = new File(String.valueOf(templateFolder) + ".settings/org.jboss.tools.jst.web.xml");
        String tf = String.valueOf(p.getProperty("location")) + "/" + ".settings/org.jboss.tools.jst.web.xml";
        if (!sf.exists()) {
            throw new RuntimeException("Project template must have model configuration file");
        }
        FileUtil.copyFile((File)sf, (File)new File(tf), (boolean)true);
        this.projectFile = new File(tf);
    }

    protected void createTemplateModel() {
        if (this.templateModel != null) {
            return;
        }
        String templateLocation = this.getTemplateLocation();
        Properties p = new Properties();
        p.putAll((Map<?, ?>)System.getProperties());
        String workspace = new ProjectHome().getLocation(templateLocation);
        p.setProperty(XModelConstants.WORKSPACE, workspace);
        p.setProperty(XModelConstants.WORKSPACE_OLD, workspace);
        p.setProperty("eclipse.project", templateLocation);
        this.templateModel = XModelFactory.getModel((Properties)p);
    }

    protected String getTemplateLocation() {
        String fileName = String.valueOf(this.template.getProjectTemplatesLocation(this.getProperty("WebNatureOperation.TEMPLATE_VERSION_ID"))) + "/" + this.getProperty("WebNatureOperation.TEMPLATE_ID") + "/";
        try {
            return new File(fileName).getCanonicalPath();
        }
        catch (IOException iOException) {
            WebUiPlugin.getPluginLog().logError("Cannot find folder '" + fileName + "'", null);
            return fileName;
        }
    }

    @Override
    protected boolean checkOverwrite() {
        String message;
        ServiceDialog dlg;
        int selAction;
        File[] cs;
        String location = this.getProperty("WebNatureOperation.PROJECT_LOCATION_ID");
        if (location == null) {
            return true;
        }
        File targetFile = new File(location);
        File[] fileArray = cs = targetFile.exists() ? targetFile.listFiles() : null;
        return cs == null || cs.length <= 0 || (selAction = (dlg = PreferenceModelUtilities.getPreferenceModel().getService()).showDialog(Messages.COD_TITLE, message = MessageFormat.format(Messages.COD_MESSAGE, location), new String[]{Messages.BTN_OK, Messages.BTN_CANCEL}, null, 2)) == 0;
    }

    private String[] getJavaSources() {
        String s;
        File f;
        XModelObject o;
        try {
            this.createTemplateModel();
        }
        catch (Exception e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        if (this.templateModel != null && (o = FileSystemsHelper.getFileSystem((XModel)this.templateModel, (String)"src")) instanceof FileSystemImpl && (f = new File(s = ((FileSystemImpl)o).getAbsoluteLocation())).exists()) {
            return new String[]{f.getName()};
        }
        return new String[0];
    }
}

