/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.util;

import java.io.InputStream;
import java.io.Reader;
import org.eclipse.jface.text.rules.IToken;
import org.jboss.tools.common.text.ext.util.TextScanner;

public class CSSTextScanner
extends TextScanner {
    public static final String CSS_CLASS_NAME = "___css_class_name";
    public static final String CSS_CLASS_NAME_SEPARATOR = "___css_class_name_separator";
    public static final String CSS_CLASS_BODY = "___css_class_body";
    public static final String CSS_CLASS_COMMENT = "___css_class_comment";
    private static final int STATE_START = 0;
    private static final int STATE_NAME = 1;
    private static final int STATE_NAME_SEPARATOR = 2;
    private static final int STATE_BODY = 3;
    private static final int STATE_COMMENT = 4;
    private static final int STATE_END = 5;
    private int state = 0;
    private int savedForCommentState;

    public CSSTextScanner(InputStream stream) {
        super(stream);
    }

    public CSSTextScanner(Reader reader) {
        super(reader);
    }

    private void setState(int newState) {
        if (this.state != 4) {
            this.savedForCommentState = this.state;
        }
        this.state = newState;
    }

    public IToken nextToken() {
        this.offset += this.length;
        switch (this.state) {
            case 0: 
            case 2: {
                return this.nextNameSeparatorToken();
            }
            case 1: {
                return this.nextNameToken();
            }
            case 3: {
                return this.nextBodyToken();
            }
            case 4: {
                return this.nextCommentToken();
            }
        }
        return this.nextEndToken();
    }

    private IToken nextNameToken() {
        int ch = this.read();
        if (ch == -1) {
            return this.getToken(CSS_CLASS_NAME);
        }
        if (!NMTOKEN_DETECTOR.isWordStart((char)ch)) {
            this.clearText();
            return this.getToken(CSS_CLASS_NAME);
        }
        ch = this.read();
        while (ch != -1) {
            if (!NMTOKEN_DETECTOR.isWordPart((char)ch)) {
                this.unread();
                this.state = 2;
                return this.getToken(CSS_CLASS_NAME);
            }
            ch = this.read();
        }
        return this.getToken(CSS_CLASS_NAME);
    }

    private IToken nextNameSeparatorToken() {
        int count = this.skipWhitespaceToken();
        if (count > 0) {
            this.state = 2;
            return this.getToken(null);
        }
        int ch = this.read();
        int readsCount = 0;
        while (ch != -1) {
            if (NMTOKEN_DETECTOR.isWordStart((char)ch)) {
                this.unread();
                this.state = 1;
                return readsCount > 0 ? this.getToken(CSS_CLASS_NAME_SEPARATOR) : this.nextNameToken();
            }
            if (ch == 123) {
                this.unread();
                this.state = 3;
                return readsCount > 0 ? this.getToken(CSS_CLASS_NAME_SEPARATOR) : this.nextBodyToken();
            }
            if (ch == 47) {
                ch = this.read();
                if (ch == -1) break;
                if (ch == 42) {
                    this.unread();
                    this.unread();
                    this.setState(4);
                    if (readsCount > 0) {
                        return this.getToken(CSS_CLASS_NAME_SEPARATOR);
                    }
                    return this.nextCommentToken();
                }
                this.clearText();
                return this.getToken(CSS_CLASS_NAME_SEPARATOR);
            }
            ++readsCount;
            ch = this.read();
        }
        this.state = 5;
        return this.getToken(CSS_CLASS_NAME_SEPARATOR);
    }

    private IToken nextBodyToken() {
        int level = 0;
        int ch = this.read();
        while (ch != -1) {
            if (ch == 123) {
                ++level;
            } else if (ch == 125 && --level <= 0) {
                this.state = 0;
                return this.getToken(CSS_CLASS_BODY);
            }
            if (ch == 47) {
                ch = this.read();
                if (ch == -1) break;
                if (ch == 42) {
                    this.unread();
                    this.unread();
                    this.setState(4);
                    return this.getToken(CSS_CLASS_BODY);
                }
                this.clearText();
                return this.getToken(CSS_CLASS_BODY);
            }
            ch = this.read();
        }
        this.state = 5;
        return this.getToken(CSS_CLASS_BODY);
    }

    private IToken nextCommentToken() {
        int ch = this.read();
        while (ch != -1) {
            if (ch == 42) {
                ch = this.read();
                if (ch == -1) break;
                if (ch == 47) {
                    this.setState(this.savedForCommentState);
                    return this.getToken(CSS_CLASS_COMMENT);
                }
                this.unread();
            }
            ch = this.read();
        }
        this.setState(this.savedForCommentState);
        return this.getToken(CSS_CLASS_COMMENT);
    }

    private IToken nextEndToken() {
        this.state = 5;
        this.clearText();
        return this.getToken(null);
    }
}

