/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPXmlNsHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String JSP_XMLNS_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_XMLNS";

    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (!(n instanceof IDOMAttr)) {
                return null;
            }
            IDOMAttr xmlnsAttr = (IDOMAttr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().startsWith("xmlns:")) {
                return null;
            }
            Element rootElem = xmlnsAttr.getOwnerElement();
            if (!rootElem.getNodeName().equals("jsp:root") && !rootElem.getNodeName().equalsIgnoreCase("html")) {
                return null;
            }
            xmlnsAttr.getValueRegionText();
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = JSP_XMLNS_PARTITION;
            int start = Utils.getValueStart((Node)xmlnsAttr);
            int end = Utils.getValueEnd((Node)xmlnsAttr);
            String text = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(propStart, propLength, axis, contentType, type);
            return hyperlinkRegion;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, int offset, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (!(n instanceof Attr)) {
                return false;
            }
            Attr xmlnsAttr = (Attr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().startsWith("xmlns:")) {
                return false;
            }
            Element rootElem = xmlnsAttr.getOwnerElement();
            return rootElem.getNodeName().equals("jsp:root") || rootElem.getNodeName().equalsIgnoreCase("html");
            {
            }
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, int offset) {
        return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis(document, offset)) + "/";
    }
}

