/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.ELSegmentImpl;
import org.jboss.tools.common.el.core.resolver.IOpenableReference;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.ELHyperlink;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.ELVarListHyperlink;

public class ELHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ELInvocationExpression expression;
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        ELContext context = PageContextFactory.createPageContext((IFile)file);
        if (context == null) {
            return null;
        }
        ArrayList<AbstractHyperlink> links = new ArrayList<AbstractHyperlink>();
        ELReference reference = context.getELReference(region.getOffset());
        if (reference != null && (expression = ELHyperlinkDetector.findInvocationExpressionByOffset(reference, region.getOffset())) != null) {
            IOpenableReference[] openables;
            ELResolver[] resolvers = context.getElResolvers();
            ELSegment unresolved = null;
            ELResolver[] eLResolverArray = resolvers;
            int n = resolvers.length;
            int n2 = 0;
            while (n2 < n) {
                ELResolver resolver = eLResolverArray[n2];
                ELResolution resolution = resolver.resolve(context, (ELExpression)expression, region.getOffset());
                if (resolution != null) {
                    ELSegment segment = resolution.findSegmentByOffset(region.getOffset() - reference.getStartPosition());
                    if (segment != null && segment.isResolved()) {
                        IOpenableReference[] openables2 = segment.getOpenable();
                        if (openables2.length == 0) {
                            links.add(new ELHyperlink(textViewer.getDocument(), reference, segment, null));
                        } else {
                            ArrayList<ELHyperlink> vars = new ArrayList<ELHyperlink>();
                            IOpenableReference[] iOpenableReferenceArray = openables2;
                            int n3 = openables2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IOpenableReference openable = iOpenableReferenceArray[n4];
                                ELHyperlink link = new ELHyperlink(textViewer.getDocument(), reference, segment, openable);
                                if (openable instanceof ELSegmentImpl.VarOpenable) {
                                    vars.add(link);
                                } else {
                                    links.add(link);
                                }
                                ++n4;
                            }
                            if (!vars.isEmpty()) {
                                if (vars.size() == 1) {
                                    links.add(0, (AbstractHyperlink)((IHyperlink)vars.get(0)));
                                } else {
                                    links.add(0, new ELVarListHyperlink(textViewer, reference, segment, vars.toArray(new ELHyperlink[0])));
                                }
                            }
                        }
                    } else if (segment != null && ((ELSegmentImpl)segment).getVar() != null && unresolved == null && segment.getOpenable().length > 0) {
                        unresolved = segment;
                    }
                }
                ++n2;
            }
            if (links.isEmpty() && unresolved != null && (openables = unresolved.getOpenable()).length > 0) {
                IOpenableReference[] iOpenableReferenceArray = openables;
                int n5 = openables.length;
                n = 0;
                while (n < n5) {
                    IOpenableReference openable = iOpenableReferenceArray[n];
                    links.add(new ELHyperlink(textViewer.getDocument(), reference, unresolved, openable));
                    ++n;
                }
            }
        }
        if (links.size() == 0) {
            return null;
        }
        return links.toArray(new IHyperlink[links.size()]);
    }

    public static ELInvocationExpression findInvocationExpressionByOffset(ELReference reference, int offset) {
        ELExpression[] eLExpressionArray = reference.getEl();
        int n = eLExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ELInvocationExpression invocation;
            ELExpression expression = eLExpressionArray[n2];
            if (reference.getStartPosition() + expression.getStartPosition() <= offset && reference.getStartPosition() + expression.getEndPosition() > offset && (invocation = ELHyperlinkDetector.findInvocationExpressionByOffset(reference, expression, offset)) != null) {
                return invocation;
            }
            ++n2;
        }
        return null;
    }

    private static ELInvocationExpression findInvocationExpressionByOffset(ELReference reference, ELExpression expression, int offset) {
        List invocations = expression.getInvocations();
        Object result = null;
        for (ELInvocationExpression invocation : invocations) {
            if (reference.getStartPosition() + invocation.getStartPosition() > offset || reference.getStartPosition() + invocation.getEndPosition() <= offset || result != null && result.toString().length() <= invocation.toString().length()) continue;
            result = invocation;
        }
        return result;
    }

    private IFile getFile() {
        IEditorInput input;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part != null && (input = part.getEditorInput()) instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }
}

