/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.IOpenableReference;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegment;
import org.jboss.tools.common.el.core.resolver.MessagePropertyELSegment;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.common.util.StringUtil;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

public class ELHyperlink
extends AbstractHyperlink {
    private ELReference reference;
    private ELSegment segment;
    IOpenableReference openable;

    public ELHyperlink(IDocument document, ELReference reference, ELSegment segment, IOpenableReference openable) {
        this.reference = reference;
        this.segment = segment;
        this.openable = openable;
        this.setDocument(document);
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        IRegion region = super.doGetHyperlinkRegion(offset);
        return region != null ? region : new HyperlinkRegion(this.reference.getStartPosition() + this.segment.getSourceReference().getStartPosition(), this.segment.getSourceReference().getLength());
    }

    protected void doHyperlink(IRegion region) {
        if (this.openable != null) {
            if (!this.openable.open()) {
                this.openFileFailed();
            }
            return;
        }
        ITextSourceReference ref = this.segment.getSourceReference();
        if (ref != null) {
            IFile file;
            IResource r = ref.getResource();
            IFile iFile = file = r instanceof IFile ? (IFile)r : null;
            if (file == null || !file.exists() || !file.isAccessible()) {
                this.openFileFailed();
                return;
            }
            if (this.openFileInEditor(file) != null && ref.getStartPosition() >= 0 && ref.getLength() > 0) {
                StructuredSelectionHelper.setSelectionAndRevealInActiveEditor((IRegion)new Region(ref.getStartPosition(), ref.getLength()));
                return;
            }
        }
    }

    public String getHyperlinkText() {
        if (this.openable != null) {
            return this.openable.getLabel();
        }
        if (this.segment instanceof JavaMemberELSegment) {
            return "Should not get here.";
        }
        if (this.segment instanceof MessagePropertyELSegment) {
            String propertyName;
            String baseName = ((MessagePropertyELSegment)this.segment).getBaseName();
            String string = propertyName = ((MessagePropertyELSegment)this.segment).isBundle() ? null : StringUtil.trimQuotes((String)((MessagePropertyELSegment)this.segment).getToken().getText());
            if (propertyName == null) {
                return MessageFormat.format(Messages.Open, baseName);
            }
            return MessageFormat.format(Messages.OpenBundleProperty, propertyName, baseName);
        }
        return "";
    }

    public IFile getReadyToOpenFile() {
        IFile file = null;
        if (this.segment instanceof JavaMemberELSegment) {
            try {
                file = (IFile)((JavaMemberELSegment)this.segment).getJavaElement().getUnderlyingResource();
            }
            catch (JavaModelException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        } else if (this.segment instanceof MessagePropertyELSegment) {
            file = ((MessagePropertyELSegment)this.segment).getMessageBundleResource();
        }
        return file;
    }
}

