/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CSSClassHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String CSS_CLASS_PARTITION = "org.jboss.tools.common.text.ext.CSS_CLASS";
    private static final String CSS_CLASS_TOKEN = "/class/";
    private static final String EXCLUSION_TOKEN = "jsp:usebean/class/";

    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = this.getPartitionType(axis);
            IRegion r = this.getRegion(document, offset);
            if (r == null) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(r.getOffset(), r.getLength(), axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getPartitionType(String axis) {
        return CSS_CLASS_PARTITION;
    }

    public boolean recognize(IDocument document, int offset, IHyperlinkRegion region) {
        return region.getAxis() != null && region.getAxis().toLowerCase().endsWith(CSS_CLASS_TOKEN) && !region.getAxis().toLowerCase().endsWith(EXCLUSION_TOKEN);
    }

    protected IRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '_' && sb.charAt(bStart) != '-' && sb.charAt(bStart) != '.') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '_' && sb.charAt(bEnd) != '-' && sb.charAt(bEnd) != '.') break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

