/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.kb.ICSSContainerSupport;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSClassHyperlink
extends AbstractHyperlink {
    CSSRuleDescriptorSorter SORTER = new CSSRuleDescriptorSorter();
    private static final char[] SPACE_CHARS = new char[]{' ', '\t', '\r', '\n', '\f'};
    public static final String[] STYLE_TAGS = new String[]{"style", "link"};
    public static final String LINK_TAG = "link";
    public static final String HREF_ATTRIBUTE = "href";
    public static final String CONTEXT_PATH_EXPRESSION = "^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}";

    protected void doHyperlink(IRegion region) {
        CSSRuleDescriptor[] sorted;
        ICSSContainerSupport cssContainerSupport = null;
        ELContext context = PageContextFactory.createPageContext((IDocument)this.getDocument());
        if (!(context instanceof ICSSContainerSupport)) {
            this.openFileFailed();
            return;
        }
        cssContainerSupport = (ICSSContainerSupport)context;
        List descrs = cssContainerSupport.getCSSStyleSheetDescriptors();
        ArrayList<CSSRuleDescriptor> bestMatchDescriptors = new ArrayList<CSSRuleDescriptor>();
        int i = descrs == null ? -1 : descrs.size() - 1;
        while (descrs != null && i >= 0) {
            PageContextFactory.CSSStyleSheetDescriptor descr = (PageContextFactory.CSSStyleSheetDescriptor)descrs.get(i);
            CSSStyleSheet sheet = descr.getStylesheet();
            if (sheet != null) {
                CSSRuleList rules = sheet.getCssRules();
                int r = 0;
                while (rules != null && r < rules.getLength()) {
                    Set<CSSRuleDescriptor> matches = this.getMatchedRuleDescriptors(rules.item(r), this.getStyleName(region));
                    for (CSSRuleDescriptor match : matches) {
                        match.stylesheetDescriptor = descr;
                        bestMatchDescriptors.add(match);
                    }
                    ++r;
                }
            }
            --i;
        }
        CSSRuleDescriptor[] cSSRuleDescriptorArray = sorted = this.orderCSSRuleDescriptors(bestMatchDescriptors.toArray(new CSSRuleDescriptor[bestMatchDescriptors.size()]));
        int n = sorted.length;
        int n2 = 0;
        while (n2 < n) {
            CSSRuleDescriptor d = cSSRuleDescriptorArray[n2];
            PageContextFactory.CSSStyleSheetDescriptor descr = d.stylesheetDescriptor;
            IFile file = this.findFileForCSSStyleSheet(descr.getFilePath());
            if (file != null) {
                int startOffset = 0;
                CSSStyleSheet sheet = descr.getStylesheet();
                if (sheet != null && descr.getContainerNode() != null) {
                    Node node = descr.getContainerNode().getFirstChild();
                    if (node instanceof IndexedRegion) {
                        startOffset = ((IndexedRegion)node).getStartOffset();
                    }
                    this.showRegion(file, (IRegion)new Region(startOffset + ((IndexedRegion)d.rule).getStartOffset(), ((IndexedRegion)d.rule).getLength()));
                    return;
                }
            }
            ++n2;
        }
        this.openFileFailed();
    }

    protected CSSRuleDescriptor[] orderCSSRuleDescriptors(CSSRuleDescriptor[] descriptors) {
        Object[] sorted = this.SORTER.sort(descriptors);
        CSSRuleDescriptor[] sortedDescriptors = new CSSRuleDescriptor[sorted.length];
        System.arraycopy(sorted, 0, sortedDescriptors, 0, sorted.length);
        return sortedDescriptors;
    }

    private IFile findFileForCSSStyleSheet(String filePath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(filePath));
        if (file != null) {
            return file;
        }
        Path path = new Path(filePath);
        if (path.isAbsolute()) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects(8);
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                IPath projectLocation = project.getLocation();
                if (projectLocation != null && projectLocation.lastSegment().equals(path.segment(0))) {
                    IPath projectRelatedPath = projectLocation.append(path.removeFirstSegments(1));
                    file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(projectRelatedPath);
                    if (file != null) {
                        return file;
                    }
                }
                ++i;
            }
        }
        return PageContextFactory.getFileFromProject((String)filePath, (IFile)this.getFile());
    }

    protected Set<CSSRuleDescriptor> getMatchedRuleDescriptors(CSSRule cssRule, String styleName) {
        HashSet<CSSRuleDescriptor> matches = new HashSet<CSSRuleDescriptor>();
        if (cssRule instanceof CSSMediaRule) {
            CSSMediaRule cssMediaRule = (CSSMediaRule)cssRule;
            CSSRuleList rules = cssMediaRule.getCssRules();
            int i = 0;
            while (rules != null && i < rules.getLength()) {
                CSSRule rule = rules.item(i);
                Set<CSSRuleDescriptor> descrs = this.getMatchedRuleDescriptors(rule, styleName);
                if (descrs != null) {
                    matches.addAll(descrs);
                }
                ++i;
            }
            return matches;
        }
        if (!(cssRule instanceof CSSStyleRule)) {
            return matches;
        }
        String selectorText = ((CSSStyleRule)cssRule).getSelectorText();
        if (selectorText == null) {
            return null;
        }
        String[] selectors = this.getSelectors(selectorText);
        if (selectors.length == 0) {
            return null;
        }
        String[] stringArray = selectors;
        int n = selectors.length;
        int n2 = 0;
        while (n2 < n) {
            String selector = stringArray[n2];
            String[] simpleSelectors = this.getSimpleSelectors(selector);
            if (simpleSelectors.length != 0) {
                ArrayList<CSSAxis> axisList = new ArrayList<CSSAxis>();
                String[] stringArray2 = simpleSelectors;
                int n3 = simpleSelectors.length;
                int n4 = 0;
                while (n4 < n3) {
                    String simpleSelector = stringArray2[n4];
                    if (simpleSelector.length() > 0) {
                        axisList.add(new CSSAxis(simpleSelector));
                    }
                    ++n4;
                }
                if (axisList.size() > 0) {
                    CSSAxis[] axis = axisList.toArray(new CSSAxis[0]);
                    if (this.matchesRule(this.getHyperlinkRegion(), axis)) {
                        matches.add(new CSSRuleDescriptor(selector, cssRule, axis));
                    }
                }
            }
            ++n2;
        }
        return matches;
    }

    private String[] getSelectors(String selectorText) {
        ArrayList<String> selectors = new ArrayList<String>();
        String rest = selectorText.trim().toLowerCase();
        int index = -1;
        while ((index = this.getIndexOfCharNotQuotted(rest, ',')) != -1) {
            String selector = rest.substring(0, index).trim();
            rest = rest.substring(index + 1).trim();
            if (selector.length() <= 0) continue;
            selectors.add(selector);
        }
        if (rest.length() > 0) {
            selectors.add(rest);
        }
        return selectors.toArray(new String[0]);
    }

    private String[] getSimpleSelectors(String selector) {
        ArrayList<String> simpleSelectors = new ArrayList<String>();
        String rest = this.dropWSCharsInBrackets(selector);
        int index = -1;
        while ((index = this.getIndexOfCharNotQuotted(rest, SPACE_CHARS)) != -1) {
            String simpleSelector = rest.substring(0, index).trim();
            rest = rest.substring(index + 1).trim();
            if (simpleSelector.length() <= 0) continue;
            simpleSelectors.add(simpleSelector);
        }
        if (rest.length() > 0) {
            simpleSelectors.add(rest);
        }
        return simpleSelectors.toArray(new String[0]);
    }

    private String dropWSCharsInBrackets(String selector) {
        char pair = '\u0000';
        char pairBracket = '\u0000';
        boolean inQuotes = false;
        boolean inBrackets = false;
        StringBuilder sb = new StringBuilder();
        if (selector != null) {
            char[] cArray = selector.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char character = cArray[n2];
                if (inQuotes) {
                    sb.append(character);
                    if (character == pair) {
                        inQuotes = false;
                    }
                } else if (character == '\"' || character == '\'') {
                    pair = character;
                    inQuotes = true;
                    sb.append(character);
                } else if (inBrackets) {
                    boolean wsChar = false;
                    char[] cArray2 = SPACE_CHARS;
                    int n3 = SPACE_CHARS.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        char ch = cArray2[n4];
                        if (character == ch) {
                            wsChar = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!wsChar) {
                        sb.append(character);
                    }
                    if (character == pairBracket) {
                        pairBracket = '\u0000';
                        inBrackets = false;
                    }
                } else {
                    sb.append(character);
                    if (character == '[') {
                        pairBracket = ']';
                        inBrackets = true;
                    } else if (character == '(') {
                        pairBracket = ')';
                        inBrackets = true;
                    }
                }
                ++n2;
            }
        }
        return sb.toString();
    }

    private boolean matchesRule(IRegion styleNameRegion, CSSAxis[] cssAxis) {
        if (cssAxis == null || cssAxis.length == 0) {
            return false;
        }
        String classNameFromTheRegion = this.getStyleName(styleNameRegion);
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node node = Utils.findNodeForOffset((Node)xmlDocument, (int)styleNameRegion.getOffset());
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                node = attr.getOwnerElement();
            }
            int i = cssAxis.length - 1;
            while (i >= 0) {
                boolean attrFound;
                boolean nodeFound;
                boolean classFound;
                CSSAxis currentAxis = cssAxis[i];
                do {
                    String nodeClasses;
                    String[] classes;
                    classFound = currentAxis.classNames.isEmpty() && currentAxis.pseudoClasses.isEmpty();
                    nodeFound = currentAxis.elementName == "*" && currentAxis.pseudoElements.isEmpty();
                    boolean bl = attrFound = currentAxis.attributes.isEmpty() && currentAxis.idAttributeValues.isEmpty();
                    if (!classFound && (classes = this.getSimpleSelectors((nodeClasses = i == cssAxis.length - 1 ? classNameFromTheRegion : this.getNodeAttributeValue(node, "class")) == null ? "" : nodeClasses.toLowerCase())) != null) {
                        String[] stringArray = classes;
                        int n = classes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String cssClass = stringArray[n2];
                            if (currentAxis.classNames.contains(cssClass) || currentAxis.pseudoClasses.contains(cssClass)) {
                                classFound = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!nodeFound) {
                        boolean bl2 = nodeFound = currentAxis.elementName.equalsIgnoreCase(node.getNodeName()) || currentAxis.pseudoElements.contains(node.getNodeName().toLowerCase());
                    }
                    if (!attrFound) {
                        boolean allValuesAreOK = true;
                        for (String attrName : currentAxis.attributes.keySet()) {
                            String attrValue = Utils.trimQuotes((String)currentAxis.attributes.get(attrName));
                            if (attrValue.equalsIgnoreCase(Utils.trimQuotes((String)this.getNodeAttributeValue(node, attrName)))) continue;
                            allValuesAreOK = false;
                            break;
                        }
                        if (currentAxis.idAttributeValues.size() > 0) {
                            String nodeIDAttributeValue = Utils.trimQuotes((String)this.getNodeAttributeValue(node, "id"));
                            allValuesAreOK &= currentAxis.idAttributeValues.contains(nodeIDAttributeValue == null ? null : nodeIDAttributeValue.toLowerCase());
                        }
                        attrFound = allValuesAreOK;
                    }
                    node = node.getParentNode();
                } while ((!classFound || !nodeFound || !attrFound) && node instanceof Element);
                if (!(node instanceof Element)) {
                    return false;
                }
                --i;
            }
            return true;
        }
        finally {
            smw.dispose();
        }
    }

    private String getNodeAttributeValue(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        int i = 0;
        while (attrs != null && i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().toLowerCase().equalsIgnoreCase(attrName)) {
                return attr.getValue();
            }
            ++i;
        }
        return null;
    }

    private int getIndexOfCharNotQuotted(String text, char ch) {
        return this.getIndexOfCharNotQuotted(text, new char[]{ch});
    }

    private int getIndexOfCharNotQuotted(String text, char[] chars) {
        return this.getIndexOfCharNotQuotted(text, chars, 0);
    }

    private int getIndexOfCharNotQuotted(String text, char[] chars, int start) {
        int offset = start;
        int n = -1;
        boolean inQuotes = false;
        while (offset < text.length()) {
            char c;
            char character = text.charAt(offset);
            if (inQuotes) {
                if (character == c) {
                    inQuotes = false;
                }
            } else if (character == '\"' || character == '\'') {
                c = character;
                inQuotes = true;
            } else {
                char[] cArray = chars;
                int n2 = chars.length;
                int n3 = 0;
                while (n3 < n2) {
                    char ch = cArray[n3];
                    if (character == ch) {
                        return offset;
                    }
                    ++n3;
                }
            }
            ++offset;
        }
        return -1;
    }

    protected void showRegion(IFile file, IRegion region) {
        IWorkbenchPage workbenchPage = ExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = null;
        if (file != null) {
            try {
                part = IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        if (part == null) {
            this.openFileFailed();
            return;
        }
        StructuredSelectionHelper.setSelectionAndReveal(part, (IRegion)region);
    }

    protected String getStyleName(IRegion region) {
        if (region != null) {
            try {
                return this.getDocument().get(region.getOffset(), region.getLength()).trim();
            }
            catch (BadLocationException e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public String getHyperlinkText() {
        String styleName = this.getStyleName(this.getHyperlinkRegion());
        if (styleName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.CSSStyle);
        }
        return MessageFormat.format(Messages.OpenCSSStyle, styleName);
    }

    protected String findAndReplaceElVariable(String fileName) {
        if (fileName != null) {
            fileName = fileName.replaceFirst(CONTEXT_PATH_EXPRESSION, "");
        }
        return super.findAndReplaceElVariable(fileName);
    }

    class CSSAxis {
        static final String CSS_ANY = "*";
        static final int AXIS_TYPE_ANY = 0;
        static final int AXIS_TYPE_IMMEDIATELY_FOLLOWS = 1;
        static final int AXIS_TYPE_CHILD_OF_PARENT = 2;
        final String[] VALID_PSEUDO_CLASSES = new String[]{"first-element", "link", "visited", "hover", "active", "focus", "lang"};
        final String[] VALID_PSEUDO_ELEMENTS = new String[]{"first-line", "first-letter", "before", "after"};
        int type = 0;
        Set<String> classNames = new HashSet<String>();
        String elementName = "*";
        Set<String> pseudoClasses = new HashSet<String>();
        Set<String> pseudoElements = new HashSet<String>();
        Set<String> idAttributeValues = new HashSet<String>();
        Map<String, String> attributes = new HashMap<String, String>();

        CSSAxis(String simpleSelector) {
            char[] cArray;
            int n;
            String rest = simpleSelector.trim().toLowerCase();
            if (rest.length() == 1) {
                if (rest.charAt(0) == '>') {
                    this.type = 2;
                    return;
                }
                if (rest.charAt(0) == '+') {
                    this.type = 1;
                    return;
                }
            }
            if (rest.length() > 0) {
                if (rest.charAt(0) == '*') {
                    rest = rest.substring(1).trim();
                } else {
                    StringBuilder sb = new StringBuilder();
                    char[] cArray2 = rest.toCharArray();
                    n = cArray2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char ch = cArray2[n2];
                        if (!Character.isJavaIdentifierPart(ch) && ch != '-' && ch != '_') break;
                        sb.append(ch);
                        ++n2;
                    }
                    if (sb.length() > 0) {
                        this.elementName = sb.toString();
                        rest = rest.substring(sb.length()).trim();
                    }
                }
            }
            int index = -1;
            while ((index = CSSClassHyperlink.this.getIndexOfCharNotQuotted(rest, '[')) != -1) {
                int start = index;
                int end = CSSClassHyperlink.this.getIndexOfCharNotQuotted(rest, ']');
                String attrName = null;
                String attrValue = null;
                String attribute = (end == -1 ? rest.substring(start + 1) : rest.substring(start + 1, end)).trim();
                rest = (end == -1 ? "" : rest.substring(end + 1)).trim();
                if (attribute.startsWith("[")) {
                    attribute = attribute.substring(1).trim();
                }
                if (attribute.endsWith("]")) {
                    attribute = attribute.substring(0, attribute.length() - 1).trim();
                }
                StringBuilder sb = new StringBuilder();
                char[] cArray3 = attribute.toCharArray();
                int n3 = cArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    char ch = cArray3[n4];
                    if (!Character.isJavaIdentifierPart(ch) && ch != '-' && ch != '_') break;
                    sb.append(ch);
                    ++n4;
                }
                if (sb.length() <= 0) continue;
                attrName = sb.toString();
                if (((attribute = attribute.substring(sb.length()).trim()).startsWith("=") || attribute.startsWith("~=") || attribute.startsWith("|=")) && (attrValue = (attribute = attribute.charAt(0) == '=' ? attribute.substring(1).trim() : attribute.substring(2).trim()).trim()).length() == 0) {
                    attrValue = CSS_ANY;
                }
                this.attributes.put(attrName, attrValue);
            }
            while ((index = rest.indexOf(35)) != -1) {
                String idAttributeValue;
                StringBuilder sb = new StringBuilder();
                cArray = rest.substring(index + 1).toCharArray();
                int n5 = cArray.length;
                n = 0;
                while (n < n5) {
                    char ch = cArray[n];
                    if (ch == '#' || ch == '.' || ch == ':') break;
                    sb.append(ch);
                    ++n;
                }
                rest = String.valueOf(rest.substring(0, index)) + rest.substring(index + sb.length() + 1);
                if (sb.length() <= 0 || (idAttributeValue = sb.toString().trim()).length() <= 0) continue;
                this.idAttributeValues.add(idAttributeValue);
            }
            while ((index = rest.indexOf(46)) != -1) {
                String className;
                StringBuilder sb = new StringBuilder();
                cArray = rest.substring(index + 1).toCharArray();
                int n6 = cArray.length;
                n = 0;
                while (n < n6) {
                    char ch = cArray[n];
                    if (ch == '#' || ch == '.' || ch == ':') break;
                    sb.append(ch);
                    ++n;
                }
                rest = String.valueOf(rest.substring(0, index)) + rest.substring(index + sb.length() + 1);
                if (sb.length() <= 0 || (className = sb.toString().trim()).length() <= 0) continue;
                this.classNames.add(className);
            }
            while ((index = rest.indexOf(58)) != -1) {
                StringBuilder sb = new StringBuilder();
                cArray = rest.substring(index + 1).toCharArray();
                int n7 = cArray.length;
                n = 0;
                while (n < n7) {
                    char ch = cArray[n];
                    if (ch == '#' || ch == '.' || ch == ':') break;
                    sb.append(ch);
                    ++n;
                }
                rest = String.valueOf(rest.substring(0, index)) + rest.substring(index + sb.length() + 1);
                if (sb.length() <= 0) continue;
                String pseudo = sb.toString().trim();
                if (this.isValidPseudo(pseudo, this.VALID_PSEUDO_CLASSES)) {
                    this.pseudoClasses.add(pseudo);
                    continue;
                }
                if (!this.isValidPseudo(pseudo, this.VALID_PSEUDO_ELEMENTS)) continue;
                this.pseudoElements.add(pseudo);
            }
        }

        boolean isValidPseudo(String pseudo, String[] template) {
            if (template == null) {
                return false;
            }
            String string = pseudo = pseudo == null ? "" : pseudo.toLowerCase();
            if (pseudo.indexOf(40) != -1) {
                pseudo = pseudo.substring(0, pseudo.indexOf(40)).trim();
            }
            String[] stringArray = template;
            int n = template.length;
            int n2 = 0;
            while (n2 < n) {
                String valid = stringArray[n2];
                if (pseudo.startsWith(valid.toLowerCase())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    class CSSRuleDescriptor {
        String selector;
        CSSRule rule;
        CSSAxis[] axis;
        PageContextFactory.CSSStyleSheetDescriptor stylesheetDescriptor;

        CSSRuleDescriptor(String selector, CSSRule rule, CSSAxis[] axis) {
            this.selector = selector;
            this.rule = rule;
            this.axis = axis;
        }

        public String toString() {
            return this.selector;
        }
    }

    class CSSRuleDescriptorSorter
    extends Sorter {
        CSSRuleDescriptorSorter() {
        }

        public boolean compare(Object descr1, Object descr2) {
            CSSAxis[] a1 = ((CSSRuleDescriptor)descr1).axis;
            CSSAxis[] a2 = ((CSSRuleDescriptor)descr2).axis;
            return this.calcImportance(a1) > this.calcImportance(a2);
        }

        long calcImportance(CSSAxis[] axis) {
            int b = 0;
            int c = 0;
            int d = 0;
            CSSAxis[] cSSAxisArray = axis;
            int n = axis.length;
            int n2 = 0;
            while (n2 < n) {
                CSSAxis a = cSSAxisArray[n2];
                b = (short)(b + a.idAttributeValues.size());
                c = (short)(c + (a.attributes.size() + a.classNames.size() + a.pseudoClasses.size()));
                d = (short)(d + (("*".equals(a.elementName) ? 0 : 1) + a.pseudoElements.size()));
                ++n2;
            }
            return (b << 32) + (c << 16) + d;
        }
    }
}

