/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties.html;

import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.html.HTMLConstants;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.AbstractAdvancedPropertySetViewer;
import org.w3c.dom.Element;

public class HTMLPropertySetContext
implements HTMLConstants {
    protected AbstractAdvancedPropertySetViewer viewer;
    protected String elementName = "";
    protected String typeName = "";
    static String[] PATTERN_TEXT_TYPES = new String[]{"text", "search", "url", "tel", "email", "password"};

    public HTMLPropertySetContext(AbstractAdvancedPropertySetViewer viewer) {
        this.viewer = viewer;
    }

    public Element getElement() {
        Object value = this.viewer.getModel().getValue();
        return value instanceof Element ? (Element)value : null;
    }

    public boolean update() {
        boolean isModified = false;
        Element element = this.getElement();
        if (element != null) {
            if (!element.getNodeName().equals(this.elementName)) {
                this.elementName = element.getNodeName();
                isModified = true;
            }
            String newTypeName = "";
            if ("input".equals(this.elementName) && XMLUtilities.hasAttribute((Element)element, (String)"type")) {
                newTypeName = element.getAttribute("type");
            }
            if (!newTypeName.equals(this.typeName)) {
                this.typeName = newTypeName;
                isModified = true;
            }
        }
        return isModified;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isInput() {
        return "input".equalsIgnoreCase(this.elementName);
    }

    public boolean isNumberType() {
        return this.isInput() && "number".equals(this.typeName);
    }

    public boolean isRangeType() {
        return this.isInput() && "range".equals(this.typeName);
    }

    public boolean isButtonType() {
        return this.isInput() && ("button".equals(this.typeName) || "reset".equals(this.typeName) || "submit".equals(this.typeName));
    }

    public boolean isCheckbox() {
        return this.isInput() && "checkbox".equals(this.typeName);
    }

    public boolean isRadio() {
        return this.isInput() && "radio".equals(this.typeName);
    }

    public boolean isPatternTextType() {
        if (this.isInput() && this.typeName != null) {
            String[] stringArray = PATTERN_TEXT_TYPES;
            int n = PATTERN_TEXT_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (this.typeName.equals(s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isTextType() {
        if (this.isInput() && this.typeName != null) {
            String[] stringArray = TEXT_TYPES;
            int n = TEXT_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (this.typeName.equals(s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isFileType() {
        return "file".equals(this.typeName);
    }

    public boolean isTag(String tagName) {
        return tagName.equalsIgnoreCase(this.elementName);
    }
}

