/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties.angular;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.jst.web.ui.internal.properties.DefaultPropertySetViewer;

public class AngularJSPropertySetViewer
extends DefaultPropertySetViewer {
    List<Pair> pairs = new ArrayList<Pair>();

    @Override
    public String getCategoryDisplayName() {
        return "AngularJS";
    }

    @Override
    public List<IPropertyDescriptor> getFilteredDescriptors(List<IPropertyDescriptor> descriptors) {
        this.pairs.clear();
        HashMap<String, Pair> map = new HashMap<String, Pair>();
        for (IPropertyDescriptor d : descriptors) {
            Pair p;
            if (this.category == null || !this.category.equals(d.getCategory())) continue;
            String name = d.getId().toString();
            if (name.startsWith("data-ng")) {
                p = (Pair)map.get(name = name.substring(5));
                if (p == null) {
                    p = new Pair();
                    map.put(name, p);
                    this.pairs.add(p);
                }
                p.data_ng = d;
                continue;
            }
            if (!name.startsWith("ng-")) continue;
            p = (Pair)map.get(name);
            if (p == null) {
                p = new Pair();
                map.put(name, p);
                this.pairs.add(p);
            }
            p.ng = d;
        }
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        for (Pair p : this.pairs) {
            if (p.data_ng != null && (p.ng == null || this.isPropertySet(p.data_ng))) {
                result.add(p.data_ng);
                continue;
            }
            if (p.ng == null) continue;
            result.add(p.ng);
        }
        return result;
    }

    class Pair {
        IPropertyDescriptor ng = null;
        IPropertyDescriptor data_ng = null;

        Pair() {
        }
    }
}

