/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySheetModel;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySheetModelListener;

public class FormPropertySheetModel
implements IPropertySheetModel {
    private IWorkbenchPart part;
    private IPropertySourceProvider propertySourceProvider;
    private Object[] values = null;
    private Map<Object, IPropertySource> sources = new HashMap<Object, IPropertySource>(0);
    private List<IPropertyDescriptor> descriptors = null;
    private Map<String, IPropertyDescriptor> allDescriptors = new HashMap<String, IPropertyDescriptor>();
    private Map<Object, String> propertyValues = new HashMap<Object, String>();
    private List<IPropertySheetModelListener> listeners = new ArrayList<IPropertySheetModelListener>();

    @Override
    public void setWorkbenchPart(IWorkbenchPart part) {
        this.part = part;
    }

    @Override
    public IWorkbenchPart getWorkbenchPart() {
        return this.part;
    }

    @Override
    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        this.propertySourceProvider = provider;
    }

    @Override
    public Object getValue() {
        return this.values.length == 0 ? null : this.values[0];
    }

    @Override
    public void setInput(Object[] objects) {
        Object newValue;
        IPropertySource source;
        this.values = objects;
        this.sources = new HashMap<Object, IPropertySource>(this.values.length * 2 + 1);
        if (this.values.length != 0 && (source = this.getPropertySource(newValue = this.values[0])) != null) {
            Object object = source.getEditableValue();
        }
        this.refreshPropertyDescriptors();
    }

    @Override
    public IPropertySource getPropertySource() {
        return this.values.length == 0 ? null : this.getPropertySource(this.values[0]);
    }

    @Override
    public String getValueAsString(IPropertyDescriptor descriptor) {
        String o = this.propertyValues.get(descriptor.getId());
        return o == null ? "" : o.toString();
    }

    protected IPropertySource getPropertySource(Object object) {
        if (this.sources.containsKey(object)) {
            return this.sources.get(object);
        }
        IPropertySource result = null;
        IPropertySourceProvider provider = this.propertySourceProvider;
        if (provider != null) {
            result = provider.getPropertySource(object);
        }
        this.sources.put(object, result);
        return result;
    }

    public void dispose() {
    }

    @Override
    public List<IPropertyDescriptor> getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.computeMergedPropertyDescriptors();
        }
        return this.descriptors;
    }

    @Override
    public boolean hasDescriptor(String id) {
        return this.allDescriptors.containsKey(id);
    }

    @Override
    public IPropertyDescriptor getDescriptor(String id) {
        return this.allDescriptors.get(id);
    }

    public void refreshPropertyDescriptors() {
        List<IPropertyDescriptor> ds = this.computeMergedPropertyDescriptors();
        TreeMap<String, IPropertyDescriptor> tree = new TreeMap<String, IPropertyDescriptor>();
        for (IPropertyDescriptor d : ds) {
            tree.put(d.getDisplayName(), d);
        }
        ds = new ArrayList<IPropertyDescriptor>();
        ds.addAll(tree.values());
        this.descriptors = ds;
        this.allDescriptors.clear();
        HashMap<Object, String> newPropertyValues = new HashMap<Object, String>();
        if (this.descriptors.size() > 0) {
            IPropertySource s = this.getPropertySource(this.values[0]);
            for (IPropertyDescriptor d : this.descriptors) {
                Object id = d.getId();
                this.allDescriptors.put(id.toString(), d);
                Object value = s.getPropertyValue(id);
                newPropertyValues.put(id, value == null ? "" : value.toString());
            }
        }
        this.propertyValues = newPropertyValues;
    }

    private List<IPropertyDescriptor> computeMergedPropertyDescriptors() {
        if (this.values.length == 0) {
            return new ArrayList<IPropertyDescriptor>(0);
        }
        IPropertySource firstSource = this.getPropertySource(this.values[0]);
        if (firstSource == null) {
            return new ArrayList<IPropertyDescriptor>(0);
        }
        if (this.values.length == 1) {
            return Arrays.asList(firstSource.getPropertyDescriptors());
        }
        ArrayList<Map<Object, IPropertyDescriptor>> propertyDescriptorMaps = new ArrayList<Map<Object, IPropertyDescriptor>>(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            Object object = this.values[i];
            IPropertySource source = this.getPropertySource(object);
            if (source == null) {
                return new ArrayList<IPropertyDescriptor>(0);
            }
            propertyDescriptorMaps.add(this.computePropertyDescriptorsFor(source));
            ++i;
        }
        Map intersection = (Map)propertyDescriptorMaps.get(0);
        int i2 = 1;
        while (i2 < propertyDescriptorMaps.size()) {
            Object[] ids = intersection.keySet().toArray();
            int j = 0;
            while (j < ids.length) {
                Object object = ((Map)propertyDescriptorMaps.get(i2)).get(ids[j]);
                if (object == null || !((IPropertyDescriptor)intersection.get(ids[j])).isCompatibleWith((IPropertyDescriptor)object)) {
                    intersection.remove(ids[j]);
                }
                ++j;
            }
            ++i2;
        }
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>(intersection.size());
        IPropertyDescriptor[] firstDescs = firstSource.getPropertyDescriptors();
        int i3 = 0;
        while (i3 < firstDescs.length) {
            IPropertyDescriptor desc = firstDescs[i3];
            if (intersection.containsKey(desc.getId())) {
                result.add(desc);
            }
            ++i3;
        }
        return result;
    }

    private Map<Object, IPropertyDescriptor> computePropertyDescriptorsFor(IPropertySource source) {
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        HashMap<Object, IPropertyDescriptor> result = new HashMap<Object, IPropertyDescriptor>(descriptors.length * 2 + 1);
        int i = 0;
        while (i < descriptors.length) {
            result.put(descriptors[i].getId(), descriptors[i]);
            ++i;
        }
        return result;
    }

    @Override
    public synchronized void addListener(IPropertySheetModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(IPropertySheetModelListener listener) {
        this.listeners.remove(listener);
    }

    synchronized List<IPropertySheetModelListener> copyListeners() {
        return new ArrayList<IPropertySheetModelListener>(this.listeners);
    }

    @Override
    public void valueChanged(IPropertyDescriptor d, Object newValue) {
        this.propertyValues.put(d.getId(), newValue == null ? "" : newValue.toString());
        List<IPropertySheetModelListener> ls = this.copyListeners();
        for (IPropertySheetModelListener l : ls) {
            l.valueChanged(d);
        }
        IPropertySource s = this.getPropertySource();
        s.setPropertyValue(d.getId(), newValue);
    }
}

