/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;

public class JSLibVersion {
    JSLib lib;
    String version;
    List<String> urls = new ArrayList<String>();

    public JSLibVersion(JSLib lib) {
        this.lib = lib;
    }

    public JSLib getLib() {
        return this.lib;
    }

    public String getFullName() {
        return String.valueOf(this.getLib().getName()) + " " + this.getVersion();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getURLs() {
        return this.urls;
    }

    public String[] getSortedUrls() {
        if (this.urls.size() < 2) {
            return this.urls.toArray(new String[this.urls.size()]);
        }
        TreeSet<String> js = new TreeSet<String>();
        TreeSet<String> css = new TreeSet<String>();
        TreeSet<String> other = new TreeSet<String>();
        for (String u : this.urls) {
            if (this.isJS(u)) {
                js.add(u);
                continue;
            }
            if (this.isCSS(u)) {
                css.add(u);
                continue;
            }
            other.add(u);
        }
        int jscss = js.size() + css.size();
        String[] result = new String[jscss + other.size()];
        System.arraycopy(js.toArray(new String[js.size()]), 0, result, 0, js.size());
        System.arraycopy(css.toArray(new String[css.size()]), 0, result, js.size(), css.size());
        System.arraycopy(other.toArray(new String[other.size()]), 0, result, jscss, other.size());
        return result;
    }

    public boolean isJS(String url) {
        return url != null && !this.isCSS(url);
    }

    public boolean isCSS(String url) {
        return url != null && url.endsWith(".css");
    }

    public void applyWorkingCopy(JSLibVersion copy, boolean applyRemoved) {
        this.version = copy.getVersion();
        if (applyRemoved) {
            this.urls.clear();
        }
        for (String s : copy.getURLs()) {
            if (this.urls.contains(s)) continue;
            this.urls.add(s);
        }
    }
}

