/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibModel;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibXMLLoader;
import org.osgi.service.prefs.BackingStoreException;

public class JSLibFactory {
    static JSLibFactory instance = new JSLibFactory();
    static String JS_CSS_LIBS_PREFERENCE_NAME = "js-css-libs";
    private JSLibModel defaultModel;
    private JSLibModel preferenceModel;
    private JSLibModel workingCopy;

    public static JSLibFactory getInstance() {
        return instance;
    }

    private JSLibFactory() {
    }

    public JSLibModel getDefaultModel() {
        if (this.defaultModel == null) {
            this.createDefaultModel();
        }
        return this.defaultModel;
    }

    public JSLibModel getPreferenceModel() {
        if (this.preferenceModel == null) {
            this.loadPreferenceModel();
        }
        return this.preferenceModel;
    }

    public synchronized JSLibModel getWorkingCopy() {
        if (this.workingCopy == null) {
            this.workingCopy = this.createCopy(this.getPreferenceModel());
        }
        return this.workingCopy;
    }

    public synchronized void applyDefault() {
        if (this.workingCopy != null) {
            this.workingCopy.applyWorkingCopy(this.createCopy(this.getDefaultModel()), false);
        }
    }

    public synchronized void applyWorkingCopy() {
        if (this.workingCopy != null) {
            this.preferenceModel.applyWorkingCopy(this.workingCopy, true);
        }
    }

    public synchronized void disposeWorkingCopy() {
        this.workingCopy = null;
    }

    synchronized void createDefaultModel() {
        String[] jQueryMobileVersions;
        String[] jQueryVersions;
        if (this.defaultModel != null) {
            return;
        }
        JSLibModel model = new JSLibModel();
        JSLib jQuery = model.getOrCreateLib("jQuery");
        String[] stringArray = jQueryVersions = new String[]{"1.9.1", "1.10.2", "1.11.1", "2.0.1", "2.0.3", "2.1.0", "2.1.1"};
        int n = jQueryVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            jQuery.getOrCreateVersion(s).getURLs().add("http://code.jquery.com/jquery-" + s + ".min.js");
            ++n2;
        }
        JSLib jQueryMobile = model.getOrCreateLib("jQuery Mobile");
        String[] stringArray2 = jQueryMobileVersions = new String[]{"1.3.1", "1.3.2", "1.4.2"};
        int n3 = jQueryMobileVersions.length;
        int n4 = 0;
        while (n4 < n3) {
            String s = stringArray2[n4];
            JSLibVersion v = jQueryMobile.getOrCreateVersion(s);
            v.getURLs().add("http://code.jquery.com/mobile/" + s + "/jquery.mobile-" + s + ".min.js");
            v.getURLs().add("http://code.jquery.com/mobile/" + s + "/jquery.mobile-" + s + ".min.css");
            ++n4;
        }
        this.defaultModel = model;
    }

    synchronized void loadPreferenceModel() {
        JSLibModel model;
        if (this.preferenceModel != null) {
            return;
        }
        IEclipsePreferences node = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node("org.jboss.tools.jst.web.ui");
        String s = node.get(JS_CSS_LIBS_PREFERENCE_NAME, null);
        if (s == null) {
            s = JSLibXMLLoader.saveToString(this.getDefaultModel());
        }
        if ((model = JSLibXMLLoader.load(s)) == null) {
            model = this.createCopy(this.getDefaultModel());
        }
        this.preferenceModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void savePreferenceModel() {
        if (this.preferenceModel == null) {
            return;
        }
        IEclipsePreferences node = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node("org.jboss.tools.jst.web.ui");
        JSLibModel jSLibModel = this.preferenceModel;
        synchronized (jSLibModel) {
            String s = JSLibXMLLoader.saveToString(this.preferenceModel);
            node.put(JS_CSS_LIBS_PREFERENCE_NAME, s);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
    }

    synchronized JSLibModel createCopy(JSLibModel source) {
        JSLibModel copy = new JSLibModel();
        for (JSLib lib : source.getLibs()) {
            JSLib libCopy = copy.getOrCreateLib(lib.getName());
            for (JSLibVersion version : lib.getVersions()) {
                JSLibVersion versionCopy = libCopy.getOrCreateVersion(version.getVersion());
                versionCopy.getURLs().addAll(version.getURLs());
            }
        }
        return copy;
    }
}

