/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.support.kb;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

class ImagesFinder
implements IResourceVisitor {
    private List<IResource> resources;
    private int count = 0;
    private String name;
    Set extensions = null;

    public ImagesFinder(List<IResource> resources, String name, Set extensions) {
        this.resources = resources;
        this.name = name;
        this.extensions = extensions;
    }

    boolean acceptExtension(String ext) {
        if (ext != null) {
            ext = ext.toLowerCase();
        }
        return this.extensions == null || this.extensions.contains(ext);
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (resource.getName().startsWith(this.name) && this.acceptExtension(file.getFileExtension())) {
                this.resources.add(resource);
            }
        } else if (resource instanceof IFolder) {
            if (this.count == 0) {
                ++this.count;
                return true;
            }
            if (resource.getName().startsWith(this.name) && !resource.getName().equals("WEB-INF") && !resource.getName().equals("META-INF")) {
                this.resources.add(resource);
            }
        }
        return false;
    }
}

