/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.selection.bar;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class ImageButton {
    private ToolItem item;
    private Composite composite;
    private Image emptyImage;
    private Image image;

    public ImageButton(Composite parent, Image image, String toolTip) {
        this.composite = new Composite(parent, 0);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageButton.this.release();
            }
        });
        GridLayout layoutTl = new GridLayout(1, false);
        layoutTl.marginBottom = 0;
        layoutTl.marginHeight = 0;
        layoutTl.marginWidth = 0;
        layoutTl.verticalSpacing = 0;
        layoutTl.horizontalSpacing = 0;
        this.composite.setLayout((Layout)layoutTl);
        this.image = image;
        ToolBar toolBar = new ToolBar(this.composite, 0x800100);
        this.item = new ToolItem(toolBar, 0x800000);
        this.item.setImage(image);
        this.emptyImage = new Image((Device)Display.getCurrent(), 1, 1);
        Color emptyImageColor = toolBar.getBackground();
        this.emptyImage.setBackground(emptyImageColor);
        GC gc = new GC((Drawable)this.emptyImage);
        gc.setForeground(emptyImageColor);
        gc.drawPoint(0, 0);
        gc.dispose();
        this.item.setDisabledImage(this.emptyImage);
        this.item.setToolTipText(toolTip);
    }

    public void addSelectionListener(Listener listener) {
        this.item.addListener(13, listener);
    }

    protected void release() {
        if (this.emptyImage != null) {
            this.emptyImage.dispose();
            this.emptyImage = null;
        }
    }

    public void dispose() {
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
            this.item = null;
            this.image = null;
        }
    }

    public void setEnabled(boolean enabled) {
        this.item.setEnabled(enabled);
        if (enabled) {
            this.item.setImage(this.image);
        } else {
            this.item.setImage(this.emptyImage);
        }
    }

    public Rectangle getButtonBounds() {
        return this.item.getBounds();
    }

    public Composite getComposite() {
        return this.composite;
    }
}

