/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.DropWizard;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizard;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposal;
import org.jboss.tools.common.model.ui.editors.dnd.PaletteDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagAttributesComposite;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertManager;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.tld.IWebProject;
import org.jboss.tools.jst.web.tld.WebProjectFactory;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.FileDropCommand;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.TagProposal;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;

public class PaletteDropCommand
extends FileDropCommand {
    Properties initialValues = new Properties();
    String startText;
    String endText;
    String newLine;
    String reformat = "no";
    Properties properties = new Properties();
    boolean callPaletteWizard = false;

    @Override
    protected IDropWizardModel createSpecificModel() {
        return new PaletteDropWizardModel(this.tagProposalFactory);
    }

    @Override
    protected void addCustomProperties(Properties runningProperties) {
        this.newLine = this.properties.getProperty("new line");
        if (this.newLine == null) {
            this.newLine = "true";
        }
        runningProperties.setProperty("new line", this.newLine);
        String addTaglib = this.properties.getProperty("add taglib");
        if (addTaglib == null) {
            addTaglib = "true";
        }
        runningProperties.setProperty("add taglib", addTaglib);
    }

    public void execute() {
        if (this.getDefaultModel().getTagProposal() == IDropWizardModel.UNDEFINED_TAG_PROPOSAL) {
            if (this.startText == null && this.endText == null) {
                return;
            }
            int pos = ((ITextSelection)this.getDefaultModel().getDropData().getSelectionProvider().getSelection()).getOffset();
            this.getDefaultModel().getDropData().getSourceViewer().setSelectedRange(pos, 0);
            if (this.startText != null) {
                this.properties.setProperty("start text", this.startText);
            }
            if (this.endText != null) {
                this.properties.setProperty("end text", this.endText);
            }
            if (this.reformat != null) {
                this.properties.setProperty("automatically reformat tag body", this.reformat);
            }
            if (this.newLine != null) {
                this.properties.setProperty("new line", this.newLine);
            }
            JSPPaletteInsertHelper.getInstance().insertIntoEditor(this.getDefaultModel().getDropData().getSourceViewer(), this.properties);
        } else {
            ElementImpl container;
            DropData data = this.getDefaultModel().getDropData();
            ISourceViewer viewer = data.getSourceViewer();
            if (data.getContainer() != null && data.getContainer() instanceof ElementImpl && !(container = (ElementImpl)data.getContainer()).hasEndTag()) {
                try {
                    IDocument document = viewer.getDocument();
                    int containerOffset = container.getStartOffset();
                    int containerLenght = container.getStartEndOffset() - containerOffset;
                    String containerString = document.get(containerOffset, containerLenght);
                    int slashPosition = containerString.lastIndexOf("/");
                    if (slashPosition >= 0) {
                        int deltaOffset = containerString.length() - 1 - slashPosition;
                        String text = "";
                        int i = 0;
                        while (i < deltaOffset) {
                            text = String.valueOf(text) + " ";
                            ++i;
                        }
                        text = String.valueOf(text) + "></" + container.getNodeName() + ">";
                        document.replace(containerOffset + slashPosition, containerString.length() - slashPosition, text);
                    }
                }
                catch (BadLocationException ex) {
                    ModelUIPlugin.getDefault().logError((Throwable)ex);
                }
            }
            super.execute();
        }
    }

    @Override
    protected void fillPropertiesForRun(Properties properties) {
        if (this.properties.containsKey("palettePath")) {
            properties.put("palettePath", this.properties.getProperty("palettePath"));
        }
        if (this.properties.containsKey("insert jquery mobile js css")) {
            properties.put("insert jquery mobile js css", this.properties.get("insert jquery mobile js css"));
        }
    }

    public void initialize() {
        DropData data = this.getDefaultModel().getDropData();
        IEditorInput input = data.getEditorInput();
        XModelObject target = null;
        IFile f = null;
        if (input instanceof IFileEditorInput) {
            f = ((IFileEditorInput)input).getFile();
            target = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (target == null && f.exists()) {
                target = EclipseResourceUtil.createObjectForResource((IResource)f);
            }
        } else if (input instanceof IModelObjectEditorInput) {
            target = ((IModelObjectEditorInput)input).getXModelObject();
        }
        if (target == null) {
            this.initialize2();
        } else {
            boolean isWizardEnabled;
            Object so;
            ISourceViewer viewer = data.getSourceViewer();
            this.properties = new Properties();
            this.properties.put("viewer", viewer);
            this.properties.setProperty("text", viewer.getDocument().get());
            this.properties.setProperty("isDrop", "true");
            this.properties.setProperty("actionSourceGUIComponentID", "editor");
            this.properties.setProperty("accepsAsString", "true");
            if (f != null) {
                this.properties.put("file", f);
            }
            ISelection selection = data.getSelectionProvider().getSelection();
            int offset = 0;
            offset = selection instanceof ITextSelection ? ((ITextSelection)selection).getOffset() : viewer.getTextWidget().getCaretOffset();
            this.properties.setProperty("pos", "" + offset);
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && (so = ((IStructuredSelection)selection).getFirstElement()) instanceof IDOMElement) {
                String en = ((IDOMElement)so).getNodeName();
                this.properties.setProperty("context:tagName", en);
                String attrName = data.getAttributeName();
                if (attrName != null) {
                    this.properties.setProperty("context:attrName", attrName);
                }
            }
            try {
                if (DnDUtil.isPasteEnabled((XModelObject)target)) {
                    DnDUtil.paste((XModelObject)target, (Properties)this.properties);
                } else {
                    XModelObject s = PreferenceModelUtilities.getPreferenceModel().getModelBuffer().source();
                    if (s != null) {
                        this.properties.setProperty("start text", this.getDefaultText(s));
                        this.properties.setProperty("end text", "");
                        this.properties.setProperty("new line", "newLine");
                    }
                }
            }
            catch (CoreException e) {
                ModelUIPlugin.getDefault().logError((Throwable)e);
            }
            this.startText = this.properties.getProperty("start text");
            this.endText = this.properties.getProperty("end text");
            this.reformat = this.properties.getProperty("automatically reformat tag body");
            String uri = this.properties.getProperty("library uri");
            String libraryVersion = this.properties.getProperty("library version");
            String defaultPrefix = this.properties.getProperty("default prefix");
            String tagname = this.properties.getProperty("tag name");
            if (tagname == null && this.getCustomWizardName() != null) {
                if (this.properties.getProperty("palettePath", "").startsWith(PaletteModel.MOBILE_PATH)) {
                    data.setValueProvider(null);
                }
                tagname = "div";
                this.properties.setProperty("tag name", tagname);
            }
            this.callPaletteWizard = PaletteInsertManager.getInstance().getWizardName(this.properties) != null;
            boolean bl = isWizardEnabled = !"FileJAVA".equals(target.getModelEntity().getName());
            if (this.getDefaultModel() instanceof PaletteDropWizardModel) {
                ((PaletteDropWizardModel)this.getDefaultModel()).setWizardEnabled(isWizardEnabled);
            }
            if (uri == null || tagname == null) {
                this.getDefaultModel().setTagProposal(IDropWizardModel.UNDEFINED_TAG_PROPOSAL);
            } else {
                this.getDefaultModel().setTagProposal((ITagProposal)new TagProposal(uri, libraryVersion, defaultPrefix, tagname));
                this.insertInitialValues();
            }
        }
    }

    private void initialize2() {
        XModelObject object = PreferenceModelUtilities.getPreferenceModel().getModelBuffer().source();
        String tagname = object.getAttributeValue("name");
        XModelObject parent = object.getParent();
        String uri = parent == null ? "" : parent.getAttributeValue("library uri");
        String libraryVersion = parent == null ? "" : parent.getAttributeValue("library version");
        String defaultPrefix = parent == null ? "" : parent.getAttributeValue("default prefix");
        this.getDefaultModel().setTagProposal((ITagProposal)new TagProposal(uri, libraryVersion, defaultPrefix, tagname));
        this.startText = object.getAttributeValue("start text");
        this.endText = object.getAttributeValue("end text");
    }

    private void insertInitialValues() {
        this.parseInitialValues(this.startText);
        TagAttributesComposite.AttributeDescriptorValue[] vs = this.getDefaultModel().getAttributeValueDescriptors();
        int i = 0;
        while (i < vs.length) {
            String v = this.initialValues.getProperty(vs[i].getName());
            if (v != null) {
                vs[i].setPreferable(true);
                vs[i].setValue((Object)v);
            }
            ++i;
        }
    }

    private void parseInitialValues(String startText) {
        if (startText == null || startText.length() == 0) {
            return;
        }
        int bi = startText.indexOf(60);
        if (bi < 0) {
            return;
        }
        int ei = startText.indexOf(62, bi);
        if (ei < 0) {
            return;
        }
        String header = startText.substring(bi + 1, ei);
        int NOTHING = 0;
        int ATT_NAME = 1;
        int ATT_VALUE = 2;
        char quote = '\u0000';
        int state = NOTHING;
        boolean whitespace = false;
        String name = null;
        String value = null;
        int i = 0;
        while (i < header.length()) {
            char c = header.charAt(i);
            if (state == NOTHING) {
                if (Character.isJavaIdentifierStart(c)) {
                    name = "" + c;
                    state = ATT_NAME;
                    whitespace = false;
                }
            } else if (state == ATT_NAME) {
                if (Character.isJavaIdentifierPart(c) || c == ':') {
                    if (whitespace) {
                        whitespace = false;
                        name = "";
                    }
                    name = String.valueOf(name) + c;
                } else if (c == '=') {
                    state = ATT_VALUE;
                    quote = '\u0000';
                    whitespace = false;
                } else if (Character.isWhitespace(c)) {
                    whitespace = true;
                }
            } else if (state == ATT_VALUE) {
                if (c == quote) {
                    int q = value.indexOf("|");
                    if (q >= 0) {
                        value = String.valueOf(value.substring(0, q)) + value.substring(q + 1);
                    }
                    this.initialValues.setProperty(name, value);
                    name = null;
                    value = null;
                    state = NOTHING;
                    quote = '\u0000';
                } else if (c == '\"' || c == '\'') {
                    quote = c;
                    value = "";
                } else if (quote != '\u0000') {
                    value = String.valueOf(value) + c;
                }
            }
            ++i;
        }
    }

    @Override
    protected String generateStartText() {
        if (this.getDefaultModel().getTagProposal() == IDropWizardModel.UNDEFINED_TAG_PROPOSAL) {
            this.startText = this.properties.getProperty("start text");
            return this.startText;
        }
        return super.generateStartText();
    }

    @Override
    protected String generateEndText() {
        if (this.getDefaultModel().getTagProposal() == IDropWizardModel.UNDEFINED_TAG_PROPOSAL) {
            this.endText = this.properties.getProperty("end text");
            return this.endText != null ? this.endText : "";
        }
        return super.generateEndText();
    }

    @Override
    protected String getReformatBodyProperty() {
        return this.reformat;
    }

    protected String getCustomWizardName() {
        return PaletteInsertManager.getInstance().getWizardName(this.properties);
    }

    protected IDropWizard createDropWizard() {
        String wizardName = this.getCustomWizardName();
        IDropWizard wizard = null;
        if (wizardName != null) {
            wizard = (IDropWizard)PaletteInsertManager.getInstance().createWizardInstance(this.properties);
        }
        if (wizard == null) {
            wizard = new DropWizard();
        }
        wizard.setCommand((IDropCommand)this);
        return wizard;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private String getDefaultText(XModelObject o) {
        if (o == null) {
            return "";
        }
        if (o.getFileType() != 1) {
            return o.getPresentationString();
        }
        IWebProject p = WebProjectFactory.instance.getWebProject(o.getModel());
        String path = p.getPathInWebRoot(o);
        return path == null ? o.getPresentationString() : path;
    }
}

