/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd;

import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertHelper;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.preferences.js.PreferredJSLibVersions;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MobilePaletteInsertHelper
extends PaletteInsertHelper {
    public static final String PROPOPERTY_JQUERY_MOBILE_INSERT_JS_CSS = "insert jquery mobile js css";
    public static final String INSERT_JS_CSS_SIGNATURE = "<jquery.mobile.js.css>";
    private static final String MOBILE_PATH = "/Mobile/";
    private static final String META = "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"";
    private static final int INSERT_AFTER_OPEN_NODE = 1;
    private static final int INSERT_AFTER_CLOSE_NODE = 2;
    private static final int INSERT_BEFORE_OPEN_NODE = 3;
    private static final int INSERT_BEFORE_CLOSE_NODE = 4;
    private static final int INSERT_AFTER_ALL = 5;
    private StringBuffer globalBuffer = new StringBuffer();
    private int globalPosition = -1;
    private int goobalLength = 0;
    private IDOMNode doctypeNode = null;
    private IDOMNode htmlNode = null;
    private IDOMNode headNode = null;
    private IDOMNode bodyNode = null;
    private String baseNodeIndent = "";
    static MobilePaletteInsertHelper instance = new MobilePaletteInsertHelper();

    private static String link(String href) {
        return "<link rel=\"stylesheet\" href=\"" + href + "\" /";
    }

    private static String script(String src) {
        return "<script src=\"" + src + "\"></script";
    }

    public static MobilePaletteInsertHelper getInstance() {
        return instance;
    }

    public boolean isMobile(ISourceViewer v, Properties p, String[] texts) {
        String path;
        if (p.containsKey("palettePath") && (path = p.getProperty("palettePath")).contains(MOBILE_PATH)) {
            this.modify(v, p, texts);
            return true;
        }
        return false;
    }

    protected void modify(ISourceViewer v, Properties p, String[] texts) {
        p.put("viewer", v);
        String startText = texts[0];
        boolean insert = startText != null && startText.startsWith(INSERT_JS_CSS_SIGNATURE);
        MarkerResolutionUtils.getFile();
        if (insert || p.containsKey(PROPOPERTY_JQUERY_MOBILE_INSERT_JS_CSS)) {
            this.insertJsCss(v, p.get(PROPOPERTY_JQUERY_MOBILE_INSERT_JS_CSS));
            if (insert) {
                texts[0] = "";
            }
        }
    }

    private void writeBuffer(IDocument document) throws BadLocationException {
        if (this.globalBuffer.length() > 0 && this.globalPosition >= 0 && this.globalPosition <= document.getLength()) {
            document.replace(this.globalPosition, this.goobalLength, this.globalBuffer.toString());
            this.globalBuffer = new StringBuffer();
            this.globalPosition = -1;
        }
    }

    private void copyAttributes(IDOMNode node) {
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if (i != 0) {
                this.globalBuffer.append(",");
            }
            this.globalBuffer.append(" ").append(attribute.getNodeName()).append("=\"").append(attribute.getNodeValue()).append("\"");
            ++i;
        }
    }

    private void insertNode(IDocument document, IDOMNode relatedNode, IDOMNode node, int indentWidth, String text, int mode, boolean forceWrite) throws BadLocationException {
        boolean newLineBefore = true;
        boolean newLineAfter = false;
        boolean copyAttributes = false;
        String lineDelimiter = MobilePaletteInsertHelper.getLineDelimiter((IDocument)document);
        int tabWidth = IElementGenerator.NodeWriter.getTabWidth();
        if (node != null) {
            this.writeBuffer(document);
            if (node.getEndStructuredDocumentRegion() == null && !(node instanceof IDOMDocumentType)) {
                this.globalPosition = node.getStartStructuredDocumentRegion().getStartOffset();
                this.goobalLength = node.getStartStructuredDocumentRegion().getLength();
                copyAttributes = true;
                newLineBefore = false;
            } else {
                return;
            }
        }
        if (mode == 1) {
            if (this.globalPosition == -1 && relatedNode != null && relatedNode.getStartStructuredDocumentRegion() != null && (relatedNode.getEndStructuredDocumentRegion() != null || relatedNode instanceof IDOMDocumentType)) {
                this.globalPosition = relatedNode.getStartStructuredDocumentRegion().getEndOffset();
                this.goobalLength = 0;
            }
        } else if (mode == 2) {
            if (this.globalPosition == -1 && relatedNode != null && relatedNode.getEndStructuredDocumentRegion() != null) {
                this.globalPosition = relatedNode.getEndStructuredDocumentRegion().getEndOffset();
                this.goobalLength = 0;
            }
        } else if (mode == 5) {
            this.writeBuffer(document);
            if (this.globalPosition == -1) {
                this.globalPosition = document.getLength();
                this.goobalLength = 0;
            }
        } else if (mode == 4) {
            this.writeBuffer(document);
            if (this.globalPosition == -1) {
                if (relatedNode != null) {
                    this.globalPosition = relatedNode.getEndStructuredDocumentRegion().getStartOffset();
                    this.globalPosition -= this.countSpacesBeforeIncludingNewLine(document, this.globalPosition);
                    this.goobalLength = 0;
                } else {
                    this.globalPosition = document.getLength();
                    this.goobalLength = 0;
                }
            }
        } else if (mode == 3 && relatedNode != null) {
            this.writeBuffer(document);
            if (this.globalPosition == -1) {
                this.globalPosition = relatedNode.getStartStructuredDocumentRegion().getStartOffset();
                if (!this.checkForNewLine(document, this.globalPosition)) {
                    newLineAfter = true;
                }
                this.globalPosition -= this.countSpacesBeforeIncludingNewLine(document, this.globalPosition);
                this.goobalLength = 0;
                newLineBefore = true;
            }
        }
        if (newLineBefore) {
            this.globalBuffer.append(lineDelimiter);
            this.globalBuffer.append(this.baseNodeIndent);
            String indent = MobilePaletteInsertHelper.createIndent((int)(indentWidth * tabWidth));
            this.globalBuffer.append(indent);
        }
        this.globalBuffer.append(text);
        if (copyAttributes) {
            this.copyAttributes(node);
            if (this.htmlNode != null && this.htmlNode.getNodeName().equalsIgnoreCase(node.getNodeName())) {
                this.htmlNode = null;
            } else if (this.headNode != null && this.headNode.getNodeName().equalsIgnoreCase(node.getNodeName())) {
                this.headNode = null;
            } else if (this.bodyNode != null && this.bodyNode.getNodeName().equalsIgnoreCase(node.getNodeName())) {
                this.bodyNode = null;
            }
        }
        this.globalBuffer.append(">");
        if (newLineAfter) {
            this.globalBuffer.append(lineDelimiter);
        }
        if (forceWrite) {
            this.writeBuffer(document);
        }
    }

    private String getNodeIndent(IDocument document, IDOMNode node) {
        int number;
        int offset;
        int position;
        if (node.getStartStructuredDocumentRegion() != null && (position = (offset = node.getStartStructuredDocumentRegion().getStartOffset()) - (number = this.countSpacesBefore(document, offset))) < offset && position >= 0) {
            try {
                String spaces = document.get(position, number);
                return spaces;
            }
            catch (BadLocationException ex) {
                WebUiPlugin.getDefault().logError(ex);
            }
        }
        return "";
    }

    private int countSpacesBefore(IDocument document, int offset) {
        int position = offset - 1;
        int number = 0;
        try {
            while (position >= 0) {
                String text = document.get(position, 1);
                if (!text.equals(" ") && !text.equals("\t")) {
                    return number;
                }
                ++number;
                --position;
            }
        }
        catch (BadLocationException ex) {
            WebUiPlugin.getDefault().logError(ex);
        }
        return number;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForNewLine(IDocument document, int offset) {
        int position = offset - 1;
        try {
            while (true) {
                if (position < 0) {
                    return false;
                }
                String text = document.get(position, 1);
                if (text.equals("\n")) {
                    return true;
                }
                if (!text.trim().equals("")) {
                    return false;
                }
                --position;
            }
        }
        catch (BadLocationException ex) {
            WebUiPlugin.getDefault().logError(ex);
        }
        return false;
    }

    private int countSpacesBeforeIncludingNewLine(IDocument document, int offset) {
        int number = 0;
        try {
            for (int position = offset - 1; position >= 0; --position) {
                String text = document.get(position, 1);
                if (!text.trim().equals("")) {
                    return number;
                }
                ++number;
                if (!text.equals("\n")) continue;
                return number;
            }
        }
        catch (BadLocationException ex) {
            WebUiPlugin.getDefault().logError(ex);
        }
        return number;
    }

    private void insertJsCss(ISourceViewer viewer, Object version) {
        IDocument document = viewer.getDocument();
        IStructuredModel model = null;
        try {
            try {
                IDOMDocument xmlDocument;
                model = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)((IStructuredDocument)document));
                IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
                if (xmlDocument != null) {
                    this.doctypeNode = MobilePaletteInsertHelper.findDocumentType((Node)xmlDocument, "html");
                    this.htmlNode = MobilePaletteInsertHelper.findNode((Node)xmlDocument, "html");
                    this.baseNodeIndent = "";
                    if (this.htmlNode == null) {
                        this.bodyNode = MobilePaletteInsertHelper.findNode((Node)xmlDocument, "body");
                        this.headNode = MobilePaletteInsertHelper.findNode((Node)xmlDocument, "head");
                    } else {
                        this.bodyNode = MobilePaletteInsertHelper.findNode((Node)this.htmlNode, "body");
                        this.headNode = MobilePaletteInsertHelper.findNode((Node)this.htmlNode, "head");
                        this.baseNodeIndent = this.headNode != null ? this.getNodeIndent(document, this.headNode) : this.getNodeIndent(document, this.htmlNode);
                    }
                    boolean metaExists = MobilePaletteInsertHelper.checkNode(this.headNode, "meta", "name", "(viewport)");
                    PreferredJSLibVersions preferredVersions = new PreferredJSLibVersions(MarkerResolutionUtils.getFile(), version);
                    preferredVersions.updateLibEnablementAndSelection();
                    String[][] urls = preferredVersions.getURLs((Node)this.headNode);
                    this.insertNode(document, this.doctypeNode, this.htmlNode, 0, "<html", 1, false);
                    this.insertNode(document, this.htmlNode, this.headNode, 0, "<head", 1, false);
                    if (!metaExists) {
                        this.insertNode(document, this.headNode, null, 1, META, 1, false);
                    }
                    String[] stringArray = urls[0];
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String css = stringArray[n2];
                        this.insertNode(document, this.headNode, null, 1, MobilePaletteInsertHelper.link(css), 1, false);
                        ++n2;
                    }
                    stringArray = urls[1];
                    n = stringArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        String js = stringArray[n2];
                        this.insertNode(document, this.headNode, null, 1, MobilePaletteInsertHelper.script(js), 1, false);
                        ++n2;
                    }
                    this.insertNode(document, this.bodyNode, this.headNode, 0, "</head", 3, false);
                    this.insertNode(document, this.headNode, this.bodyNode, 0, "<body", 2, false);
                    this.insertNode(document, this.htmlNode, this.bodyNode, 0, "</body", 4, false);
                    this.insertNode(document, null, this.htmlNode, 0, "</html", 5, true);
                }
            }
            catch (BadLocationException e) {
                WebUiPlugin.getDefault().logError(e);
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static IDOMDocumentType findDocumentType(Node rootNode, String nodeName) {
        if (rootNode != null) {
            NodeList list = rootNode.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child instanceof IDOMDocumentType && child.getNodeName().equalsIgnoreCase(nodeName)) {
                    return (IDOMDocumentType)child;
                }
                ++i;
            }
        }
        return null;
    }

    public static IDOMNode findNode(Node rootNode, String nodeName) {
        if (rootNode != null) {
            NodeList list = rootNode.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child instanceof Element && child.getNodeName().equalsIgnoreCase(nodeName)) {
                    return (IDOMNode)child;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean checkNode(IDOMNode node, String nodeName, String attributeName, String attributePattern) {
        if (node != null) {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                NamedNodeMap attributes;
                Node attribute;
                Node child = list.item(i);
                if (child.getNodeName().equalsIgnoreCase(nodeName) && (attribute = (attributes = child.getAttributes()).getNamedItem(attributeName)) != null && Pattern.matches(attributePattern, attribute.getNodeValue())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static /* bridge */ /* synthetic */ PaletteInsertHelper getInstance() {
        return MobilePaletteInsertHelper.getInstance();
    }
}

