/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.ui.views.palette.PaletteContents;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JQueryVersionComputer;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.VersionComputer;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;

public class PagePaletteContents
extends PaletteContents {
    IEditorPart editorPart;
    Map<String, CategoryVersion> categoryVersions = new HashMap<String, CategoryVersion>();

    public PagePaletteContents(IEditorPart editorPart) {
        super(editorPart);
        this.editorPart = editorPart;
        this.categoryVersions.put("jQuery Mobile", new CategoryVersion(new JQueryVersionComputer()));
        this.computeVersions();
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    public IFile getFile() {
        IEditorInput input;
        if (this.editorPart != null && (input = this.editorPart.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public boolean update() {
        boolean r = super.update();
        if (this.computeVersions()) {
            r = true;
        }
        return r;
    }

    public void dispose() {
        PaletteModel.disposeInstance(this);
        this.editorPart = null;
    }

    boolean computeVersions() {
        boolean result = false;
        IFile file = this.getFile();
        String[] types = this.getNatureTypes();
        if (types.length > 0 && TYPE_MOBILE.equals(types[0]) && file != null) {
            for (String categoryName : this.categoryVersions.keySet()) {
                CategoryVersion v = this.categoryVersions.get(categoryName);
                if (!v.computeVersion()) continue;
                result = true;
            }
        }
        return result;
    }

    boolean mapsAreEqual(Map<String, String> map1, Map<String, String> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (String k : map2.keySet()) {
            if (!map1.containsKey(k)) {
                return false;
            }
            if (map1.get(k).equals(map2.get(k))) continue;
            return false;
        }
        return true;
    }

    public String getVersion(String category) {
        CategoryVersion v = this.categoryVersions.get(category);
        return v == null ? null : v.getVersion();
    }

    public void setPreferredVersion(String category, String version) {
        CategoryVersion v = this.categoryVersions.get(category);
        if (v != null && v.preferredVersion != version) {
            v.preferredVersion = version;
        }
    }

    class CategoryVersion {
        VersionComputer versionComputer;
        String detectedVersion = null;
        String preferredVersion = null;

        public CategoryVersion(VersionComputer versionComputer) {
            this.versionComputer = versionComputer;
        }

        public String getVersion() {
            return this.preferredVersion != null ? this.preferredVersion : this.detectedVersion;
        }

        public boolean computeVersion() {
            boolean isNew;
            String newVersion = this.versionComputer.computeVersion(PagePaletteContents.this.getFile());
            boolean bl = isNew = !this.isSame(newVersion);
            if (isNew) {
                this.preferredVersion = null;
                this.detectedVersion = newVersion;
            }
            return isNew;
        }

        private boolean isSame(String newVersion) {
            return this.detectedVersion == null ? newVersion == null : this.detectedVersion.equals(newVersion);
        }
    }
}

