/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSSelectorTreeModel;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSTreeNode;

public abstract class CSSClassSelectionChangedEvent
extends SelectionChangedEvent {
    protected CSSSelectorTreeModel model;

    public CSSClassSelectionChangedEvent(ISelectionProvider source, ISelection selection) {
        super(source, selection);
    }

    public CSSRuleContainer[] getRuleContainersForName(String cssClassName) {
        if (this.model == null) {
            return null;
        }
        return this.findContainers(this.model.getInvisibleRoot(), cssClassName);
    }

    public abstract String[] getSelectedClassNames();

    public CSSRuleContainer[] getSelectedRuleContainers() {
        ArrayList<CSSRuleContainer> containers = new ArrayList<CSSRuleContainer>();
        String[] classNames = this.getSelectedClassNames();
        if (classNames != null) {
            int i = 0;
            while (i < classNames.length) {
                CSSRuleContainer[] cssContainers = this.getRuleContainersForName(classNames[i]);
                if (cssContainers != null) {
                    int j = 0;
                    while (j < cssContainers.length) {
                        containers.add(cssContainers[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return containers.toArray(new CSSRuleContainer[0]);
    }

    private CSSRuleContainer[] findContainers(CSSTreeNode parentRoot, String className) {
        ArrayList<CSSRuleContainer> ruleContainers = new ArrayList<CSSRuleContainer>(0);
        List<CSSTreeNode> styleSheetList = parentRoot.getChildren();
        for (CSSTreeNode styleSheetNode : styleSheetList) {
            List<CSSTreeNode> styleClassList = styleSheetNode.getChildren();
            for (CSSTreeNode styleClassNode : styleClassList) {
                if (!className.equals(styleClassNode.toString())) continue;
                ruleContainers.add((CSSRuleContainer)styleClassNode.getCSSContainer());
            }
        }
        return ruleContainers.toArray(new CSSRuleContainer[0]);
    }

    public CSSSelectorTreeModel getModel() {
        return this.model;
    }
}

