/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkDetector;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.jboss.tools.jst.web.ui.editor.pref.template.TemplateContextTypeIdsXHTML;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.preferences.JSPOccurrencePreferenceConstants;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLWizardVisualPreviewInitializationException;
import org.osgi.framework.BundleContext;

public class WebUiPlugin
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.jst.web.ui";
    public static final String EXTESION_POINT_LOCALE_PROVIDER = "org.jboss.tools.jst.web.ui.localeProvider";
    public static final String CA_JSF_ACTION_IMAGE_PATH = "images/ca/icons_JSF_Actions.gif";
    public static final String CA_JSF_EL_IMAGE_PATH = "images/ca/icons_JSF_EL.gif";
    public static final String CA_RESOURCES_IMAGE_PATH = "images/ca/icons_Resource_path.gif";
    public static final String CA_JSF_MESSAGES_IMAGE_PATH = "images/ca/icons_Message_Bundles.gif";
    public static final String JS_LIB_IMAGE_PATH = "images/xstudio/js/lib.png";
    public static final String JS_LIB_JS_IMAGE_PATH = "images/xstudio/js/js.png";
    public static final String JS_LIB_CSS_IMAGE_PATH = "images/xstudio/js/css.gif";
    static WebUiPlugin INSTANCE;
    private TemplateStore fTemplateStore;
    private ContextTypeRegistry fContextTypeRegistry;
    private static boolean browserLoadingErrorLoged;
    private static Map<Integer, String> browserNames;
    private static final boolean isMacOS;

    static {
        browserNames = new HashMap<Integer, String>();
        browserNames.put(65536, "Webkit");
        browserNames.put(32768, "Mozilla");
        isMacOS = "Mac OS X".equals(System.getProperty("os.name"));
    }

    public WebUiPlugin() {
        INSTANCE = this;
    }

    public static WebUiPlugin getDefault() {
        if (INSTANCE == null) {
            Platform.getBundle((String)PLUGIN_ID);
        }
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static boolean isDebugEnabled() {
        return INSTANCE != null && INSTANCE.isDebugging();
    }

    public static Shell getShell() {
        return INSTANCE == null ? null : INSTANCE.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static IPluginLog getPluginLog() {
        return WebUiPlugin.getDefault();
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), "org.jboss.tools.jsf.ui.custom_templates");
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                this.logError(e);
            }
        }
        return this.fTemplateStore;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType(TemplateContextTypeIdsXHTML.ALL);
            registry.addContextType(TemplateContextTypeIdsXHTML.NEW);
            registry.addContextType(TemplateContextTypeIdsXHTML.TAG);
            registry.addContextType(TemplateContextTypeIdsXHTML.ATTRIBUTE);
            registry.addContextType(TemplateContextTypeIdsXHTML.ATTRIBUTE_VALUE);
            this.fContextTypeRegistry = registry;
        }
        return this.fContextTypeRegistry;
    }

    public static Browser createBrowser(int style, Composite parent) {
        return WebUiPlugin.createBrowser(style, parent);
    }

    public static Browser createBrowser(Composite parent, int preferredBrowser) {
        return WebUiPlugin.createBrowser(24, parent, preferredBrowser);
    }

    /*
     * Unable to fully structure code
     */
    public static Browser createBrowser(int style, Composite parent, int preferredBrowser) {
        try {
            return new Browser(parent, style | preferredBrowser);
        }
        catch (Error e) {
            if (!(e instanceof SWTError) && !WebUiPlugin.browserLoadingErrorLoged) {
                WebUiPlugin.logBrowserLoadingProblem(e, WebUiPlugin.browserNames.get(preferredBrowser), true);
            }
            var8_5 = children = parent.getChildren();
            var7_6 = children.length;
            var6_7 = 0;
            ** while (var6_7 < var7_6)
        }
lbl-1000:
        // 1 sources

        {
            child = var8_5[var6_7];
            child.dispose();
            ++var6_7;
            continue;
        }
lbl14:
        // 1 sources

        try {
            return new Browser(parent, style);
        }
        catch (Error e1) {
            WebUiPlugin.logBrowserLoadingProblem(e1, null, false);
            return null;
        }
    }

    private static void logBrowserLoadingProblem(Error e, String browserName, boolean warning) {
        if (browserName == null) {
            browserName = "default";
        }
        String message = "Cannot create " + browserName + " browser";
        HTMLWizardVisualPreviewInitializationException ex = new HTMLWizardVisualPreviewInitializationException(message, e);
        if (warning) {
            WebUiPlugin.getDefault().logWarning(message, ex);
        } else {
            WebUiPlugin.getDefault().logError(message, ex);
        }
        browserLoadingErrorLoged = true;
    }

    public static int getPreferredBrowser() {
        return isMacOS ? 65536 : 32768;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbench workBench = INSTANCE == null ? null : INSTANCE.getWorkbench();
        IWorkbenchWindow workBenchWindow = workBench == null ? null : workBench.getActiveWorkbenchWindow();
        return workBenchWindow == null ? null : workBenchWindow.getShell();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench workBench = INSTANCE == null ? null : INSTANCE.getWorkbench();
        IWorkbenchWindow window = workBench == null ? null : workBench.getActiveWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }

    public static IWorkbenchSite getSite() {
        IWorkbenchPage page = WebUiPlugin.getActivePage();
        IWorkbenchPart part = page == null ? null : page.getActivePart();
        return part == null ? null : part.getSite();
    }

    protected void initializeDefaultPluginPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        JSPOccurrencePreferenceConstants.initializeDefaultValues(store);
    }

    public void initDefaultPluginPreferences() {
        IPreferenceStore store = JSPUIPlugin.getDefault().getPreferenceStore();
        JSPOccurrencePreferenceConstants.initializeDefaultValues(store);
    }

    public static JSPTextEditor getActiveEditor() {
        ITextEditor textEditor = EclipseUIUtil.getActiveEditor();
        JSPTextEditor editor = null;
        if (textEditor instanceof JSPTextEditor) {
            editor = (JSPTextEditor)textEditor;
        } else if (textEditor instanceof JSPMultiPageEditor) {
            editor = ((JSPMultiPageEditor)textEditor).getJspEditor();
        }
        return editor;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return WebUiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IHyperlinkDetector.class) {
            return HyperlinkDetector.getInstance();
        }
        return null;
    }
}

