/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.validator.wizards;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidateType;
import org.switchyard.tools.models.switchyard1_0.validate.FileEntryType;
import org.switchyard.tools.models.switchyard1_0.validate.SchemaCatalogsType;
import org.switchyard.tools.models.switchyard1_0.validate.SchemaFilesType;
import org.switchyard.tools.models.switchyard1_0.validate.ValidateFactory;
import org.switchyard.tools.models.switchyard1_0.validate.XmlSchemaType;
import org.switchyard.tools.models.switchyard1_0.validate.XmlValidateType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.ModelOperation;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.validator.wizards.BaseValidatorComposite;
import org.switchyard.tools.ui.editor.validator.wizards.FileEntryTable;

public class XMLValidatorComposite
extends BaseValidatorComposite {
    private Button _failOnWarningText;
    private Text _xsdFileText;
    private Combo _schemaTypeCombo;
    private FileEntryTable _schemaFileTable;
    private FileEntryTable _catalogFileTable;
    private Button _namespaceAwareCheckbox;

    XMLValidatorComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        super.createContents(parent, style, context);
        Composite outer = this.getToolkit().createComposite(this.getPanel(), 0);
        GridData outerGD = new GridData(4, 0, true, true, 2, 1);
        outerGD.horizontalIndent = -5;
        outerGD.verticalIndent = -5;
        outer.setLayoutData((Object)outerGD);
        outer.setLayout((Layout)new GridLayout(2, false));
        this._schemaTypeCombo = this.createLabelAndCombo(outer, Messages.label_schemaType, true);
        this._schemaTypeCombo.add("DTD", 0);
        this._schemaTypeCombo.setData("DTD", (Object)XmlSchemaType.DTD);
        this._schemaTypeCombo.add("XMLSCHEMA", 1);
        this._schemaTypeCombo.setData("XMLSCHEMA", (Object)XmlSchemaType.XMLSCHEMA);
        this._schemaTypeCombo.add("RELAX_NG", 2);
        this._schemaTypeCombo.setData("RELAX_NG", (Object)XmlSchemaType.RELAXNG);
        this._schemaTypeCombo.select(0);
        Composite inner = this.getToolkit().createComposite(this.getPanel(), 0);
        GridData innerGD = new GridData(4, 0, true, true, 2, 1);
        innerGD.horizontalIndent = -5;
        innerGD.verticalIndent = -5;
        inner.setLayoutData((Object)innerGD);
        inner.setLayout((Layout)new GridLayout(1, false));
        this.getToolkit().createLabel(inner, Messages.label_schemaFiles, 0);
        this._schemaFileTable = new FileEntryTable(inner, 0){

            @Override
            protected void removeFromList() {
                FileEntryType toRemove = XMLValidatorComposite.this._schemaFileTable.getTableSelection();
                if (toRemove != null) {
                    XMLValidatorComposite.this.removeFileEntry(toRemove);
                }
            }

            @Override
            protected void addFileEntryTypeToList() {
                XMLValidatorComposite.this.wrapOperation(new Runnable(){

                    @Override
                    public void run() {
                        String filepath = XMLValidatorComposite.this.handleBrowse(XMLValidatorComposite.this._schemaTypeCombo.getText().trim());
                        if (filepath != null) {
                            FileEntryType fileEntry = ValidateFactory.eINSTANCE.createFileEntryType();
                            fileEntry.setFile(filepath);
                            if (XMLValidatorComposite.this._schemaFileTable.getSelection() == null) {
                                XmlValidateType xmlValidator = (XmlValidateType)XMLValidatorComposite.this.getValidator();
                                xmlValidator.setSchemaFiles(ValidateFactory.eINSTANCE.createSchemaFilesType());
                                XMLValidatorComposite.this._schemaFileTable.setSelection((EList<FileEntryType>)xmlValidator.getSchemaFiles().getEntry());
                            }
                            XMLValidatorComposite.this._schemaFileTable.getSelection().add((Object)fileEntry);
                            this.fireChangedEvent(this);
                            XMLValidatorComposite.this.handleModify((Control)XMLValidatorComposite.this._schemaFileTable);
                            XMLValidatorComposite.this._schemaFileTable.getTreeViewer().refresh(true);
                        }
                    }
                });
            }
        };
        this._schemaFileTable.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        this.getToolkit().createLabel(inner, Messages.label_catalogFiles, 0);
        this._catalogFileTable = new FileEntryTable(inner, 0){

            @Override
            protected void removeFromList() {
                FileEntryType toRemove = XMLValidatorComposite.this._catalogFileTable.getTableSelection();
                if (toRemove != null) {
                    XMLValidatorComposite.this.removeCatalogFileEntry(toRemove);
                }
            }

            @Override
            protected void addFileEntryTypeToList() {
                XMLValidatorComposite.this.wrapOperation(new Runnable(){

                    @Override
                    public void run() {
                        String filepath = XMLValidatorComposite.this.handleBrowse(XMLValidatorComposite.this._schemaTypeCombo.getText().trim());
                        if (filepath != null) {
                            FileEntryType fileEntry = ValidateFactory.eINSTANCE.createFileEntryType();
                            fileEntry.setFile(filepath);
                            if (XMLValidatorComposite.this._catalogFileTable.getSelection() == null) {
                                XmlValidateType xmlValidator = (XmlValidateType)XMLValidatorComposite.this.getValidator();
                                xmlValidator.setSchemaCatalogs(ValidateFactory.eINSTANCE.createSchemaCatalogsType());
                                XMLValidatorComposite.this._catalogFileTable.setSelection((EList<FileEntryType>)xmlValidator.getSchemaCatalogs().getEntry());
                            }
                            XMLValidatorComposite.this._catalogFileTable.getSelection().add((Object)fileEntry);
                            this.fireChangedEvent(this);
                            XMLValidatorComposite.this.handleModify((Control)XMLValidatorComposite.this._schemaFileTable);
                            XMLValidatorComposite.this._catalogFileTable.getTreeViewer().refresh(true);
                        }
                    }
                });
            }
        };
        this._catalogFileTable.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        this._failOnWarningText = this.createCheckbox(this.getPanel(), Messages.label_failOnWarning);
        this._failOnWarningText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!XMLValidatorComposite.this.inUpdate()) {
                    XMLValidatorComposite.this.handleModify((Control)XMLValidatorComposite.this._failOnWarningText);
                    XMLValidatorComposite.this.fireChangedEvent(XMLValidatorComposite.this._failOnWarningText);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._namespaceAwareCheckbox = this.createCheckbox(this.getPanel(), Messages.label_namespaceAware);
        this._namespaceAwareCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!XMLValidatorComposite.this.inUpdate()) {
                    XMLValidatorComposite.this.handleModify((Control)XMLValidatorComposite.this._namespaceAwareCheckbox);
                    XMLValidatorComposite.this.fireChangedEvent(XMLValidatorComposite.this._namespaceAwareCheckbox);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setValidator(this.getValidator());
    }

    private void wrapOperation(final Runnable runner) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getValidator());
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        runner.run();
                    }
                    catch (Exception e) {
                        Activator.logError(e);
                    }
                }
            });
        } else {
            try {
                runner.run();
            }
            catch (Exception e) {
                Activator.logError(e);
            }
        }
    }

    private void removeFileEntry(final FileEntryType fileEntry) {
        if (this.getValidator() != null) {
            XmlValidateType xmlValidator = (XmlValidateType)this.getValidator();
            final SchemaFilesType schemaFiles = xmlValidator.getSchemaFiles();
            TransactionalEditingDomainImpl _editDomain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
            if (schemaFiles != null) {
                _editDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)_editDomain){

                    protected void doExecute() {
                        schemaFiles.getEntry().remove((Object)fileEntry);
                    }
                });
            }
        }
    }

    private void removeCatalogFileEntry(final FileEntryType fileEntry) {
        if (this.getValidator() != null) {
            XmlValidateType xmlValidator = (XmlValidateType)this.getValidator();
            final SchemaCatalogsType catalogFiles = xmlValidator.getSchemaCatalogs();
            TransactionalEditingDomainImpl _editDomain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
            if (catalogFiles != null) {
                _editDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)_editDomain){

                    protected void doExecute() {
                        catalogFiles.getEntry().remove((Object)fileEntry);
                    }
                });
            }
        }
    }

    @Override
    protected boolean validate() {
        String text;
        super.validate();
        if (this.getErrorMessage() == null && this._xsdFileText != null && !this._xsdFileText.isDisposed() && (text = this._xsdFileText.getText().trim()).length() == 0) {
            this.setErrorMessage(Messages.error_emptyFileName);
        }
        return this.getErrorMessage() == null;
    }

    @Override
    protected void handleModify(Control control) {
        if (control.equals(this._failOnWarningText)) {
            String value = Boolean.toString(this._failOnWarningText.getSelection());
            this.updateFeature((EObject)((XmlValidateType)this.getValidator()), "failOnWarning", value);
        } else if (control.equals(this._namespaceAwareCheckbox)) {
            String value = Boolean.toString(this._namespaceAwareCheckbox.getSelection());
            this.updateFeature((EObject)((XmlValidateType)this.getValidator()), "namespaceAware", value);
        } else if (control.equals(this._xsdFileText)) {
            this.updateFeature((EObject)((XmlValidateType)this.getValidator()), "schemaFile", this._xsdFileText.getText().trim());
        } else if (control.equals(this._schemaTypeCombo)) {
            XmlSchemaType selectedType = (XmlSchemaType)this._schemaTypeCombo.getData(this._schemaTypeCombo.getText());
            this.updateFeature((EObject)((XmlValidateType)this.getValidator()), "schemaType", selectedType);
        } else {
            super.handleModify(control);
        }
        this.validate();
    }

    @Override
    protected void handleUndo(Control control) {
        super.handleUndo(control);
        this.setInUpdate(true);
        if (this.getValidator() != null) {
            XmlValidateType xmlValidator = (XmlValidateType)this.getValidator();
            if (control.equals(this._failOnWarningText)) {
                boolean value = Boolean.parseBoolean(xmlValidator.getFailOnWarning());
                this._failOnWarningText.setSelection(value);
            } else if (control.equals(this._namespaceAwareCheckbox)) {
                boolean value = Boolean.parseBoolean(xmlValidator.getNamespaceAware());
                this._namespaceAwareCheckbox.setSelection(value);
            } else if (control.equals(this._schemaTypeCombo)) {
                this._schemaTypeCombo.select(xmlValidator.getSchemaType().getValue());
            }
        }
        this.setInUpdate(false);
    }

    @Override
    public void setValidator(ValidateType validator) {
        this.setInUpdate(true);
        super.setValidator(validator);
        XmlValidateType xmlValidator = (XmlValidateType)this.getValidator();
        if (xmlValidator != null) {
            SchemaCatalogsType catalogFiles;
            SchemaFilesType schemaFiles;
            boolean value;
            if (this._failOnWarningText != null && !this._failOnWarningText.isDisposed() && xmlValidator.getFailOnWarning() != null) {
                value = Boolean.parseBoolean(xmlValidator.getFailOnWarning());
                this._failOnWarningText.setSelection(value);
            }
            if (this._namespaceAwareCheckbox != null && !this._namespaceAwareCheckbox.isDisposed() && xmlValidator.getNamespaceAware() != null) {
                value = Boolean.parseBoolean(xmlValidator.getNamespaceAware());
                this._namespaceAwareCheckbox.setSelection(value);
            }
            if (this._schemaFileTable != null && !this._schemaFileTable.isDisposed() && xmlValidator != null && xmlValidator.getSchemaFiles() != null && (schemaFiles = xmlValidator.getSchemaFiles()).getEntry() != null) {
                this._schemaFileTable.setTargetObject((EObject)schemaFiles);
                this._schemaFileTable.setSelection((EList<FileEntryType>)schemaFiles.getEntry());
            }
            if (this._catalogFileTable != null && !this._catalogFileTable.isDisposed() && xmlValidator != null && xmlValidator.getSchemaCatalogs() != null && (catalogFiles = xmlValidator.getSchemaCatalogs()).getEntry() != null) {
                this._catalogFileTable.setTargetObject((EObject)catalogFiles);
                this._catalogFileTable.setSelection((EList<FileEntryType>)catalogFiles.getEntry());
            }
            if (this._schemaTypeCombo != null && !this._schemaTypeCombo.isDisposed() && xmlValidator.getSchemaType() != null) {
                this._schemaTypeCombo.select(xmlValidator.getSchemaType().getValue());
            }
        }
        this.setInUpdate(false);
        this.addObservableListeners();
    }

    private String handleBrowse(String type) {
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        IJavaProject javaProject = null;
        if (modelFile != null && modelFile.getProject() != null) {
            javaProject = JavaCore.create((IProject)modelFile.getProject());
        }
        ClasspathResourceSelectionDialog dialog = null;
        dialog = javaProject == null ? new ClasspathResourceSelectionDialog(Display.getCurrent().getActiveShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot()) : new ClasspathResourceSelectionDialog(Display.getCurrent().getActiveShell(), (IContainer)javaProject.getProject());
        String title = Messages.title_selectXsdDtdRngFile;
        String extension = "*.xsd,*.dtd,*.rng,*.rnc";
        if (type != null) {
            String value = type.trim();
            if (value.contentEquals("DTD")) {
                title = Messages.title_selectDtdFile;
                extension = "*.dtd";
            } else if (value.contentEquals("XMLSCHEMA")) {
                title = Messages.title_selectXsdFile;
                extension = "*.xsd";
            } else if (value.contentEquals("RELAX_NG")) {
                title = Messages.title_selectRelaxNgFile;
                extension = "*.rng";
            }
        }
        dialog.setTitle(title);
        dialog.setInitialPattern(extension);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IResource)) {
            return null;
        }
        String filepath = JavaUtil.getJavaPathForResource((IResource)((IResource)result[0])).toString();
        return filepath;
    }

    public class BasicOperation
    extends ModelOperation {
        private String _localObjectPath;
        private String _localFeature;
        private Object _localValue;

        public BasicOperation(String objectpath, String featureId, Object value) {
            this._localObjectPath = objectpath;
            this._localFeature = featureId;
            this._localValue = value;
        }

        @Override
        public void run() throws Exception {
            String[] path = XMLValidatorComposite.this.parseString(this._localObjectPath, "/");
            ValidateType object = XMLValidatorComposite.this.getValidator();
            int i = 0;
            while (i < path.length) {
                object = (EObject)XMLValidatorComposite.this.getFeatureValue((EObject)object, path[i]);
                ++i;
            }
            if (object != null) {
                if (this._localValue instanceof String && ((String)this._localValue).length() == 0) {
                    XMLValidatorComposite.this.setFeatureValue((EObject)object, this._localFeature, null);
                } else {
                    XMLValidatorComposite.this.setFeatureValue((EObject)object, this._localFeature, this._localValue);
                }
            } else {
                throw new Exception();
            }
        }
    }
}

