/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.editor.ComponentTypeExtensionManager;
import org.switchyard.tools.ui.editor.IComponentTypeExtension;
import org.switchyard.tools.ui.validation.ValidationProblem;

public class InterfaceTypeValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && (eObj instanceof ComponentReference || eObj instanceof ComponentService)) {
            return this.validate(ctx, (Contract)eObj);
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validate(IValidationContext ctx, Contract contract) {
        Interface intf = contract.getInterface();
        Component component = (Component)contract.eContainer();
        Implementation implementation = component.getImplementation();
        if (implementation == null) {
            return ctx.createSuccessStatus();
        }
        IComponentTypeExtension extension = ComponentTypeExtensionManager.instance().getExtensionFor(implementation.getClass());
        if (InterfaceControl.InterfaceType.isInstance((Interface)intf, extension.getSupportedInterfaceTypes(implementation))) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)contract, null, (int)ValidationProblem.IncompatibleInterfaceType.getSeverity(), (int)ValidationProblem.IncompatibleInterfaceType.ordinal(), (String)ValidationProblem.IncompatibleInterfaceType.getMessage(), (Object[])new Object[]{InterfaceControl.InterfaceType.valueOf((Interface)intf), extension.getTypeName(implementation), component.getName(), contract.getName()});
    }
}

