/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.transform.SmooksTransformType;
import org.switchyard.tools.models.switchyard1_0.transform.SmooksTransformType1;
import org.switchyard.tools.models.switchyard1_0.transform.TransformFactory;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.transform.INewTransformWizard;
import org.switchyard.tools.ui.editor.transform.ITransformControl;
import org.switchyard.tools.ui.editor.transform.ITransformProvider;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;

public class SmooksTransformProvider
implements ITransformProvider {
    @Override
    public boolean providesWizard() {
        return false;
    }

    @Override
    public INewTransformWizard createWizard() {
        return null;
    }

    @Override
    public ITransformControl createTransformControl(Composite parent, ITransformProvider.IContainer container) {
        return new SmooksTransformControl(parent, container);
    }

    @Override
    public String getName() {
        return Messages.label_smooksTransformer;
    }

    private static final class SmooksTransformControl
    implements ITransformControl {
        private final ITransformProvider.IContainer _container;
        private final IJavaProject _project;
        private Collection<TransformType> _transforms;
        private Composite _content;
        private Text _fileText;
        private Button _createNewFileCheckbox;

        private SmooksTransformControl(Composite parent, ITransformProvider.IContainer container) {
            this._container = container;
            this._project = JavaCore.create((IProject)container.getContainingProject());
            this._content = new Composite(parent, 0);
            this._content.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(this._content, 0);
            label.setText(Messages.label_smooksFile);
            this._fileText = new Text(this._content, 2052);
            this._fileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    SmooksTransformControl.this.internalValidate();
                }
            });
            this._fileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button browseButton = new Button(this._content, 8);
            browseButton.setText(Messages.button_browse);
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SmooksTransformControl.this.browse();
                }
            });
            new Label(this._content, 0);
            this._createNewFileCheckbox = new Button(this._content, 32);
            this._createNewFileCheckbox.setText(Messages.label_createNewSmooksFile);
            this._createNewFileCheckbox.setSelection(false);
            this._createNewFileCheckbox.setEnabled(false);
            this._createNewFileCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SmooksTransformControl.this.internalValidate();
                }
            });
        }

        @Override
        public void setVisible(boolean visible) {
            this._content.setVisible(visible);
        }

        @Override
        public void setSelectedTransforms(Collection<TransformType> transforms) {
            this._transforms = transforms;
        }

        @Override
        public IStatus validate() {
            if (this._transforms.size() > 1) {
                return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_smooksTransformerOnlySupportsSingleTransformation);
            }
            String pathString = this._fileText.getText();
            Path path = new Path(pathString);
            if (!path.isValidPath(pathString)) {
                return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_invalidSmooksFilePath);
            }
            try {
                IFile file = this._container.getContainingProject().getWorkspace().getRoot().getFile((IPath)path);
                if (this._createNewFileCheckbox.getSelection()) {
                    if (file.exists()) {
                        return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_smooksFileExists);
                    }
                } else if (!file.exists()) {
                    return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_smooksFileDoesNotExist);
                }
                if (!this._project.isOnClasspath((IResource)file.getParent())) {
                    return new Status(2, "org.switchyard.tools.ui.editor", Messages.error_smooksFileNotOnClasspath);
                }
            }
            catch (Exception e) {
                return new Status(4, "org.switchyard.tools.ui.editor", e.getMessage());
            }
            return Status.OK_STATUS;
        }

        @Override
        public Collection<TransformType> createTransforms() throws CoreException {
            if (this._transforms == null || this._transforms.isEmpty()) {
                return Collections.emptyList();
            }
            IFile smooksFile = this._project.getProject().getWorkspace().getRoot().getFile((IPath)new Path(this._fileText.getText()));
            String smooksFilePath = JavaUtil.getJavaPathForResource((IResource)smooksFile).toString();
            ArrayList<TransformType> smooksTransforms = new ArrayList<TransformType>(this._transforms.size());
            for (TransformType transform : this._transforms) {
                SmooksTransformType1 smooksTransform = TransformFactory.eINSTANCE.createSmooksTransformType1();
                smooksTransform.setFrom(transform.getFrom());
                smooksTransform.setTo(transform.getTo());
                smooksTransform.setConfig(smooksFilePath);
                if (NewTransformWizard.isJavaType(transform.getFrom())) {
                    if (NewTransformWizard.isJavaType(transform.getTo())) {
                        smooksTransform.setType(SmooksTransformType.SMOOKS);
                    } else {
                        smooksTransform.setType(SmooksTransformType.JAVA2XML);
                    }
                } else if (NewTransformWizard.isJavaType(transform.getTo())) {
                    smooksTransform.setType(SmooksTransformType.XML2JAVA);
                } else {
                    smooksTransform.setType(SmooksTransformType.SMOOKS);
                }
                smooksTransforms.add((TransformType)smooksTransform);
            }
            return smooksTransforms;
        }

        @Override
        public void setLayoutData(Object data) {
            this._content.setLayoutData(data);
        }

        @Override
        public void dispose() {
        }

        private void internalValidate() {
            this._container.updateStatus(this, this.validate());
        }

        private void browse() {
            IResource temp;
            Path path;
            IResource temp2;
            String pathString = this._fileText.getText();
            Object resource = pathString == null || pathString.isEmpty() ? ((temp2 = JavaUtil.getFirstResourceRoot((IJavaProject)this._project)) == null ? this._project.getResource() : temp2) : ((path = new Path(pathString)).isValidPath(pathString) ? this._project.getProject().getWorkspace().getRoot().getFile((IPath)path) : ((temp = JavaUtil.getFirstResourceRoot((IJavaProject)this._project)) == null ? this._project.getResource() : temp));
            ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(this._content.getShell(), (IContainer)resource.getProject(), "xml");
            dialog.setInitialPattern("*.xml");
            dialog.setTitle(Messages.title_selectSmooksFile);
            if (dialog.open() == 0) {
                this._fileText.setText(((IResource)dialog.getFirstResult()).getFullPath().toString());
            }
        }
    }
}

