/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.transform.INewTransformWizard;
import org.switchyard.tools.ui.editor.transform.ITransformControl;
import org.switchyard.tools.ui.editor.transform.ITransformProvider;
import org.switchyard.tools.ui.editor.transform.TransformDetails;
import org.switchyard.tools.ui.editor.transform.TransformProviderRegistry;
import org.switchyard.tools.ui.editor.util.TransformTypesUtil;

public class NewTransformWizardPage
extends WizardPage
implements ITransformProvider.IContainer {
    private TransformDetails _details;
    private IProject _project;
    private CheckboxTableViewer _transformsTable;
    private ListViewer _detailsList;
    private Button _selectAll;
    private Button _deselectAll;
    private ComboViewer _transformProviderList;
    private ITransformProvider _selectedProvider;
    private ITransformControl _activeControl;
    private Map<ITransformProvider, ITransformControl> _providerControls = new HashMap<ITransformProvider, ITransformControl>();
    private Map<ITransformProvider, INewTransformWizard> _providerWizards = new HashMap<ITransformProvider, INewTransformWizard>();
    private Collection<TransformType> _newTransforms;
    private ICheckStateListener _checkListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (NewTransformWizardPage.this._activeControl == null) {
                INewTransformWizard providerWizard = (INewTransformWizard)NewTransformWizardPage.this._providerWizards.get(NewTransformWizardPage.this._selectedProvider);
                if (providerWizard != null) {
                    providerWizard.setSelectedTransforms(NewTransformWizardPage.this.getSelectedTransforms());
                }
            } else {
                NewTransformWizardPage.this._activeControl.setSelectedTransforms(NewTransformWizardPage.this.getSelectedTransforms());
            }
            NewTransformWizardPage.this.validate(null);
        }
    };

    public NewTransformWizardPage() {
        super(NewTransformWizardPage.class.getCanonicalName());
        this.setTitle(Messages.title_newTransformers);
        this.setDescription(Messages.description_newTransformers);
    }

    public void init(TransformDetails details) {
        this._details = details;
        this._project = PlatformResourceAdapterFactory.getContainingProject((Object)details.getSwitchYard());
        if (this._transformsTable == null || this._transformsTable.getControl().isDisposed()) {
            return;
        }
        this._transformsTable.setInput((Object)details);
        this._transformsTable.setCheckedElements(details.getRequiredTransforms().toArray());
        this.validate(null);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite content = new Composite(parent, 0);
        content.setFont(parent.getFont());
        content.setLayout((Layout)new GridLayout(3, false));
        Label transformLabel = new Label(content, 0);
        transformLabel.setText(Messages.label_transformerTypePairs);
        transformLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        Composite tableComposite = new Composite(content, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        this.createTransformsTable(tableComposite, tableLayout);
        GridData tableCompositeGD = new GridData(4, 4, true, true, 2, 2);
        tableCompositeGD.heightHint = this._transformsTable.getTable().getHeaderHeight() + this._transformsTable.getTable().getItemHeight() * 5;
        tableComposite.setLayoutData((Object)tableCompositeGD);
        this._selectAll = new Button(content, 8);
        this._selectAll.setText(Messages.button_selectAll);
        this._selectAll.setLayoutData((Object)new GridData(4, 128, false, false));
        this._selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewTransformWizardPage.this._transformsTable.setCheckedElements(((TransformDetails)NewTransformWizardPage.this._transformsTable.getInput()).getRequiredTransforms().toArray());
                NewTransformWizardPage.this._checkListener.checkStateChanged(null);
            }
        });
        this._deselectAll = new Button(content, 8);
        this._deselectAll.setText(Messages.button_deselectAll);
        this._deselectAll.setLayoutData((Object)new GridData(4, 128, false, false));
        this._deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewTransformWizardPage.this._transformsTable.setCheckedElements(new Object[0]);
                NewTransformWizardPage.this._checkListener.checkStateChanged(null);
            }
        });
        Label detailsLabel = new Label(content, 0);
        detailsLabel.setText(Messages.label_interactionContextForSelectedTypePairs);
        detailsLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        this._detailsList = new ListViewer(content, 2824);
        GridData detailsGD = new GridData(4, 128, true, false, 3, 1);
        detailsGD.heightHint = this._detailsList.getList().getItemHeight() * 3;
        this._detailsList.getControl().setLayoutData((Object)detailsGD);
        this._detailsList.getList().setEnabled(false);
        this._detailsList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._detailsList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Label separator = new Label(content, 258);
        separator.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        ((GridData)separator.getLayoutData()).heightHint = 20;
        Label transformTypeLabel = new Label(content, 0);
        transformTypeLabel.setText(Messages.label_transformerType);
        this._transformProviderList = new ComboViewer(content);
        this._transformProviderList.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._transformProviderList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._transformProviderList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ITransformProvider)element).getName();
            }
        });
        this._transformProviderList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (NewTransformWizardPage.this._activeControl != null) {
                    NewTransformWizardPage.this._activeControl.setVisible(false);
                }
                if (event.getSelection().isEmpty()) {
                    NewTransformWizardPage.this._activeControl = null;
                    NewTransformWizardPage.this._selectedProvider = null;
                } else {
                    NewTransformWizardPage.this._selectedProvider = (ITransformProvider)((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (!NewTransformWizardPage.this._selectedProvider.providesWizard()) {
                        NewTransformWizardPage.this._activeControl = (ITransformControl)NewTransformWizardPage.this._providerControls.get(NewTransformWizardPage.this._selectedProvider);
                        if (NewTransformWizardPage.this._activeControl != null) {
                            NewTransformWizardPage.this._activeControl.setSelectedTransforms(NewTransformWizardPage.this.getSelectedTransforms());
                            NewTransformWizardPage.this._activeControl.setVisible(true);
                        }
                    } else {
                        NewTransformWizardPage.this._activeControl = null;
                    }
                }
                NewTransformWizardPage.this.validate(null);
                if (NewTransformWizardPage.this.getWizard().getContainer().getCurrentPage() != null) {
                    NewTransformWizardPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        Composite providers = new Composite(content, 0);
        providers.setLayout((Layout)new FormLayout());
        providers.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        for (ITransformProvider provider : TransformProviderRegistry.instance().getProviders()) {
            if (provider.providesWizard()) continue;
            ITransformControl providerControl = provider.createTransformControl(providers, this);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0);
            formData.bottom = new FormAttachment(100);
            formData.left = new FormAttachment(0);
            formData.right = new FormAttachment(100);
            providerControl.setLayoutData(formData);
            providerControl.setVisible(false);
            this._providerControls.put(provider, providerControl);
        }
        this.setControl((Control)content);
        Dialog.applyDialogFont((Control)content);
        this.initControls();
        this.validate(null);
        this.setErrorMessage(null);
    }

    private void createTransformsTable(Composite parent, TableColumnLayout tableLayout) {
        this._transformsTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)68352);
        Table table = this._transformsTable.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn from = new TableColumn(table, 16384);
        from.setText(Messages.label_from);
        from.setResizable(true);
        tableLayout.setColumnData((Widget)from, (ColumnLayoutData)new ColumnWeightData(50));
        TableColumn to = new TableColumn(table, 16384);
        to.setText(Messages.label_to);
        to.setResizable(true);
        tableLayout.setColumnData((Widget)to, (ColumnLayoutData)new ColumnWeightData(50));
        this._transformsTable.setLabelProvider((IBaseLabelProvider)new TransformTypeLabelProvider());
        this._transformsTable.setContentProvider((IContentProvider)new TransformDetailsContentProvider());
        this._transformsTable.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                TransformDetails input = (TransformDetails)NewTransformWizardPage.this._transformsTable.getInput();
                return input != null && !input.getDeclaredTransforms().contains(element);
            }
        });
        this._transformsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    NewTransformWizardPage.this._detailsList.setInput(Collections.emptyList());
                    return;
                }
                TransformDetails input = (TransformDetails)NewTransformWizardPage.this._transformsTable.getInput();
                if (input == null) {
                    NewTransformWizardPage.this._detailsList.setInput(Collections.emptyList());
                    return;
                }
                Set<String> detailsSet = input.getTransformDetails((TransformType)((IStructuredSelection)event.getSelection()).getFirstElement());
                if (detailsSet == null) {
                    NewTransformWizardPage.this._detailsList.setInput(Collections.emptyList());
                    return;
                }
                NewTransformWizardPage.this._detailsList.setInput(detailsSet);
            }
        });
        this._transformsTable.addCheckStateListener(this._checkListener);
    }

    public void dispose() {
        for (ITransformControl control : this._providerControls.values()) {
            if (control == null) continue;
            try {
                control.dispose();
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        for (INewTransformWizard wizard : this._providerWizards.values()) {
            if (wizard == null) continue;
            try {
                wizard.dispose();
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        super.dispose();
    }

    @Override
    public IRunnableContext getContext() {
        return this.getWizard().getContainer();
    }

    @Override
    public void updateStatus(ITransformControl control, IStatus status) {
        if (control != this._activeControl) {
            return;
        }
        this.validate(status);
    }

    @Override
    public IProject getContainingProject() {
        return this._project;
    }

    public boolean performFinish() {
        if (this._activeControl != null) {
            try {
                this._newTransforms = this._activeControl.createTransforms();
            }
            catch (CoreException e) {
                Activator.logStatus(e.getStatus());
            }
        }
        return true;
    }

    public Collection<TransformType> getCreatedTransforms() {
        if (this._activeControl == null) {
            INewTransformWizard providerWizard = this._providerWizards.get(this._selectedProvider);
            return providerWizard.getCreatedTransforms();
        }
        return this._newTransforms;
    }

    private void initControls() {
        this._transformsTable.setInput((Object)this._details);
        this._transformsTable.setCheckedElements(this._details.getRequiredTransforms().toArray());
        List<ITransformProvider> providers = TransformProviderRegistry.instance().getProviders();
        this._transformProviderList.setInput(providers);
        if (providers.size() > 0) {
            this._transformProviderList.setSelection((ISelection)new StructuredSelection((Object)providers.get(0)), true);
        }
    }

    private void validate(IStatus status) {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this._transformsTable.getCheckedElements().length == 0) {
            this.setErrorMessage(Messages.error_selectOneOrMoreTransformPairs);
        } else if (this._activeControl == null && !this._selectedProvider.providesWizard()) {
            this.setErrorMessage(Messages.error_selectTransformerImplementationType);
        } else {
            if (status == null && !this._selectedProvider.providesWizard()) {
                status = this._activeControl.validate();
            }
            if (status != null && !status.isOK()) {
                switch (status.getSeverity()) {
                    case 1: {
                        this.setMessage(status.getMessage(), 1);
                        break;
                    }
                    case 2: {
                        this.setMessage(status.getMessage(), 2);
                        break;
                    }
                    default: {
                        this.setErrorMessage(status.getMessage());
                    }
                }
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected INewTransformWizard getNextWizard() {
        if (this._selectedProvider == null || !this._selectedProvider.providesWizard()) {
            return null;
        }
        INewTransformWizard providerWizard = this._providerWizards.get(this._selectedProvider);
        if (providerWizard == null) {
            providerWizard = this._selectedProvider.createWizard();
            providerWizard.init(this._project);
            providerWizard.setSelectedTransforms(this.getSelectedTransforms());
            providerWizard.addPages();
            this._providerWizards.put(this._selectedProvider, providerWizard);
        }
        return providerWizard;
    }

    private Collection<TransformType> getSelectedTransforms() {
        if (this._transformsTable == null) {
            return Collections.emptyList();
        }
        Object[] checked = this._transformsTable.getCheckedElements();
        ArrayList<TransformType> transforms = new ArrayList<TransformType>(checked.length);
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            transforms.add((TransformType)obj);
            ++n2;
        }
        return transforms;
    }

    private static final class TransformDetailsContentProvider
    implements IStructuredContentProvider {
        private TransformDetailsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((TransformDetails)inputElement).getRequiredTransforms().toArray();
        }
    }

    private static final class TransformTypeLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private TransformTypeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return TransformTypesUtil.getLabelForType(((TransformType)element).getFrom());
            }
            return TransformTypesUtil.getLabelForType(((TransformType)element).getTo());
        }
    }
}

