/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.implementation;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class ImplementationPolicyComposite
extends AbstractModelComposite<Component>
implements ITabbedPropertyConstants {
    private final String _noneString = "None";
    private boolean _inUpdate = false;
    private Combo _implementationCombo;
    private ArrayList<String> _supportedImplementationPolicies = new ArrayList();

    public ImplementationPolicyComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        this._supportedImplementationPolicies.add("managedTransaction.Global");
        this._supportedImplementationPolicies.add("managedTransaction.Local");
        this._supportedImplementationPolicies.add("noManagedTransaction");
        this.setLayout((Layout)new GridLayout(2, false));
        FormToolkit factory = this.getWidgetFactory();
        factory.createLabel((Composite)this, Messages.label_transactionPolicy);
        this._implementationCombo = new Combo((Composite)this, 2060);
        factory.adapt((Control)this._implementationCombo, true, false);
        this._implementationCombo.add("None");
        for (String policy : this._supportedImplementationPolicies) {
            this._implementationCombo.add(policy);
        }
        this._implementationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._implementationCombo.addSelectionListener((SelectionListener)new ComboSelectionListener());
    }

    private void updatePolicy(final Component component, Control control, final String value) {
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                ArrayList<QName> requires = new ArrayList<QName>();
                component.getImplementation().setRequires(null);
                if (!value.trim().isEmpty() && !value.contentEquals("None")) {
                    QName newQName = new QName(value);
                    requires.add(newQName);
                }
                if (!requires.isEmpty()) {
                    component.getImplementation().setRequires(requires);
                }
            }
        });
    }

    @Override
    public void refresh() {
        this._inUpdate = true;
        try {
            List requires;
            String implementationPolicy = null;
            Component component = (Component)this.getTargetObject();
            if (component != null && component.getImplementation() != null && (requires = component.getImplementation().getRequires()) != null) {
                for (QName requiresItem : requires) {
                    String localPart = requiresItem.getLocalPart();
                    if (!this._supportedImplementationPolicies.contains(localPart)) continue;
                    implementationPolicy = localPart;
                    break;
                }
            }
            if (implementationPolicy != null && !this._implementationCombo.isDisposed()) {
                try {
                    this._implementationCombo.setText(implementationPolicy);
                }
                catch (SWTException se) {
                    se.fillInStackTrace();
                }
            } else if (!this._implementationCombo.isDisposed()) {
                try {
                    this._implementationCombo.setText("None");
                }
                catch (SWTException se) {
                    se.fillInStackTrace();
                }
            }
        }
        finally {
            this._inUpdate = false;
        }
    }

    private class ComboSelectionListener
    implements SelectionListener {
        private ComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Component component = (Component)ImplementationPolicyComposite.this.getTargetObject();
            if (component != null && !ImplementationPolicyComposite.this._inUpdate) {
                ImplementationPolicyComposite.this.updatePolicy(component, (Control)ImplementationPolicyComposite.this._implementationCombo, ImplementationPolicyComposite.this._implementationCombo.getText().trim());
            }
        }
    }
}

