/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.composite;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidateType;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidatesType;
import org.switchyard.tools.models.switchyard1_0.validate.JavaValidateType;
import org.switchyard.tools.models.switchyard1_0.validate.ValidatePackage;
import org.switchyard.tools.models.switchyard1_0.validate.XmlValidateType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.model.merge.SwitchYardMergedModelAdapter;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;
import org.switchyard.tools.ui.editor.property.adapters.LabelAdapter;
import org.switchyard.tools.ui.editor.validator.wizards.AddValidatorWizard;

public class ValidatorsControlComposite
extends AbstractModelComposite<Composite>
implements ResourceSetListener {
    private Composite _composite;
    private ValidateType _validator = null;
    private TableViewer _tableViewer;
    private FormToolkit _toolkit = null;
    private Button _addButton;
    private Button _editButton;
    private Button _removeButton;
    private TransactionalEditingDomain _domain = null;

    public ValidatorsControlComposite(ICompositeContainer container, org.eclipse.swt.widgets.Composite parent, int style) {
        super(Composite.class, container, parent, style);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        this._toolkit = this.getWidgetFactory();
        this._addButton = this._toolkit.createButton((org.eclipse.swt.widgets.Composite)this, Messages.button_add, 8);
        this._addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ValidatorsControlComposite.this.addValidator();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._editButton = this._toolkit.createButton((org.eclipse.swt.widgets.Composite)this, Messages.button_edit, 8);
        this._editButton.setEnabled(false);
        this._editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ValidatorsControlComposite.this.editValidator();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._removeButton = this._toolkit.createButton((org.eclipse.swt.widgets.Composite)this, Messages.button_remove, 8);
        this._removeButton.setEnabled(false);
        this._removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)ValidatorsControlComposite.this._tableViewer.getSelection();
                if (ssel.size() == 1) {
                    ValidatorsControlComposite.this.removeValidator((ValidateType)ssel.getFirstElement());
                } else {
                    ValidatorsControlComposite.this.removeValidators(ssel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        TableColumnLayout tableLayout = new TableColumnLayout();
        org.eclipse.swt.widgets.Composite tableComposite = this._toolkit.createComposite((org.eclipse.swt.widgets.Composite)this);
        tableComposite.setLayout((Layout)tableLayout);
        this._tableViewer = new TableViewer(tableComposite, 68354);
        Label legend = new Label((org.eclipse.swt.widgets.Composite)this, 0);
        legend.setText(Messages.label_starEqualsGeneratedValidator);
        FormData data = new FormData();
        data.right = new FormAttachment(95, 0);
        data.width = 80;
        this._addButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(95, 0);
        data.width = 80;
        data.top = new FormAttachment((Control)this._addButton, 5);
        this._editButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(95, 0);
        data.width = 80;
        data.top = new FormAttachment((Control)this._editButton, 5);
        this._removeButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this._addButton, -5);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(90, 0);
        tableComposite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)tableComposite, 5);
        legend.setLayoutData((Object)data);
        Table table = this._tableViewer.getTable();
        TableColumn tc2 = new TableColumn(table, 16384);
        tc2.setText(Messages.label_name);
        tableLayout.setColumnData((Widget)tc2, (ColumnLayoutData)new ColumnWeightData(45));
        tc2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((ColumnViewerSorter)ValidatorsControlComposite.this._tableViewer.getSorter()).doSort(0);
                ValidatorsControlComposite.this._tableViewer.refresh();
            }
        });
        TableColumn tc1 = new TableColumn(table, 16384);
        tc1.setText(Messages.label_type);
        tableLayout.setColumnData((Widget)tc1, (ColumnLayoutData)new ColumnWeightData(45));
        tc1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((ColumnViewerSorter)ValidatorsControlComposite.this._tableViewer.getSorter()).doSort(1);
                ValidatorsControlComposite.this._tableViewer.refresh();
            }
        });
        this._tableViewer.setSorter((ViewerSorter)new ColumnViewerSorter());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new ValidatorTableLabelProvider());
        this._tableViewer.setContentProvider((IContentProvider)new ValidatorTableContentProvider());
        this._tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                if (!ssel.isEmpty() && ssel.getFirstElement() instanceof ValidateType) {
                    ValidatorsControlComposite.this._validator = (ValidateType)ssel.getFirstElement();
                    ValidatorsControlComposite.this.handleSelectListItem();
                }
            }
        });
        this.adaptChildren((Control)this);
        this.addDomainListener();
    }

    @Override
    public void refresh() {
        Composite composite = (Composite)this.getTargetObject();
        if (composite != null) {
            this._composite = composite;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SwitchYardType switchYardRoot = ValidatorsControlComposite.this.getSwitchYardRoot((EObject)ValidatorsControlComposite.this._composite);
                    if (ValidatorsControlComposite.this._tableViewer.getTable().isDisposed()) {
                        return;
                    }
                    if (switchYardRoot == null) {
                        ValidatorsControlComposite.this._tableViewer.setInput(null);
                    } else {
                        ValidatorsControlComposite.this._tableViewer.setInput(MergedModelUtil.getAdapter((EObject)switchYardRoot, SwitchYardMergedModelAdapter.class).getValidates());
                    }
                    ValidatorsControlComposite.this.getContainer().layout();
                }
            });
        }
    }

    private void handleSelectListItem() {
        IStructuredSelection ssel = (IStructuredSelection)this._tableViewer.getSelection();
        boolean singleSelect = false;
        if (ssel != null && ssel.size() == 1) {
            singleSelect = true;
        }
        if (this._removeButton != null && !this._removeButton.isDisposed() && this._editButton != null && !this._editButton.isDisposed()) {
            URI _modelUri = URI.createPlatformResourceURI((String)SwitchyardSCAEditor.getActiveEditor().getModelFile().getFullPath().toString(), (boolean)true);
            if (this._validator.eResource().getURI().equals(_modelUri)) {
                this._removeButton.setEnabled(this._validator != null);
                this._editButton.setEnabled(this._validator != null && singleSelect);
            } else {
                this._removeButton.setEnabled(false);
                this._editButton.setEnabled(false);
            }
        }
    }

    private SwitchYardType getSwitchYardRoot(EObject object) {
        if (object != null) {
            return MergedModelUtil.getSwitchYard(object);
        }
        return null;
    }

    private Object removeListItem(EObject object, EStructuralFeature feature, int index) {
        EList list = (EList)object.eGet(feature);
        return list.remove(index);
    }

    private ValidateType addValidator() {
        ValidateType newValidator = null;
        AddValidatorWizard wizard = new AddValidatorWizard();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog wizDialog = new WizardDialog(shell, (IWizard)wizard);
        int rtn_code = wizDialog.open();
        if (rtn_code == 0) {
            newValidator = wizard.getValidator();
            if (this._domain != null) {
                final ValidateType validator = newValidator;
                this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                    protected void doExecute() {
                        SwitchYardType switchYardRoot = ValidatorsControlComposite.this.getSwitchYardRoot((EObject)ValidatorsControlComposite.this._composite);
                        ValidatesType validates = switchYardRoot.getValidates();
                        if (validates == null) {
                            switchYardRoot.setValidates(SwitchyardFactory.eINSTANCE.createValidatesType());
                            validates = switchYardRoot.getValidates();
                        }
                        FeatureMap validatorGroup = validates.getValidateGroup();
                        if (validator instanceof JavaValidateType) {
                            validatorGroup.add((EStructuralFeature)ValidatePackage.eINSTANCE.getDocumentRoot_ValidateJava(), (Object)validator);
                        } else if (validator instanceof XmlValidateType) {
                            validatorGroup.add((EStructuralFeature)ValidatePackage.eINSTANCE.getDocumentRoot_ValidateXml(), (Object)validator);
                        }
                    }
                });
                this.refresh();
            }
        }
        return newValidator;
    }

    private ValidateType editValidator() {
        IStructuredSelection selected = (IStructuredSelection)this._tableViewer.getSelection();
        if (selected != null && this._domain != null) {
            AddValidatorWizard wizard = new AddValidatorWizard();
            wizard.setValidator((ValidateType)selected.getFirstElement());
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            WizardDialog wizDialog = new WizardDialog(shell, (IWizard)wizard);
            int rtn_code = wizDialog.open();
            if (rtn_code == 0) {
                final ValidateType oldValidator = (ValidateType)selected.getFirstElement();
                final ValidateType validator = wizard.getValidator();
                this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                    protected void doExecute() {
                        SwitchYardType switchYardRoot = ValidatorsControlComposite.this.getSwitchYardRoot((EObject)ValidatorsControlComposite.this._composite);
                        ValidatesType validates = switchYardRoot.getValidates();
                        if (validates == null) {
                            switchYardRoot.setValidates(SwitchyardFactory.eINSTANCE.createValidatesType());
                            validates = switchYardRoot.getValidates();
                        }
                        FeatureMap validatorGroup = validates.getValidateGroup();
                        validatorGroup.remove((Object)oldValidator);
                        if (validator instanceof JavaValidateType) {
                            validatorGroup.add((EStructuralFeature)ValidatePackage.eINSTANCE.getDocumentRoot_ValidateJava(), (Object)validator);
                        } else if (validator instanceof XmlValidateType) {
                            validatorGroup.add((EStructuralFeature)ValidatePackage.eINSTANCE.getDocumentRoot_ValidateXml(), (Object)validator);
                        }
                    }
                });
                this.refresh();
            }
        }
        return null;
    }

    private void removeValidators(final IStructuredSelection ssel) {
        if (ssel != null && this._domain != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    SwitchYardType switchYardRoot = ValidatorsControlComposite.this.getSwitchYardRoot((EObject)ValidatorsControlComposite.this._composite);
                    ValidatesType validators = switchYardRoot.getValidates();
                    for (Object next : ssel) {
                        EStructuralFeature feature;
                        int index;
                        XmlValidateType validator;
                        if (next instanceof XmlValidateType) {
                            validator = (XmlValidateType)next;
                            index = validators.getValidate().indexOf((Object)validator);
                            feature = validators.eClass().getEStructuralFeature("validate");
                            ValidatorsControlComposite.this.removeListItem((EObject)validators, feature, index);
                            continue;
                        }
                        if (!(next instanceof JavaValidateType)) continue;
                        validator = (JavaValidateType)next;
                        index = validators.getValidate().indexOf((Object)validator);
                        feature = validators.eClass().getEStructuralFeature("validate");
                        ValidatorsControlComposite.this.removeListItem((EObject)validators, feature, index);
                    }
                }
            });
            this.refresh();
        }
    }

    private void removeValidator(final ValidateType selected) {
        if (selected != null && this._domain != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    SwitchYardType switchYardRoot = ValidatorsControlComposite.this.getSwitchYardRoot((EObject)ValidatorsControlComposite.this._composite);
                    ValidatesType validators = switchYardRoot.getValidates();
                    int index = validators.getValidate().indexOf((Object)selected);
                    EStructuralFeature feature = validators.eClass().getEStructuralFeature("validate");
                    ValidatorsControlComposite.this.removeListItem((EObject)validators, feature, index);
                }
            });
            this.refresh();
        }
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent arg0) {
        this.refresh();
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent arg0) throws RollbackException {
        return null;
    }

    private void addDomainListener() {
        if (this._domain == null) {
            this._domain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
            this._domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    private void removeDomainListener() {
        if (this._domain != null) {
            this._domain.removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public void dispose() {
        this.removeDomainListener();
        super.dispose();
    }

    final class ColumnConst {
        public static final int COLUMN_NAME = 0;
        public static final int COLUMN_TYPE = 1;

        private ColumnConst() {
        }
    }

    class ColumnViewerSorter
    extends ViewerSorter {
        private static final int ASCENDING = 0;
        private static final int DESCENDING = 1;
        private int _column;
        private int _direction;

        ColumnViewerSorter() {
        }

        public void doSort(int column) {
            if (column == this._column) {
                this._direction = 1 - this._direction;
            } else {
                this._column = column;
                this._direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int rc = 0;
            ValidateType p1 = (ValidateType)e1;
            ValidateType p2 = (ValidateType)e2;
            switch (this._column) {
                case 0: {
                    rc = this.getComparator().compare(p1.getName(), p2.getName());
                    break;
                }
                case 1: {
                    String type1 = LabelAdapter.getLabel((EObject)p1);
                    String type2 = LabelAdapter.getLabel((EObject)p2);
                    rc = this.getComparator().compare(type1, type2);
                }
            }
            if (this._direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class ValidatorTableContentProvider
    implements IStructuredContentProvider {
        private ValidatorTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EList) {
                EList v = (EList)inputElement;
                return v.toArray();
            }
            if (inputElement instanceof List) {
                List v = (List)inputElement;
                return v.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ValidatorTableLabelProvider
    implements ITableLabelProvider {
        private ValidatorTableLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ValidateType) {
                ValidateType validator = (ValidateType)element;
                if (columnIndex == 0) {
                    return validator.getName();
                }
                if (columnIndex == 1) {
                    return LabelAdapter.getLabel((EObject)validator);
                }
            }
            return null;
        }
    }
}

