/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.composite;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformsType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.model.merge.SwitchYardMergedModelAdapter;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;
import org.switchyard.tools.ui.editor.property.adapters.LabelAdapter;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;
import org.switchyard.tools.ui.editor.transform.TransformDetails;
import org.switchyard.tools.ui.editor.util.TransformTypesUtil;

public class TransformsControlComposite
extends AbstractModelComposite<Composite>
implements ResourceSetListener {
    private Composite _composite;
    private TransformType _transformer = null;
    private TableViewer _tableViewer;
    private FormToolkit _toolkit = null;
    private Button _addButton;
    private Button _removeButton;
    private TransactionalEditingDomain _domain = null;

    public TransformsControlComposite(ICompositeContainer container, org.eclipse.swt.widgets.Composite parent, int style) {
        super(Composite.class, container, parent, style);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        this._toolkit = this.getWidgetFactory();
        this._addButton = this._toolkit.createButton((org.eclipse.swt.widgets.Composite)this, Messages.button_add, 8);
        this._addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransformsControlComposite.this.addTransform();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._removeButton = this._toolkit.createButton((org.eclipse.swt.widgets.Composite)this, Messages.button_remove, 8);
        this._removeButton.setEnabled(false);
        this._removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)TransformsControlComposite.this._tableViewer.getSelection();
                if (ssel.size() == 1) {
                    TransformsControlComposite.this.removeTransform((TransformType)ssel.getFirstElement());
                } else {
                    TransformsControlComposite.this.removeTransforms(ssel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        TableColumnLayout tableLayout = new TableColumnLayout();
        org.eclipse.swt.widgets.Composite tableComposite = this._toolkit.createComposite((org.eclipse.swt.widgets.Composite)this);
        tableComposite.setLayout((Layout)tableLayout);
        this._tableViewer = new TableViewer(tableComposite, 68354);
        Label legend = new Label((org.eclipse.swt.widgets.Composite)this, 0);
        legend.setText(Messages.label_starEqualsGeneratedTransform);
        FormData data = new FormData();
        data.right = new FormAttachment(95, 0);
        data.width = 80;
        this._addButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(95, 0);
        data.width = 80;
        data.top = new FormAttachment((Control)this._addButton, 5);
        this._removeButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this._addButton, -5);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(90, 0);
        tableComposite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)tableComposite, 5);
        legend.setLayoutData((Object)data);
        Table table = this._tableViewer.getTable();
        TableColumn tc2 = new TableColumn(table, 16384);
        tc2.setText(Messages.label_from);
        tableLayout.setColumnData((Widget)tc2, (ColumnLayoutData)new ColumnWeightData(45));
        tc2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((ColumnViewerSorter)TransformsControlComposite.this._tableViewer.getSorter()).doSort(0);
                TransformsControlComposite.this._tableViewer.refresh();
            }
        });
        TableColumn tc1 = new TableColumn(table, 16384);
        tc1.setText(Messages.label_to);
        tableLayout.setColumnData((Widget)tc1, (ColumnLayoutData)new ColumnWeightData(45));
        tc1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((ColumnViewerSorter)TransformsControlComposite.this._tableViewer.getSorter()).doSort(1);
                TransformsControlComposite.this._tableViewer.refresh();
            }
        });
        TableColumn tc3 = new TableColumn(table, 16384);
        tc3.setText(Messages.label_type);
        tableLayout.setColumnData((Widget)tc3, (ColumnLayoutData)new ColumnWeightData(10));
        tc3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((ColumnViewerSorter)TransformsControlComposite.this._tableViewer.getSorter()).doSort(2);
                TransformsControlComposite.this._tableViewer.refresh();
            }
        });
        this._tableViewer.setSorter((ViewerSorter)new ColumnViewerSorter());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new TransformTableLabelProvider());
        this._tableViewer.setContentProvider((IContentProvider)new TransformTableContentProvider());
        this._tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                if (!ssel.isEmpty() && ssel.getFirstElement() instanceof TransformType) {
                    TransformsControlComposite.this._transformer = (TransformType)ssel.getFirstElement();
                    TransformsControlComposite.this.handleSelectListItem();
                }
            }
        });
        this.adaptChildren((Control)this);
    }

    @Override
    public void refresh() {
        final Composite composite = (Composite)this.getTargetObject();
        if (composite != null) {
            this._composite = composite;
            this.addDomainListener();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SwitchYardType switchYardRoot = TransformsControlComposite.this.getSwitchYardRoot((EObject)composite);
                    if (TransformsControlComposite.this._tableViewer.getTable().isDisposed()) {
                        return;
                    }
                    if (switchYardRoot == null) {
                        TransformsControlComposite.this._tableViewer.setInput(null);
                    } else {
                        TransformsControlComposite.this._tableViewer.setInput(MergedModelUtil.getAdapter((EObject)switchYardRoot, SwitchYardMergedModelAdapter.class).getTransforms());
                    }
                    TransformsControlComposite.this.getContainer().layout();
                }
            });
        }
    }

    private void handleSelectListItem() {
        if (this._removeButton != null && !this._removeButton.isDisposed()) {
            URI _modelUri = URI.createPlatformResourceURI((String)SwitchyardSCAEditor.getActiveEditor().getModelFile().getFullPath().toString(), (boolean)true);
            if (this._transformer.eResource().getURI().equals(_modelUri)) {
                this._removeButton.setEnabled(this._transformer != null);
            } else {
                this._removeButton.setEnabled(false);
            }
        }
    }

    private SwitchYardType getSwitchYardRoot(EObject object) {
        if (object != null) {
            return MergedModelUtil.getSwitchYard(object);
        }
        return null;
    }

    private Object removeListItem(EObject object, EStructuralFeature feature, int index) {
        EList list = (EList)object.eGet(feature);
        return list.remove(index);
    }

    private TransformType addTransform() {
        NewTransformWizard wizard;
        SwitchYardType switchYardRoot;
        block6: {
            TransformDetails details;
            block5: {
                details = null;
                try {
                    switchYardRoot = MergedModelUtil.getSwitchYard((EObject)this._composite);
                    details = new TransformDetails(switchYardRoot);
                    if (!details.getDeclaredTransforms().containsAll(details.getRequiredTransforms())) break block5;
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.title_noNewTransformersRequired, (String)Messages.description_noNewTransformersRequired);
                    return null;
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.title_errorResolvingTransformers, (String)(String.valueOf(Messages.description_errorResolvingTransformers) + e.getMessage()));
                    return null;
                }
            }
            wizard = new NewTransformWizard();
            wizard.init(details);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) break block6;
            return null;
        }
        if (this._domain != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    Collection<TransformType> newTransforms = wizard.getCreatedTransforms();
                    if (newTransforms == null || newTransforms.isEmpty()) {
                        TransformsControlComposite.this.refresh();
                        return;
                    }
                    TransformsType transforms = switchYardRoot.getTransforms();
                    if (transforms == null) {
                        switchYardRoot.setTransforms(SwitchyardFactory.eINSTANCE.createTransformsType());
                        transforms = switchYardRoot.getTransforms();
                    }
                    EList transformsList = transforms.getTransform();
                    for (TransformType newTransform : newTransforms) {
                        transformsList.add(newTransform);
                    }
                    TransformsControlComposite.this.refresh();
                }
            });
        }
        return null;
    }

    private void removeTransforms(final IStructuredSelection ssel) {
        if (ssel != null && this._domain != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    SwitchYardType switchYardRoot = TransformsControlComposite.this.getSwitchYardRoot((EObject)TransformsControlComposite.this._composite);
                    TransformsType transforms = switchYardRoot.getTransforms();
                    for (TransformType transform : ssel) {
                        int index = transforms.getTransform().indexOf((Object)transform);
                        EStructuralFeature feature = transforms.eClass().getEStructuralFeature("transform");
                        TransformsControlComposite.this.removeListItem((EObject)transforms, feature, index);
                    }
                }
            });
            this.refresh();
        }
    }

    private void removeTransform(final TransformType selected) {
        if (selected != null && this._domain != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    SwitchYardType switchYardRoot = TransformsControlComposite.this.getSwitchYardRoot((EObject)TransformsControlComposite.this._composite);
                    TransformsType transforms = switchYardRoot.getTransforms();
                    int index = transforms.getTransform().indexOf((Object)selected);
                    EStructuralFeature feature = transforms.eClass().getEStructuralFeature("transform");
                    TransformsControlComposite.this.removeListItem((EObject)transforms, feature, index);
                }
            });
            this.refresh();
        }
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent arg0) {
        this.refresh();
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent arg0) throws RollbackException {
        return null;
    }

    private void addDomainListener() {
        if (this._domain == null) {
            this._domain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getEditor(this.getTargetObject()).getEditingDomain();
            this._domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    private void removeDomainListener() {
        if (this._domain != null) {
            this._domain.removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public void dispose() {
        this.removeDomainListener();
        super.dispose();
    }

    final class ColumnConst {
        public static final int COLUMN_TO = 1;
        public static final int COLUMN_FROM = 0;
        public static final int COLUMN_TYPE = 2;

        private ColumnConst() {
        }
    }

    class ColumnViewerSorter
    extends ViewerSorter {
        private static final int ASCENDING = 0;
        private static final int DESCENDING = 1;
        private int _column;
        private int _direction;

        ColumnViewerSorter() {
        }

        public void doSort(int column) {
            if (column == this._column) {
                this._direction = 1 - this._direction;
            } else {
                this._column = column;
                this._direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int rc = 0;
            TransformType p1 = (TransformType)e1;
            TransformType p2 = (TransformType)e2;
            switch (this._column) {
                case 1: {
                    rc = this.getComparator().compare(p1.getTo(), p2.getTo());
                    break;
                }
                case 0: {
                    rc = this.getComparator().compare(p1.getFrom(), p2.getFrom());
                    break;
                }
                case 2: {
                    String type1 = LabelAdapter.getLabel((EObject)p1);
                    String type2 = LabelAdapter.getLabel((EObject)p2);
                    rc = this.getComparator().compare(type1, type2);
                }
            }
            if (this._direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class TransformTableContentProvider
    implements IStructuredContentProvider {
        private TransformTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EList) {
                EList v = (EList)inputElement;
                return v.toArray();
            }
            if (inputElement instanceof List) {
                List v = (List)inputElement;
                return v.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TransformTableLabelProvider
    implements ITableLabelProvider {
        private TransformTableLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TransformType) {
                TransformType transform = (TransformType)element;
                if (columnIndex == 1) {
                    return TransformTypesUtil.getLabelForType(transform.getTo());
                }
                if (columnIndex == 0) {
                    return TransformTypesUtil.getLabelForType(transform.getFrom());
                }
                if (columnIndex == 2) {
                    return LabelAdapter.getLabel((EObject)transform);
                }
            }
            return null;
        }
    }
}

