/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.component;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.notification.INotificationService;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class ComponentMainComposite
extends AbstractModelComposite<Component> {
    private Text _nameText;
    private Object _businessObject;
    private boolean _inUpdate = false;
    private NameListener _nameListener = null;

    public ComponentMainComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        FormToolkit factory = this.getWidgetFactory();
        this._nameText = factory.createText((Composite)this, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this._nameText.setLayoutData((Object)data);
        this._nameText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ComponentMainComposite.this._businessObject != null && !ComponentMainComposite.this._inUpdate) {
                    ComponentMainComposite.this.updateObjectName(ComponentMainComposite.this._businessObject, ComponentMainComposite.this._nameText.getText().trim());
                }
            }
        });
        Label valueLabel = factory.createLabel((Composite)this, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this._nameText, -5);
        data.top = new FormAttachment((Control)this._nameText, 0, 0x1000000);
        valueLabel.setLayoutData((Object)data);
    }

    private void updateObjectName(final Object bo, final String value) {
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                Component component;
                if (bo instanceof Component && !(component = (Component)bo).getName().contentEquals(value.trim())) {
                    component.setName(value.trim());
                    if (component.eContainer() instanceof SwitchYardType) {
                        SwitchYardType switchyard = (SwitchYardType)component.eContainer();
                        switchyard.setName(value.trim());
                    }
                    SwitchyardSCAEditor editor = SwitchyardSCAEditor.getEditor((EObject)component);
                    INotificationService notificationService = editor.getDiagramTypeProvider().getNotificationService();
                    notificationService.updatePictogramElements(notificationService.calculateRelatedPictogramElements(new Object[]{component}));
                }
            }
        });
    }

    @Override
    public void refresh() {
        this._inUpdate = true;
        try {
            Component composite = (Component)this.getTargetObject();
            if (composite != null) {
                this._businessObject = composite;
                if (this._nameListener == null) {
                    this._nameListener = new NameListener();
                }
                composite.eAdapters().add((Object)this._nameListener);
                if (this._nameText != null && !this._nameText.isDisposed()) {
                    String name = composite.getName();
                    this._nameText.setText(name == null ? "" : name);
                }
            }
        }
        finally {
            this._inUpdate = false;
        }
    }

    private final class NameListener
    extends AdapterImpl {
        private NameListener() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature().equals(ScaPackage.eINSTANCE.getComponent_Name())) {
                ComponentMainComposite.this.refresh();
            }
            super.notifyChanged(msg);
        }
    }
}

