/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import java.util.Collection;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.ExtensionsType;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardPackage;
import org.switchyard.tools.models.switchyard1_0.switchyard.ThrottlingType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class ThrottlingPropertyComposite
extends AbstractModelComposite<Contract> {
    private boolean _updating = false;
    private Contract _service;
    private ThrottlingType _throttlingType;
    private Button _enableCheck;
    private Text _maximumRequestsText;
    private Text _timePeriodText;

    public ThrottlingPropertyComposite(ICompositeContainer container, Composite parent, int style) {
        super(Contract.class, container, parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        FormToolkit factory = this.getWidgetFactory();
        factory.createText((Composite)this, Messages.tooltip_enableThrottling, 72).setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._enableCheck = factory.createButton((Composite)this, Messages.label_enableThrottling, 32);
        this._enableCheck.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._enableCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ThrottlingPropertyComposite.this._updating) {
                    return;
                }
                ThrottlingPropertyComposite.this.throttlingEnabled(ThrottlingPropertyComposite.this._enableCheck.getSelection());
            }
        });
        factory.createLabel((Composite)this, Messages.label_maximumRequests);
        this._maximumRequestsText = factory.createText((Composite)this, "", 2048);
        this._maximumRequestsText.setLayoutData((Object)new GridData(4, 1, true, false));
        this._maximumRequestsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                final String newValue = ThrottlingPropertyComposite.this._maximumRequestsText.getText().length() == 0 ? null : ThrottlingPropertyComposite.this._maximumRequestsText.getText();
                if (!ThrottlingPropertyComposite.this._updating && (newValue == null && ThrottlingPropertyComposite.this._throttlingType.getMaxRequests() != null || newValue != null && !newValue.equals(ThrottlingPropertyComposite.this._throttlingType.getMaxRequests()))) {
                    ThrottlingPropertyComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            ThrottlingPropertyComposite.this._throttlingType.setMaxRequests((Object)newValue);
                        }
                    });
                }
            }
        });
        factory.createLabel((Composite)this, Messages.label_timePeriod);
        this._timePeriodText = factory.createText((Composite)this, "1000", 2048);
        this._timePeriodText.setLayoutData((Object)new GridData(4, 1, true, false));
        this._timePeriodText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                final String newValue = ThrottlingPropertyComposite.this._timePeriodText.getText().length() == 0 ? null : ThrottlingPropertyComposite.this._timePeriodText.getText();
                if (!ThrottlingPropertyComposite.this._updating && (newValue == null && ThrottlingPropertyComposite.this._throttlingType.getTimePeriod() != null || newValue != null && !newValue.equals(ThrottlingPropertyComposite.this._throttlingType.getTimePeriod()))) {
                    ThrottlingPropertyComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            if (newValue == null) {
                                ThrottlingPropertyComposite.this._throttlingType.unsetTimePeriod();
                            } else {
                                ThrottlingPropertyComposite.this._throttlingType.setTimePeriod((Object)newValue);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void refresh() {
        if (this._service == this.getTargetObject()) {
            return;
        }
        this._updating = true;
        try {
            this._service = (Contract)this.getTargetObject();
            this._throttlingType = null;
            if (this._service == null) {
                this._throttlingType = SwitchyardFactory.eINSTANCE.createThrottlingType();
                this._enableCheck.setSelection(false);
                this._timePeriodText.setText("");
                this._maximumRequestsText.setText("");
                this._enableCheck.setEnabled(false);
                this._timePeriodText.setEnabled(false);
                this._maximumRequestsText.setEnabled(false);
            } else {
                Collection throttlings;
                ExtensionsType extensions = this._service.getExtensions();
                if (extensions != null && (throttlings = (Collection)extensions.getAny().get((EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_Throttling(), true)) != null && throttlings.size() > 0) {
                    this._throttlingType = (ThrottlingType)throttlings.iterator().next();
                }
                if (this._throttlingType == null) {
                    this._enableCheck.setSelection(false);
                    this._enableCheck.setEnabled(true);
                    this._timePeriodText.setEnabled(false);
                    this._maximumRequestsText.setEnabled(false);
                    this._throttlingType = SwitchyardFactory.eINSTANCE.createThrottlingType();
                } else {
                    this._enableCheck.setSelection(true);
                    this._enableCheck.setEnabled(true);
                    this._timePeriodText.setEnabled(true);
                    this._maximumRequestsText.setEnabled(true);
                }
                this._timePeriodText.setText(this._throttlingType.getTimePeriod() == null ? "" : this._throttlingType.getTimePeriod().toString());
                this._maximumRequestsText.setText(this._throttlingType.getMaxRequests() == null ? "" : this._throttlingType.getMaxRequests().toString());
            }
        }
        finally {
            this._updating = false;
        }
    }

    private void throttlingEnabled(boolean selected) {
        if (selected) {
            this._timePeriodText.setEnabled(true);
            this._maximumRequestsText.setEnabled(true);
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    ExtensionsType extensions = ThrottlingPropertyComposite.this._service.getExtensions();
                    if (extensions == null) {
                        extensions = ScaFactory.eINSTANCE.createExtensionsType();
                        extensions.getAny().add((EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_Throttling(), (Object)ThrottlingPropertyComposite.this._throttlingType);
                        ThrottlingPropertyComposite.this._service.setExtensions(extensions);
                    } else {
                        extensions.getAny().add((EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_Throttling(), (Object)ThrottlingPropertyComposite.this._throttlingType);
                    }
                }
            });
        } else {
            this._timePeriodText.setEnabled(false);
            this._maximumRequestsText.setEnabled(false);
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    ExtensionsType extensions = ThrottlingPropertyComposite.this._service.getExtensions();
                    if (extensions == null) {
                        return;
                    }
                    extensions.getAny().unset((EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_Throttling());
                    if (extensions.getAny().isEmpty()) {
                        ThrottlingPropertyComposite.this._service.setExtensions(null);
                    }
                }
            });
        }
    }
}

