/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class InteractionPolicyComposite
extends AbstractModelComposite<Contract> {
    private boolean _inUpdate = false;
    private Combo _interactionCombo;
    private ArrayList<String> _supportedInteractionPolicies = new ArrayList();

    public InteractionPolicyComposite(ICompositeContainer container, Composite parent, int style) {
        super(Contract.class, container, parent, style);
        this._supportedInteractionPolicies.add("propagatesTransaction");
        this._supportedInteractionPolicies.add("suspendsTransaction");
        this.setLayout((Layout)new GridLayout(2, false));
        FormToolkit factory = this.getWidgetFactory();
        factory.createLabel((Composite)this, Messages.label_transactionPolicy);
        this._interactionCombo = new Combo((Composite)this, 2060);
        factory.adapt((Control)this._interactionCombo, true, false);
        this._interactionCombo.add("None");
        for (String label : this._supportedInteractionPolicies) {
            this._interactionCombo.add(label);
        }
        this._interactionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._interactionCombo.addSelectionListener((SelectionListener)new ComboSelectionListener());
    }

    private void updatePolicy(final Contract contract, Control control, final String value) {
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                ArrayList<QName> requires = contract.getRequires();
                ArrayList<String> existing = new ArrayList<String>();
                if (requires != null) {
                    for (QName requiresItem : requires) {
                        String localPart = requiresItem.getLocalPart();
                        if (InteractionPolicyComposite.this._supportedInteractionPolicies.contains(localPart)) continue;
                        existing.add(localPart);
                    }
                }
                contract.setRequires(null);
                requires = new ArrayList<QName>();
                for (String existingItem : existing) {
                    QName newQName = new QName(existingItem);
                    requires.add(newQName);
                }
                if (!value.trim().contentEquals("None")) {
                    QName newQName = new QName(value);
                    requires.add(newQName);
                }
                if (!requires.isEmpty()) {
                    contract.setRequires(requires);
                }
            }
        });
    }

    @Override
    public void refresh() {
        this._inUpdate = true;
        try {
            List requires;
            String interactionPolicy = null;
            Contract contract = (Contract)this.getTargetObject();
            if (contract != null && (requires = contract.getRequires()) != null) {
                for (QName requiresItem : requires) {
                    String localPart = requiresItem.getLocalPart();
                    if (!this._supportedInteractionPolicies.contains(localPart)) continue;
                    interactionPolicy = localPart;
                }
            }
            if (interactionPolicy != null && !this._interactionCombo.isDisposed()) {
                this._interactionCombo.setText(interactionPolicy);
            } else {
                this._interactionCombo.setText("None");
            }
        }
        finally {
            this._inUpdate = false;
        }
    }

    private class ComboSelectionListener
    implements SelectionListener {
        private ComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Contract contract = (Contract)InteractionPolicyComposite.this.getTargetObject();
            if (contract != null && !InteractionPolicyComposite.this._inUpdate) {
                InteractionPolicyComposite.this.updatePolicy(contract, (Control)InteractionPolicyComposite.this._interactionCombo, InteractionPolicyComposite.this._interactionCombo.getText().trim());
            }
        }
    }
}

