/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public abstract class AbstractModelComposite<T extends EObject>
extends Composite {
    private Class<T> _type;
    private ICompositeContainer _container;
    private String _description;

    public AbstractModelComposite(Class<T> type, ICompositeContainer container, Composite parent, int style) {
        super(parent, style);
        this._type = type;
        this._container = container;
    }

    public String getDescription() {
        return this._description;
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public abstract void refresh();

    protected void setDescription(String description) {
        this._description = description;
    }

    protected FormToolkit getWidgetFactory() {
        return this._container.getToolkit();
    }

    public ICompositeContainer getContainer() {
        return this._container;
    }

    protected T getTargetObject() {
        if (this._container == null) {
            return null;
        }
        EObject target = this._container.getSelectedBusinessObject();
        return (T)(target == null ? null : (this._type.isInstance(target) ? (EObject)this._type.cast(target) : (EObject)this._type.cast(Platform.getAdapterManager().getAdapter((Object)target, this._type))));
    }

    protected void wrapOperation(final Runnable runner) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain(this.getTargetObject());
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        runner.run();
                    }
                    catch (Exception e) {
                        Activator.logError(e);
                    }
                }
            });
        } else {
            try {
                runner.run();
            }
            catch (Exception e) {
                Activator.logError(e);
            }
        }
    }

    protected void adaptChildren(Control control) {
        if (control != null) {
            if (control instanceof Composite) {
                Control[] kids;
                Composite composite = (Composite)control;
                Control[] controlArray = kids = composite.getChildren();
                int n = kids.length;
                int n2 = 0;
                while (n2 < n) {
                    Control kid = controlArray[n2];
                    this.adaptChildren(kid);
                    ++n2;
                }
                this.getWidgetFactory().adapt(composite);
            } else {
                this.getWidgetFactory().adapt(control, false, false);
            }
        }
    }
}

