/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.impl.security;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.switchyard.tools.models.switchyard1_0.switchyard.DomainType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SecuritiesType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SecurityType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.security.NewSecurityTypeWizard;

public class SecurityInstanceTable
extends Composite {
    private TreeViewer _propertyTreeTable;
    private SwitchYardType _syRoot = null;
    private TransactionalEditingDomain _editDomain = null;
    public static final String NAME_COLUMN = "name";
    public static final String CALLBACK_HANDLER_COLUMN = "callbackHandler";
    public static final String ROLES_ALLOWED_COLUMN = "rolesAllowed";
    public static final String RUN_AS_COLUMN = "runAs";
    public static final String SECURITY_DOMAIN_COLUMN = "securityDomain";
    private static final String[] TREE_COLUMNS = new String[]{"name", "callbackHandler", "rolesAllowed", "runAs", "securityDomain"};
    private Button _mAddButton;
    private Button _mEditButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;

    public SecurityInstanceTable(Composite parent, int style) {
        this(parent, style, false);
    }

    private TreeColumn createColumn(Tree tree, int style, String text, int width) {
        TreeColumn newColumn = new TreeColumn(tree, style);
        newColumn.setText(text);
        newColumn.setWidth(width);
        return newColumn;
    }

    public void setSwitchYardRoot(SwitchYardType root) {
        this._syRoot = root;
    }

    public void setEditingDomain(TransactionalEditingDomain domain) {
        this._editDomain = domain;
    }

    public SecurityInstanceTable(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this._propertyTreeTable = new TreeViewer((Composite)this, 0x10A42 | additionalStyles);
        this._propertyTreeTable.setAutoExpandLevel(-1);
        GridData gd11 = new GridData(4, 4, true, true, 1, 5);
        gd11.heightHint = 100;
        this._propertyTreeTable.getTree().setLayoutData((Object)gd11);
        this._propertyTreeTable.getTree().setHeaderVisible(true);
        TreeColumn nameColumn = this.createColumn(this._propertyTreeTable.getTree(), 16384, Messages.label_name, 150);
        nameColumn.setData((Object)NAME_COLUMN);
        TreeColumn callbackHandlerColumn = this.createColumn(this._propertyTreeTable.getTree(), 16384, Messages.label_callbackHandler, 150);
        callbackHandlerColumn.setData((Object)CALLBACK_HANDLER_COLUMN);
        TreeColumn rolesAllowedColumn = this.createColumn(this._propertyTreeTable.getTree(), 16384, Messages.label_rolesAllowed, 150);
        rolesAllowedColumn.setData((Object)ROLES_ALLOWED_COLUMN);
        TreeColumn runAsColumn = this.createColumn(this._propertyTreeTable.getTree(), 16384, Messages.label_runAs, 150);
        runAsColumn.setData((Object)RUN_AS_COLUMN);
        TreeColumn securityDomainColumn = this.createColumn(this._propertyTreeTable.getTree(), 16384, Messages.label_securityDomain, 150);
        securityDomainColumn.setData((Object)SECURITY_DOMAIN_COLUMN);
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new SecurityTypeTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new SecurityTypeTreeContentProvider());
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(256));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityInstanceTable.this.addSecurityTypeToList();
                SecurityInstanceTable.this._propertyTreeTable.refresh();
                SecurityInstanceTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecurityInstanceTable.this.updateSecurityTypeButtons();
            }
        });
        this._mEditButton = new Button((Composite)this, 0);
        this._mEditButton.setLayoutData((Object)new GridData(256));
        this._mEditButton.setText(Messages.button_edit);
        this._mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel;
                if (SecurityInstanceTable.this._propertyTreeTable != null && !SecurityInstanceTable.this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)SecurityInstanceTable.this._propertyTreeTable.getSelection()).size() == 1) {
                    SecurityInstanceTable.this.editSecurityType();
                    SecurityInstanceTable.this._propertyTreeTable.refresh();
                    SecurityInstanceTable.this.fireChangedEvent(e.getSource());
                }
            }
        });
        this._mEditButton.setEnabled(false);
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(256));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SecurityInstanceTable.this._propertyTreeTable != null && !SecurityInstanceTable.this._propertyTreeTable.getSelection().isEmpty()) {
                    IStructuredSelection ssel = (IStructuredSelection)SecurityInstanceTable.this._propertyTreeTable.getSelection();
                    if (ssel.size() == 1) {
                        SecurityInstanceTable.this.removeFromList();
                    } else if (ssel.size() > 1) {
                        SecurityInstanceTable.this.removeMultipleFromList();
                    }
                    SecurityInstanceTable.this._propertyTreeTable.refresh();
                    SecurityInstanceTable.this.fireChangedEvent(e.getSource());
                }
            }
        });
        this.updateSecurityTypeButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected void addSecurityTypeToList() {
        WizardDialog dialog;
        int rtn_code;
        NewSecurityTypeWizard wizard = new NewSecurityTypeWizard();
        if (this._syRoot.getDomain() != null && this._syRoot.getDomain().getSecurities() != null) {
            wizard.setSecuritiesType(this._syRoot.getDomain().getSecurities());
        }
        if ((rtn_code = (dialog = new WizardDialog(this.getShell(), (IWizard)wizard)).open()) == 0 && this._syRoot != null) {
            final SwitchYardType finalRoot = this._syRoot;
            final SecurityType newSecurity = wizard.getSecurityType();
            this._editDomain.getCommandStack().execute((Command)new RecordingCommand(this._editDomain){

                protected void doExecute() {
                    SecuritiesType security;
                    DomainType domain = finalRoot.getDomain();
                    if (domain == null) {
                        domain = SwitchyardFactory.eINSTANCE.createDomainType();
                        finalRoot.setDomain(domain);
                    }
                    if ((security = domain.getSecurities()) == null) {
                        security = SwitchyardFactory.eINSTANCE.createSecuritiesType();
                        domain.setSecurities(security);
                    }
                    security.getSecurity().add((Object)newSecurity);
                }
            });
        }
    }

    protected void editSecurityType() {
        StructuredSelection ssel = (StructuredSelection)this._propertyTreeTable.getSelection();
        if (ssel.getFirstElement() != null && ssel.getFirstElement() instanceof SecurityType) {
            final SecurityType security = (SecurityType)ssel.getFirstElement();
            NewSecurityTypeWizard wizard = new NewSecurityTypeWizard(true);
            wizard.setSecurityType(security);
            wizard.setSecuritiesType(this._syRoot.getDomain().getSecurities());
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            int rtn_code = dialog.open();
            if (rtn_code == 0 && this._syRoot != null) {
                final SwitchYardType finalRoot = this._syRoot;
                final SecurityType newSecurity = wizard.getSecurityType();
                this._editDomain.getCommandStack().execute((Command)new RecordingCommand(this._editDomain){

                    protected void doExecute() {
                        DomainType domain = finalRoot.getDomain();
                        if (domain == null) {
                            domain = SwitchyardFactory.eINSTANCE.createDomainType();
                            finalRoot.setDomain(domain);
                        }
                        SecuritiesType securities = domain.getSecurities();
                        securities.getSecurity().remove((Object)security);
                        securities.getSecurity().add((Object)newSecurity);
                    }
                });
            }
        }
    }

    protected void removeFromList() {
        StructuredSelection ssel = (StructuredSelection)this._propertyTreeTable.getSelection();
        if (ssel.getFirstElement() != null && ssel.getFirstElement() instanceof SecurityType) {
            final SecurityType security = (SecurityType)ssel.getFirstElement();
            if (this._syRoot != null) {
                final SwitchYardType finalRoot = this._syRoot;
                this._editDomain.getCommandStack().execute((Command)new RecordingCommand(this._editDomain){

                    protected void doExecute() {
                        DomainType domain = finalRoot.getDomain();
                        if (domain == null) {
                            domain = SwitchyardFactory.eINSTANCE.createDomainType();
                            finalRoot.setDomain(domain);
                        }
                        SecuritiesType securities = domain.getSecurities();
                        securities.getSecurity().remove((Object)security);
                    }
                });
            }
        }
    }

    protected void removeMultipleFromList() {
        final StructuredSelection ssel = (StructuredSelection)this._propertyTreeTable.getSelection();
        if (ssel.getFirstElement() != null && ssel.getFirstElement() instanceof SecurityType && this._syRoot != null) {
            final SwitchYardType finalRoot = this._syRoot;
            this._editDomain.getCommandStack().execute((Command)new RecordingCommand(this._editDomain){

                protected void doExecute() {
                    for (SecurityType security : ssel) {
                        DomainType domain = finalRoot.getDomain();
                        if (domain == null) {
                            domain = SwitchyardFactory.eINSTANCE.createDomainType();
                            finalRoot.setDomain(domain);
                        }
                        SecuritiesType securities = domain.getSecurities();
                        securities.getSecurity().remove((Object)security);
                    }
                }
            });
        }
    }

    public EList<SecurityType> getSelection() {
        if (this._propertyTreeTable != null && this._propertyTreeTable.getInput() != null) {
            return (EList)this._propertyTreeTable.getInput();
        }
        return null;
    }

    public SecurityType getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof SecurityType) {
            return (SecurityType)ssel.getFirstElement();
        }
        return null;
    }

    public void updateSecurityTypeButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
            this._mEditButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            IStructuredSelection ssel = (IStructuredSelection)this._propertyTreeTable.getSelection();
            if (!ssel.isEmpty() && ssel.size() == 1) {
                this._mEditButton.setEnabled(true);
            }
            if (!ssel.isEmpty()) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public void setSelection(EList<SecurityType> properties) {
        this._propertyTreeTable.setInput(properties);
        this.updateSecurityTypeButtons();
    }

    public void setSecurity(SecuritiesType securities) {
        if (securities != null) {
            this._propertyTreeTable.setInput((Object)securities.getSecurity());
        }
        this.updateSecurityTypeButtons();
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    protected void setFeatureValue(EObject eObject, String featureId, Object value) {
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && eStructuralFeature.getName().equalsIgnoreCase(featureId)) {
                eObject.eSet(eStructuralFeature, value);
                break;
            }
            ++i;
        }
    }

    protected TreeViewer getTreeViewer() {
        return this._propertyTreeTable;
    }

    private class SecurityTypeTreeContentProvider
    implements ITreeContentProvider {
        private EList<SecurityType> _properties;

        private SecurityTypeTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof EList) {
                this._properties = (EList)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EList) {
                return this._properties.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof SecurityType[]) {
                return new Object[]{this._properties.toArray()};
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof SecurityType) {
                return ((SecurityType)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EList) {
                return ((EList)element).size() > 0;
            }
            return false;
        }
    }

    private class SecurityTypeTreeLabelProvider
    implements ITableLabelProvider {
        private SecurityTypeTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof SecurityType && property.equalsIgnoreCase(SecurityInstanceTable.NAME_COLUMN)) {
                return true;
            }
            if (element instanceof SecurityType && property.equalsIgnoreCase(SecurityInstanceTable.CALLBACK_HANDLER_COLUMN)) {
                return true;
            }
            if (element instanceof SecurityType && property.equalsIgnoreCase(SecurityInstanceTable.ROLES_ALLOWED_COLUMN)) {
                return true;
            }
            if (element instanceof SecurityType && property.equalsIgnoreCase(SecurityInstanceTable.RUN_AS_COLUMN)) {
                return true;
            }
            return element instanceof SecurityType && property.equalsIgnoreCase(SecurityInstanceTable.SECURITY_DOMAIN_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof SecurityType && columnIndex == 0) {
                SecurityType tp = (SecurityType)element;
                if (tp.getName() == null) {
                    return "default";
                }
                return ((SecurityType)element).getName();
            }
            if (element instanceof SecurityType && columnIndex == 1) {
                SecurityType tp = (SecurityType)element;
                return tp.getCallbackHandler();
            }
            if (element instanceof SecurityType && columnIndex == 2) {
                SecurityType tp = (SecurityType)element;
                return tp.getRolesAllowed();
            }
            if (element instanceof SecurityType && columnIndex == 3) {
                SecurityType tp = (SecurityType)element;
                return tp.getRunAs();
            }
            if (element instanceof SecurityType && columnIndex == 4) {
                SecurityType tp = (SecurityType)element;
                return tp.getSecurityDomain();
            }
            return null;
        }
    }
}

