/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.impl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.switchyard.tools.models.switchyard1_0.switchyard.DomainType;
import org.switchyard.tools.models.switchyard1_0.switchyard.PropertiesType;
import org.switchyard.tools.models.switchyard1_0.switchyard.PropertyType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.DomainPropertyInputDialog;
import org.switchyard.tools.ui.editor.diagram.shared.DomainPropertyTable;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.impl.security.SecurityInstanceTable;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.model.merge.SwitchYardMergedModelAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class MultiPageEditor
extends MultiPageEditorPart
implements IGotoMarker,
ResourceSetListener {
    private static final String MESSAGE_TRACE_KEY = "org.switchyard.handlers.messageTrace.enabled";
    private SwitchyardSCAEditor _diagramEditor;
    private StructuredTextEditor _sourceViewer;
    private Composite _domainPage;
    private CTabFolder _tabFolder;
    private int _defaultTabHeight;
    private Button _messageTraceCheckbox;
    private TransactionalEditingDomain _editDomain = null;
    private SwitchYardType _syRoot = null;
    private DomainPropertyTable _domainProperties = null;
    private SecurityInstanceTable _securityInstanceTable;
    private FormToolkit _toolkit;

    public void dispose() {
        if (this._toolkit != null) {
            this._toolkit.dispose();
            this._toolkit = null;
        }
        this.removeDomainListener();
        super.dispose();
    }

    private void addDomainListener() {
        if (this._editDomain == null) {
            this._editDomain = (TransactionalEditingDomainImpl)this.getDiagramEditor().getEditingDomain();
            this._editDomain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    private void removeDomainListener() {
        if (this._editDomain != null) {
            this._editDomain.removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public void gotoMarker(IMarker marker) {
        if (this.getActivePage() < 0) {
            this.setActivePage(0);
        }
        IDE.gotoMarker((IEditorPart)this.getEditor(this.getActivePage()), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(Messages.error_notIFileEditorInput);
        }
        super.init(site, editorInput);
        if (this.getEditorInput() != null) {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            this.setPartName(file.getName());
        }
    }

    private SwitchYardType getSwitchYardRoot() {
        SwitchYardType switchYardRoot = MergedModelUtil.getSwitchYard((Resource)this.getDiagramEditor().getEditingDomain().getResourceSet().getResources().get(0));
        SwitchYardMergedModelAdapter mergedAdapter = MergedModelUtil.getAdapter((EObject)switchYardRoot, SwitchYardMergedModelAdapter.class);
        return mergedAdapter.getSwitchYard();
    }

    public SwitchyardSCAEditor getDiagramEditor() {
        return this._diagramEditor;
    }

    public StructuredTextEditor getSourceViewer() {
        return this._sourceViewer;
    }

    private void addMessageTraceHandler() {
        if (this._syRoot != null) {
            PropertiesType properties;
            DomainType domain = this._syRoot.getDomain();
            if (domain == null) {
                domain = SwitchyardFactory.eINSTANCE.createDomainType();
                this._syRoot.setDomain(domain);
            }
            if ((properties = domain.getProperties()) == null) {
                properties = SwitchyardFactory.eINSTANCE.createPropertiesType();
                domain.setProperties(properties);
            }
            for (PropertyType property : properties.getProperty()) {
                if (!MESSAGE_TRACE_KEY.equals(property.getName())) continue;
                property.setValue(Boolean.toString(true));
                return;
            }
            PropertyType messageTraceProperty = SwitchyardFactory.eINSTANCE.createPropertyType();
            messageTraceProperty.setName(MESSAGE_TRACE_KEY);
            messageTraceProperty.setValue(Boolean.toString(true));
            properties.getProperty().add((Object)messageTraceProperty);
        }
    }

    private EList<PropertyType> getDomainPropertyList() {
        PropertiesType properties;
        DomainType domain;
        if (this._syRoot != null && (domain = this._syRoot.getDomain()) != null && (properties = domain.getProperties()) != null) {
            EList propertyList = properties.getProperty();
            return propertyList;
        }
        return null;
    }

    private void removeDomainProperty(final PropertyType property) {
        PropertiesType properties;
        DomainType domain;
        if (this._syRoot != null && (domain = this._syRoot.getDomain()) != null && (properties = domain.getProperties()) != null) {
            this._editDomain.getCommandStack().execute((Command)new RecordingCommand(this._editDomain){

                protected void doExecute() {
                    properties.getProperty().remove((Object)property);
                }
            });
        }
    }

    private void addDomainProperty(final String name, final String value) {
        if (this._syRoot != null) {
            final SwitchYardType finalRoot = this._syRoot;
            this._editDomain.getCommandStack().execute((Command)new RecordingCommand(this._editDomain){

                protected void doExecute() {
                    PropertiesType properties;
                    DomainType domain = finalRoot.getDomain();
                    if (domain == null) {
                        domain = SwitchyardFactory.eINSTANCE.createDomainType();
                        MultiPageEditor.this._syRoot.setDomain(domain);
                    }
                    if ((properties = domain.getProperties()) == null) {
                        properties = SwitchyardFactory.eINSTANCE.createPropertiesType();
                        domain.setProperties(properties);
                    }
                    EList propertyList = properties.getProperty();
                    PropertyType newProperty = SwitchyardFactory.eINSTANCE.createPropertyType();
                    newProperty.setName(name);
                    newProperty.setValue(value);
                    propertyList.add((Object)newProperty);
                }
            });
        }
    }

    private void removeMessageTraceHandler() {
        PropertiesType properties;
        DomainType domain;
        if (this._syRoot != null && (domain = this._syRoot.getDomain()) != null && (properties = domain.getProperties()) != null) {
            for (PropertyType property : properties.getProperty()) {
                if (!MESSAGE_TRACE_KEY.equals(property.getName())) continue;
                property.setValue(Boolean.toString(false));
                return;
            }
        }
    }

    private void updateMessageTraceHandler(boolean value) {
        if (this._syRoot != null) {
            boolean handlerExists = this.testForMessageTraceHandler();
            if (handlerExists && !value) {
                this._editDomain.getCommandStack().execute((Command)new RecordingCommand(this._editDomain){

                    protected void doExecute() {
                        MultiPageEditor.this.removeMessageTraceHandler();
                    }
                });
            } else if (!handlerExists && value) {
                this._editDomain.getCommandStack().execute((Command)new RecordingCommand(this._editDomain){

                    protected void doExecute() {
                        MultiPageEditor.this.addMessageTraceHandler();
                    }
                });
            }
        }
    }

    private boolean testForMessageTraceHandler() {
        PropertiesType properties;
        DomainType domain;
        if (this._syRoot != null && (domain = this._syRoot.getDomain()) != null && (properties = domain.getProperties()) != null) {
            for (PropertyType property : properties.getProperty()) {
                if (!MESSAGE_TRACE_KEY.equals(property.getName())) continue;
                return Boolean.valueOf(property.getValue());
            }
        }
        return false;
    }

    private void createDomainSettingsSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(this._domainPage, 256);
        section.setText("Domain Settings");
        section.setLayout((Layout)new GridLayout(1, false));
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        this._messageTraceCheckbox = toolkit.createButton(client, "Enable Message Trace", 16416);
        this._messageTraceCheckbox.setLayoutData((Object)new GridData(4, 1, true, false));
        this._messageTraceCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (MultiPageEditor.this._syRoot != null) {
                    MultiPageEditor.this.updateMessageTraceHandler(MultiPageEditor.this._messageTraceCheckbox.getSelection());
                }
            }
        });
        this._messageTraceCheckbox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    MultiPageEditor.this.updateMessageTraceHandler(MultiPageEditor.this._messageTraceCheckbox.getSelection());
                }
            }
        });
        Section section2 = toolkit.createSection(this._domainPage, 256);
        section2.setText("Domain Properties");
        section2.setLayout((Layout)new GridLayout(1, false));
        section2.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite client2 = toolkit.createComposite((Composite)section2, 64);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        layout2.marginWidth = 2;
        layout2.marginHeight = 2;
        client2.setLayout((Layout)layout2);
        this._domainProperties = new DomainPropertyTable(client2, 2){

            @Override
            protected void removeFromList() {
                PropertyType toRemove;
                final IStructuredSelection ssel = MultiPageEditor.this._domainProperties.getStructuredSelection();
                if (ssel != null && !ssel.isEmpty() && ssel.size() > 1) {
                    if (ssel != null && MultiPageEditor.this._editDomain != null) {
                        MultiPageEditor.this._editDomain.getCommandStack().execute((Command)new RecordingCommand(MultiPageEditor.this._editDomain){

                            protected void doExecute() {
                                for (PropertyType toRemove : ssel) {
                                    MultiPageEditor.this.removeDomainProperty(toRemove);
                                }
                            }
                        });
                    }
                } else if (ssel != null && ssel.size() == 1 && (toRemove = MultiPageEditor.this._domainProperties.getTableSelection()) != null) {
                    MultiPageEditor.this.removeDomainProperty(toRemove);
                }
            }

            @Override
            protected void addPropertyTypeToList() {
                DomainPropertyInputDialog dialog = new DomainPropertyInputDialog(Display.getCurrent().getActiveShell());
                int rtn_value = dialog.open();
                if (rtn_value == 0) {
                    String name = dialog.getPropertyName();
                    String value = dialog.getPropertyValue();
                    MultiPageEditor.this.addDomainProperty(name, value);
                }
            }
        };
        this._domainProperties.setLayoutData(new GridData(4, 1, true, false, 2, 5));
        section2.setClient((Control)client2);
        section.setClient((Control)client);
    }

    private void createDomainSecuritySettingsSection(FormToolkit toolkit, Composite parent) {
        Section section3 = toolkit.createSection(this._domainPage, 256);
        section3.setText("Security Configurations");
        section3.setLayout((Layout)new GridLayout(1, false));
        section3.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite client3 = toolkit.createComposite((Composite)section3, 64);
        GridLayout layout3 = new GridLayout(1, false);
        client3.setLayout((Layout)layout3);
        this._securityInstanceTable = new SecurityInstanceTable(client3, 0);
        this._securityInstanceTable.setLayoutData(new GridData(4, 1, true, false, 1, 5));
        this._securityInstanceTable.setSwitchYardRoot(this._syRoot);
        this._securityInstanceTable.setEditingDomain(this._editDomain);
        section3.setClient((Control)client3);
    }

    private void createDomainPage() {
        if (this._domainPage == null) {
            if (this._toolkit == null) {
                this._toolkit = new FormToolkit(this.getContainer().getDisplay());
            }
            ScrolledComposite sc1 = new ScrolledComposite(this.getContainer(), 768);
            sc1.setAlwaysShowScrollBars(false);
            sc1.setExpandHorizontal(true);
            sc1.setExpandVertical(true);
            sc1.setLayoutData((Object)new GridData(1808));
            this._domainPage = this._toolkit.createComposite((Composite)sc1);
            this._domainPage.setLayout((Layout)new GridLayout(1, false));
            this.createDomainSettingsSection(this._toolkit, this._domainPage);
            this.createDomainSecuritySettingsSection(this._toolkit, this._domainPage);
            sc1.setContent((Control)this._domainPage);
            sc1.setMinSize(this._domainPage.computeSize(-1, -1));
            int index = this.addPage((Control)sc1);
            this.setPageText(index, Messages.title_domain);
            this.refresh();
        }
    }

    protected void createDesignEditor() {
        if (this._diagramEditor == null) {
            this._diagramEditor = new DesignEditor();
            try {
                int pageIndex = this._tabFolder.getItemCount();
                if (this._sourceViewer != null) {
                    --pageIndex;
                }
                this.addPage(pageIndex, (IEditorPart)this._diagramEditor, this.getEditorInput());
                this._defaultTabHeight = this._tabFolder.getTabHeight();
                this.setPageText(pageIndex, Messages.title_design);
                this._defaultTabHeight = this._tabFolder.getTabHeight();
                this.updateTabs();
                this.addDomainListener();
                this._syRoot = this.getSwitchYardRoot();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void createSourceViewer() {
        block3: {
            if (this._sourceViewer == null) {
                this._sourceViewer = new SourceViewer();
                try {
                    int pageIndex = this._tabFolder.getItemCount();
                    FileEditorInput input = new FileEditorInput(this._diagramEditor.getModelFile());
                    this.addPage(pageIndex, (IEditorPart)this._sourceViewer, (IEditorInput)input);
                    this._tabFolder.getItem(pageIndex).setShowClose(true);
                    this.setPageText(pageIndex, Messages.title_source);
                    this.updateTabs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this._sourceViewer == null) break block3;
                    this._sourceViewer.dispose();
                }
            }
        }
    }

    public void removePage(int pageIndex) {
        Object page = this._tabFolder.getItem(pageIndex).getData();
        if (page instanceof EditorPart) {
            ((EditorPart)page).dispose();
        }
        super.removePage(pageIndex);
        this.updateTabs();
    }

    public void removeSourceViewer() {
        int pageIndex;
        if (this._sourceViewer != null && (pageIndex = this._tabFolder.getItemCount() - 1) > 0) {
            this.removePage(pageIndex);
        }
    }

    private void updateTabs() {
        if (this._tabFolder.getItemCount() == 1) {
            this._tabFolder.setTabHeight(0);
        } else {
            this._tabFolder.setTabHeight(this._defaultTabHeight);
        }
        this._tabFolder.layout();
    }

    public void doSave(IProgressMonitor monitor) {
        this._diagramEditor.doSave(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new MultiPageEditorSite(this, editor){

            protected void handleSelectionChanged(SelectionChangedEvent event) {
                ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
                if (parentProvider instanceof MultiPageSelectionProvider) {
                    SelectionChangedEvent newEvent = this.getNewEvent(parentProvider, event);
                    MultiPageSelectionProvider prov = (MultiPageSelectionProvider)parentProvider;
                    prov.fireSelectionChanged(newEvent);
                }
            }

            protected void handlePostSelectionChanged(SelectionChangedEvent event) {
                ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
                if (parentProvider instanceof MultiPageSelectionProvider) {
                    SelectionChangedEvent newEvent = this.getNewEvent(parentProvider, event);
                    MultiPageSelectionProvider prov = (MultiPageSelectionProvider)parentProvider;
                    prov.firePostSelectionChanged(newEvent);
                }
            }

            protected SelectionChangedEvent getNewEvent(ISelectionProvider parentProvider, SelectionChangedEvent event) {
                IStructuredSelection ss;
                Object o;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (o = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof Node) {
                    selection = this.getNewSelection((Node)o);
                }
                if (selection != null) {
                    return new SelectionChangedEvent(parentProvider, selection);
                }
                return event;
            }

            protected StructuredSelection getNewSelection(Node node) {
                short type = node.getNodeType();
                if (type == 1) {
                    return this.getNewSelection(node.getParentNode());
                }
                if (type == 2) {
                    Attr attr = (Attr)node;
                    return this.getNewSelection(attr.getOwnerElement());
                }
                if (type == 3) {
                    return this.getNewSelection(node.getParentNode());
                }
                return null;
            }
        };
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    protected void createPages() {
        this._tabFolder = (CTabFolder)this.getContainer();
        this._tabFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void close(CTabFolderEvent event) {
                if (event.item.getData() == MultiPageEditor.this._sourceViewer) {
                    MultiPageEditor.this.removeSourceViewer();
                }
            }

            public void minimize(CTabFolderEvent event) {
            }

            public void maximize(CTabFolderEvent event) {
            }

            public void restore(CTabFolderEvent event) {
            }

            public void showList(CTabFolderEvent event) {
            }
        });
        this.createDesignEditor();
        this.createDomainPage();
        this.createSourceViewer();
    }

    private void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DomainType domain;
                if (!MultiPageEditor.this._messageTraceCheckbox.isDisposed()) {
                    MultiPageEditor.this._messageTraceCheckbox.setSelection(MultiPageEditor.this.testForMessageTraceHandler());
                }
                if (!MultiPageEditor.this._domainProperties.isDisposed()) {
                    MultiPageEditor.this._domainProperties.setSelection((EList<PropertyType>)MultiPageEditor.this.getDomainPropertyList());
                }
                if (MultiPageEditor.this._syRoot != null && (domain = MultiPageEditor.this._syRoot.getDomain()) != null) {
                    if (!MultiPageEditor.this._domainProperties.isDisposed()) {
                        MultiPageEditor.this._domainProperties.setTargetObject((EObject)domain);
                    }
                    if (!MultiPageEditor.this._securityInstanceTable.isDisposed()) {
                        MultiPageEditor.this._securityInstanceTable.setSecurity(domain.getSecurities());
                    }
                }
            }
        });
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        this.refresh();
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public class DesignEditor
    extends SwitchyardSCAEditor {
        @Override
        protected void createActions() {
            super.createActions();
            ActionRegistry registry = this.getActionRegistry();
            WorkbenchPartAction action = new WorkbenchPartAction((IWorkbenchPart)MultiPageEditor.this._diagramEditor){

                protected void init() {
                    super.init();
                    this.setId("show.or.hide.source.view");
                }

                public String getText() {
                    return MultiPageEditor.this._sourceViewer == null ? Messages.label_showSourceView : Messages.label_hideSourceView;
                }

                protected boolean calculateEnabled() {
                    return true;
                }

                public void run() {
                    if (MultiPageEditor.this._sourceViewer == null) {
                        MultiPageEditor.this.createSourceViewer();
                        MultiPageEditor.this.setActivePage(MultiPageEditor.this._tabFolder.getItemCount() - 1);
                    } else {
                        MultiPageEditor.this.removeSourceViewer();
                    }
                }
            };
            registry.registerAction((IAction)action);
        }

        public void close() {
            MultiPageEditor.this.getSite().getPage().closeEditor((IEditorPart)MultiPageEditor.this, false);
        }

        public void refreshTitle() {
            Path resourcePath = new Path(this.getDiagramEditorInput().getUri().toPlatformString(true));
            MultiPageEditor.this.setPartName(resourcePath.lastSegment());
        }

        @Override
        protected void resourceMoved(IFile modelFile) {
            MultiPageEditor.this.setInput((IEditorInput)new FileEditorInput(modelFile));
        }
    }

    public class SourceViewer
    extends StructuredTextEditor {
        private ActionRegistry _actionRegistry = null;

        public Object getAdapter(Class required) {
            if (required == ActionRegistry.class) {
                return this.getActionRegistry();
            }
            if (required == SwitchyardSCAEditor.class) {
                return MultiPageEditor.this._diagramEditor;
            }
            return super.getAdapter(required);
        }

        public boolean isEditable() {
            return false;
        }

        public void dispose() {
            super.dispose();
            MultiPageEditor.this._sourceViewer = null;
        }

        protected ActionRegistry getActionRegistry() {
            if (this._actionRegistry == null) {
                this._actionRegistry = new ActionRegistry();
            }
            return this._actionRegistry;
        }
    }
}

