/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class TabFolderLayout
extends Layout {
    private TabFolder _tabFolder;

    public TabFolderLayout(TabFolder folder) {
        this._tabFolder = folder;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        TabItem[] selected = this._tabFolder.getSelection();
        if (selected == null || selected.length == 0) {
            return;
        }
        selected[0].getControl().setBounds(rect);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        int maxWidth = 0;
        int maxHeight = 0;
        TabItem[] selected = this._tabFolder.getSelection();
        if (selected != null && selected.length > 0) {
            Point pt = selected[0].getControl().computeSize(wHint, hHint, flushCache);
            maxWidth = Math.max(0, pt.x);
            maxHeight = Math.max(0, pt.y);
        }
        if (wHint != -1) {
            maxWidth = Math.max(wHint, maxWidth);
        }
        if (hHint != -1) {
            maxWidth = Math.max(hHint, maxHeight);
        }
        return new Point(maxWidth, maxHeight);
    }
}

