/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.switchyard.tools.ui.editor.Messages;

public class DomainPropertyInputDialog
extends TitleAreaDialog {
    private Text _propertyNameText;
    private Text _propertyValueText;
    private String _propertyName = null;
    private String _propertyValue = null;

    public DomainPropertyInputDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.title_newPropertyDetails);
        this.setMessage(Messages.description_newPropertyDetails);
        this.getShell().setText(Messages.title_domainProperty);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        this._propertyNameText = this.createLabelAndText(area, Messages.label_nameStar);
        if (this._propertyName != null && !this._propertyName.trim().isEmpty()) {
            this._propertyNameText.setText(this._propertyName);
        }
        this._propertyNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DomainPropertyInputDialog.this._propertyName = DomainPropertyInputDialog.this._propertyNameText.getText().trim();
            }
        });
        this._propertyValueText = this.createLabelAndText(area, Messages.label_valueStar);
        if (this._propertyValue != null && !this._propertyValue.trim().isEmpty()) {
            this._propertyValueText.setText(this._propertyValue);
        }
        this._propertyValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DomainPropertyInputDialog.this._propertyValue = DomainPropertyInputDialog.this._propertyValueText.getText().trim();
            }
        });
        return area;
    }

    protected Control createButtonBar(Composite parent) {
        Control rtnControl = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.validate());
        this.setErrorMessage(null);
        return rtnControl;
    }

    protected Text createLabelAndText(Composite parent, String label) {
        new Label(parent, 0).setText(label);
        Text newText = new Text(parent, 2048);
        newText.setLayoutData((Object)new GridData(4, 0, true, false));
        newText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DomainPropertyInputDialog.this.getButton(0).setEnabled(DomainPropertyInputDialog.this.validate());
            }
        });
        newText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DomainPropertyInputDialog.this.getButton(0).setEnabled(DomainPropertyInputDialog.this.validate());
            }
        });
        return newText;
    }

    protected boolean validate() {
        this.setErrorMessage(null);
        if (this._propertyNameText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.error_noPropertyName);
        } else if (this._propertyValueText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.error_noPropertyValue);
        }
        return this.getErrorMessage() == null;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public String getPropertyValue() {
        return this._propertyValue;
    }

    public void setPropertyName(String name) {
        this._propertyName = name;
    }

    public void setPropertyValue(String value) {
        this._propertyValue = value;
    }
}

