/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;

public class CompositeCreateFeature
extends AbstractCreateFeature {
    private final ICreateFeature[] _delegates;
    private boolean _hasDoneChanges;

    public CompositeCreateFeature(IFeatureProvider fp, String name, String description, ICreateFeature ... delegates) {
        super(fp, name, description);
        this._delegates = delegates;
    }

    public boolean canCreate(ICreateContext context) {
        if (this._delegates == null || this._delegates.length == 0) {
            return false;
        }
        ICreateFeature[] iCreateFeatureArray = this._delegates;
        int n = this._delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateFeature delegate = iCreateFeatureArray[n2];
            if (delegate.canCreate(context)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Object[] create(ICreateContext context) {
        this._hasDoneChanges = false;
        if (this._delegates == null || this._delegates.length == 0) {
            return new Object[0];
        }
        ArrayList<Object> createdObjects = new ArrayList<Object>();
        ICreateFeature[] iCreateFeatureArray = this._delegates;
        int n = this._delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateFeature delegate = iCreateFeatureArray[n2];
            if (delegate.canCreate(context)) {
                Object[] objects = delegate.create(context);
                boolean bl = this._hasDoneChanges = this._hasDoneChanges || delegate.hasDoneChanges();
                if (objects != null) {
                    createdObjects.addAll(Arrays.asList(objects));
                }
            }
            ++n2;
        }
        return createdObjects.toArray();
    }

    public String getCreateImageId() {
        if (this._delegates == null || this._delegates.length < 1) {
            return super.getCreateImageId();
        }
        return this._delegates[0].getCreateImageId();
    }

    public String getCreateLargeImageId() {
        if (this._delegates == null || this._delegates.length < 1) {
            return super.getCreateLargeImageId();
        }
        return this._delegates[0].getCreateLargeImageId();
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }
}

