/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;

public class CompositeCreateConnectionFeature
extends AbstractCreateConnectionFeature {
    private final ICreateConnectionFeature[] _delegates;
    private boolean _hasDoneChanges;

    public CompositeCreateConnectionFeature(IFeatureProvider fp, String name, String description, ICreateConnectionFeature ... delegates) {
        super(fp, name, description);
        this._delegates = delegates;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        if (this._delegates == null || this._delegates.length == 0) {
            return false;
        }
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = this._delegates;
        int n = this._delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateConnectionFeature delegate = iCreateConnectionFeatureArray[n2];
            if (delegate.canCreate(context)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Connection create(ICreateConnectionContext context) {
        this._hasDoneChanges = false;
        if (this._delegates == null || this._delegates.length == 0) {
            return null;
        }
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = this._delegates;
        int n = this._delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateConnectionFeature delegate = iCreateConnectionFeatureArray[n2];
            if (delegate.canCreate(context)) {
                Connection connection = delegate.create(context);
                this._hasDoneChanges = delegate.hasDoneChanges();
                return connection;
            }
            ++n2;
        }
        return null;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        if (this._delegates == null || this._delegates.length == 0) {
            return false;
        }
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = this._delegates;
        int n = this._delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateConnectionFeature delegate = iCreateConnectionFeatureArray[n2];
            if (delegate.canStartConnection(context)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getCreateImageId() {
        if (this._delegates == null || this._delegates.length < 1) {
            return super.getCreateImageId();
        }
        return this._delegates[0].getCreateImageId();
    }

    public String getCreateLargeImageId() {
        if (this._delegates == null || this._delegates.length < 1) {
            return super.getCreateLargeImageId();
        }
        return this._delegates[0].getCreateLargeImageId();
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }
}

