/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.common.ContractControl;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.diagram.component.IComponentWizard;

public abstract class BaseNewServiceFileWizard
extends BasicNewFileResourceWizard
implements IComponentWizard {
    private final Set<InterfaceControl.InterfaceType> _supportedInterfaceTypes;
    private WizardNewFileCreationPage _page;
    private Component _component;
    private ComponentService _service;
    private boolean _openFileAfterCreate = false;
    private String _createdFilePath = null;
    private String _fileExtension;
    private IJavaProject _project;
    private IFile _newFile;

    protected BaseNewServiceFileWizard(boolean openAfterCreate, String fileExtension) {
        this(openAfterCreate, fileExtension, EnumSet.of(InterfaceControl.InterfaceType.Java, InterfaceControl.InterfaceType.WSDL, InterfaceControl.InterfaceType.ESB));
    }

    protected BaseNewServiceFileWizard(boolean openAfterCreate, String fileExtension, Set<InterfaceControl.InterfaceType> supportedInterfaceTypes) {
        this._openFileAfterCreate = openAfterCreate;
        this._fileExtension = fileExtension;
        this._supportedInterfaceTypes = supportedInterfaceTypes;
    }

    @Override
    public Component getCreatedObject() {
        return this._component;
    }

    public boolean performFinish() {
        if (this._page != null) {
            this._newFile = this._page.createNewFile();
            if (this._newFile == null) {
                return false;
            }
            this._createdFilePath = JavaUtil.getJavaPathForResource((IResource)this._newFile).toString();
            this.selectAndReveal((IResource)this._newFile);
            if (this._openFileAfterCreate) {
                IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
                try {
                    IWorkbenchPage page;
                    if (dw != null && (page = dw.getActivePage()) != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)this._newFile, (boolean)true);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    Activator.logError((Exception)((Object)e));
                }
            }
            Implementation implementation = this.createImplementation();
            List<ComponentReference> references = this.createReferences();
            this._component = ScaFactory.eINSTANCE.createComponent();
            this._component.setName(this.getComponentName(this._newFile.getFullPath()));
            this._component.getService().add((Object)this._service);
            this._component.setImplementation(implementation);
            if (references != null) {
                this._component.getReference().addAll(references);
            }
            return true;
        }
        return false;
    }

    public String getCreatedFilePath() {
        return this._createdFilePath;
    }

    protected String getFileExtension() {
        return this._fileExtension;
    }

    public void setCreatedFilePath(String inPath) {
        this._createdFilePath = inPath;
    }

    public IFile getCreatedFile() {
        return this._newFile;
    }

    @Override
    public void init(Composite container) {
        if (container == null || this.getSelection() != null && !this.getSelection().isEmpty()) {
            return;
        }
        IProject project = PlatformResourceAdapterFactory.getContainingProject((Object)container);
        if (project == null) {
            return;
        }
        IResource folder = JavaUtil.getFirstResourceRoot((IJavaProject)JavaCore.create((IProject)project));
        StructuredSelection selection = new StructuredSelection(folder == null ? project : folder);
        this.init(this.getWorkbench() == null ? PlatformUI.getWorkbench() : this.getWorkbench(), (IStructuredSelection)selection);
    }

    public void forceServiceInterfaceType(ComponentService serviceInterface) {
        this._service = serviceInterface;
    }

    public ComponentService getService() {
        return this._service;
    }

    protected void setService(ComponentService service) {
        this._service = service;
    }

    public void addPages() {
        this._page = new ServiceImplementationFileCreationPage("newFilePage1", this.getSelection());
        if (this._createdFilePath != null) {
            this._page.setFileName(this._createdFilePath);
        }
        if (this._fileExtension != null) {
            this._page.setFileExtension(this._fileExtension);
        }
        this.addPage((IWizardPage)this._page);
    }

    protected WizardNewFileCreationPage getFileCreationPage() {
        return this._page;
    }

    protected void setFileCreationPage(WizardNewFileCreationPage page) {
        this._page = page;
    }

    protected abstract InputStream getInitialContents();

    protected abstract Implementation createImplementation();

    protected abstract List<ComponentReference> createReferences();

    protected String getComponentName(IPath newFile) {
        String fileName = newFile.removeFileExtension().lastSegment().toString();
        if (fileName.length() > 0) {
            return String.valueOf(fileName.substring(0, 1).toUpperCase()) + fileName.substring(1);
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        if (this._page == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this._page.getContainerFullPath());
        if (resource == null || resource.getProject() == null) {
            this._project = null;
        } else if (this._project == null || !this._project.getProject().equals((Object)resource.getProject())) {
            this._project = JavaCore.create((IProject)resource.getProject());
        }
        return this._project;
    }

    protected Set<InterfaceControl.InterfaceType> getSupportedInterfaceTypes() {
        return this._supportedInterfaceTypes;
    }

    private class ServiceImplementationFileCreationPage
    extends WizardNewFileCreationPage {
        private ContractControl _contractControl;

        public ServiceImplementationFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
        }

        protected InputStream getInitialContents() {
            return BaseNewServiceFileWizard.this.getInitialContents();
        }

        protected void createAdvancedControls(org.eclipse.swt.widgets.Composite parent) {
            org.eclipse.swt.widgets.Composite contents = new org.eclipse.swt.widgets.Composite(parent, 0);
            contents.setLayout((Layout)new GridLayout(3, false));
            contents.setLayoutData((Object)new GridData(768));
            this._contractControl = new ContractControl(ScaPackage.eINSTANCE.getComponentService(), BaseNewServiceFileWizard.this.getJavaProject(), BaseNewServiceFileWizard.this._supportedInterfaceTypes);
            this._contractControl.createControl(contents, 3);
            this._contractControl.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ServiceImplementationFileCreationPage.this.setPageComplete(ServiceImplementationFileCreationPage.this.validatePage());
                }
            });
            if (BaseNewServiceFileWizard.this._service != null) {
                this._contractControl.init((Contract)BaseNewServiceFileWizard.this._service, null);
                this._contractControl.setEnabled(false);
            }
            BaseNewServiceFileWizard.this._service = (ComponentService)this._contractControl.getContract();
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                this._contractControl.setProject(BaseNewServiceFileWizard.this.getJavaProject());
                IStatus status = this._contractControl.getStatus();
                if (status.getSeverity() < 4) {
                    if (!status.isOK()) {
                        this.setMessage(status.getMessage(), status.getSeverity() == 2 ? 2 : 1);
                    }
                    return true;
                }
                this.setErrorMessage(status.getMessage());
                return false;
            }
            return false;
        }

        protected IStatus validateLinkedResource() {
            return Status.OK_STATUS;
        }

        protected void createLinkTarget() {
        }
    }
}

