/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.internal.databinding.swt.SWTObservableValueDecorator;
import org.eclipse.jface.internal.databinding.swt.SWTVetoableValueDecorator;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.diagram.shared.ModelOperation;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.util.ErrorUtils;

public abstract class AbstractSwitchyardComposite
implements FocusListener,
KeyListener,
ModifyListener,
SelectionListener {
    private boolean _canEdit = true;
    private String _errorMessage = null;
    private GridData _rootGridData = null;
    private boolean _openOnCreate = false;
    private boolean _hasChanged = false;
    private boolean _inUpdate = false;
    private ArrayList<Control> _observableControls = new ArrayList();
    private Control _comboTextChanged = null;
    private TextValueChangeListener _textValueChangeListener = null;
    private ComboValueChangeListener _comboValueChangeListener = null;
    private ButtonValueChangeListener _buttonValueChangeListener = null;
    private ArrayList<IObservable> _observables = null;
    private boolean _observersAdded = false;
    private final FormToolkit _toolkit;
    private ListenerList _changeListeners;

    public AbstractSwitchyardComposite(FormToolkit toolkit) {
        this._toolkit = toolkit;
    }

    public FormToolkit getToolkit() {
        return this._toolkit;
    }

    protected abstract boolean validate();

    protected boolean hasChanged() {
        return this._hasChanged;
    }

    protected void setHasChanged(boolean flag) {
        this._hasChanged = flag;
    }

    public abstract void createContents(Composite var1, int var2, DataBindingContext var3);

    protected abstract void handleModify(Control var1);

    public abstract Composite getPanel();

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public void setErrorMessage(String msg) {
        this._errorMessage = msg;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        if (this._changeListeners != null && !this._changeListeners.isEmpty()) {
            Object[] listeners = this._changeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ChangeListener)listeners[i]).stateChanged(e);
                ++i;
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this._changeListeners == null) {
            this._changeListeners = new ListenerList();
        }
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this._changeListeners != null && !this._changeListeners.isEmpty()) {
            this._changeListeners.remove((Object)listener);
        }
    }

    public boolean canEdit() {
        return this._canEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this._canEdit = canEdit;
    }

    public void setRootGridData(GridData rootGridData) {
        this._rootGridData = rootGridData;
    }

    public GridData getRootGridData() {
        return this._rootGridData;
    }

    public void setOpenOnCreate(boolean flag) {
        this._openOnCreate = flag;
    }

    public boolean openOnCreate() {
        return this._openOnCreate;
    }

    public void dispose() {
        if (this.getPanel() != null) {
            AbstractSwitchyardComposite.disposeChildWidgets(this.getPanel());
        }
    }

    public static void disposeChildWidgets(Composite parent) {
        Control[] kids;
        if (parent.isDisposed()) {
            return;
        }
        Control[] controlArray = kids = parent.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control k = controlArray[n2];
            if (k instanceof Composite) {
                AbstractSwitchyardComposite.disposeChildWidgets((Composite)k);
            }
            k.dispose();
            ++n2;
        }
    }

    protected Button createCheckbox(Composite parent, String label) {
        Button newButton = this.getToolkit().createButton(parent, label, 16416);
        newButton.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this._observableControls.add((Control)newButton);
        return newButton;
    }

    private void addEnterNextListener(final Control control) {
        control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r') {
                    control.traverse(16);
                }
            }
        });
    }

    protected Text createLabelAndText(Composite parent, String label) {
        if (label != null && !label.trim().isEmpty()) {
            this.getToolkit().createLabel(parent, label, 0);
        }
        Text newText = this.getToolkit().createText(parent, "", 2048);
        newText.setLayoutData((Object)new GridData(4, 0, true, false));
        newText.addKeyListener((KeyListener)this);
        this.addEnterNextListener((Control)newText);
        this._observableControls.add((Control)newText);
        return newText;
    }

    protected void handleChange(Control control) {
        this.setHasChanged(true);
        this.validate();
        this.handleModify(control);
        this.fireChangedEvent(this);
    }

    protected void addObservableListeners() {
        this.addObservableListeners(false);
    }

    protected void addObservableListeners(boolean reset) {
        Shell shell;
        if (this._observersAdded && !reset) {
            return;
        }
        if (reset && this._observables != null && this._observables.size() > 0) {
            int i = 0;
            while (i < this._observables.size()) {
                this._observables.get(i).dispose();
                ++i;
            }
            this._observables.clear();
        }
        this._observables = new ArrayList();
        if (this._textValueChangeListener == null) {
            this._textValueChangeListener = new TextValueChangeListener();
        }
        if (this._comboValueChangeListener == null) {
            this._comboValueChangeListener = new ComboValueChangeListener();
        }
        if (this._buttonValueChangeListener == null) {
            this._buttonValueChangeListener = new ButtonValueChangeListener();
        }
        int styleBit = 0;
        Composite parent = this.getPanel().getParent();
        System.out.println(parent);
        while (parent != null && !(parent instanceof Shell)) {
            parent = parent.getParent();
        }
        if (parent != null && parent instanceof Shell && ((shell = (Shell)parent).getData() instanceof WizardDialog || shell.getData() instanceof PropertyDialog)) {
            styleBit = 24;
        }
        for (Control ctrl : this._observableControls) {
            if (ctrl.isDisposed()) continue;
            if (ctrl instanceof Text) {
                Text newText = (Text)ctrl;
                ISWTObservableValue focusObserver = SWTObservables.observeText((Control)newText, (int)(0x10 | styleBit));
                this._observables.add((IObservable)focusObserver);
                focusObserver.addValueChangeListener((IValueChangeListener)this._textValueChangeListener);
                continue;
            }
            if (ctrl instanceof Combo) {
                Combo newCombo = (Combo)ctrl;
                if ((newCombo.getStyle() & 8) == 0) {
                    newCombo.addKeyListener(new KeyListener(){

                        public void keyPressed(KeyEvent e) {
                        }

                        public void keyReleased(KeyEvent e) {
                            if (e.keyCode >= 97 && e.keyCode <= 122 || e.keyCode >= 48 && e.keyCode <= 57 || e.keyCode == 32 || e.keyCode == 8 || e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                                AbstractSwitchyardComposite.this._comboTextChanged = (Control)e.widget;
                            }
                        }
                    });
                    newCombo.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent arg0) {
                            AbstractSwitchyardComposite.this._comboTextChanged = (Control)arg0.widget;
                        }
                    });
                    if (styleBit != 0) {
                        newCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (AbstractSwitchyardComposite.this._comboTextChanged == (Control)e.getSource()) {
                                    System.out.println("AbstractSwitchyardComposite:New Combo Selection (text entry): " + ((Combo)e.getSource()).getText());
                                    AbstractSwitchyardComposite.this.handleChange((Control)e.getSource());
                                    AbstractSwitchyardComposite.this._comboTextChanged = null;
                                }
                            }
                        });
                    }
                    newCombo.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            if (AbstractSwitchyardComposite.this._comboTextChanged == (Control)e.getSource()) {
                                System.out.println("AbstractSwitchyardComposite:New Combo Value (text entry): " + ((Combo)e.getSource()).getText());
                                AbstractSwitchyardComposite.this.handleChange((Control)e.getSource());
                                AbstractSwitchyardComposite.this._comboTextChanged = null;
                            }
                        }
                    });
                }
                ISWTObservableValue selectionObserver = SWTObservables.observeSelection((Control)newCombo);
                this._observables.add((IObservable)selectionObserver);
                selectionObserver.addValueChangeListener((IValueChangeListener)this._comboValueChangeListener);
                continue;
            }
            if (!(ctrl instanceof Button)) continue;
            Button newButton = (Button)ctrl;
            ISWTObservableValue buttonObserver = SWTObservables.observeSelection((Control)newButton);
            this._observables.add((IObservable)buttonObserver);
            buttonObserver.addValueChangeListener((IValueChangeListener)this._buttonValueChangeListener);
        }
        this._observersAdded = true;
    }

    protected Combo createLabelAndCombo(Composite parent, String label) {
        return this.createLabelAndCombo(parent, label, false);
    }

    protected Combo createLabelAndCombo(Composite parent, String label, boolean readOnly) {
        if (label != null && !label.trim().isEmpty()) {
            this.getToolkit().createLabel(parent, label, 0);
        }
        int styles = 2052;
        if (readOnly) {
            styles = 2060;
        }
        Combo combo = new Combo(parent, styles);
        combo.setLayoutData((Object)new GridData(4, 1, true, false));
        if (!readOnly) {
            this.addEnterNextListener((Control)combo);
        }
        this._observableControls.add((Control)combo);
        this.getToolkit().adapt((Control)combo, true, true);
        return combo;
    }

    protected ComboViewer createLabelAndComboViewer(Composite parent, String label, boolean readOnly) {
        if (label != null && !label.trim().isEmpty()) {
            this.getToolkit().createLabel(parent, label, 0);
        }
        int styles = 2052;
        if (readOnly) {
            styles = 2060;
        }
        ComboViewer combo = new ComboViewer(parent, styles);
        combo.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
        if (!readOnly) {
            this.addEnterNextListener((Control)combo.getCombo());
        }
        this._observableControls.add((Control)combo.getCombo());
        this.getToolkit().adapt((Control)combo.getCombo(), true, true);
        return combo;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode != 13 && e.keyCode != 9) {
            this.setHasChanged(true);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 27) {
            Control control = (Control)e.getSource();
            this.setInUpdate(true);
            this.handleUndo(control);
            this.setInUpdate(false);
        }
    }

    protected boolean inUpdate() {
        return this._inUpdate;
    }

    protected void setInUpdate(boolean inUpdate) {
        this._inUpdate = inUpdate;
    }

    public void modifyText(ModifyEvent e) {
        if (!this.inUpdate()) {
            this._hasChanged = true;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.inUpdate()) {
            this._hasChanged = true;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void setTextValue(Text text, String value) {
        if (value == null) {
            value = "";
        }
        if (text != null && !text.isDisposed()) {
            text.setText(value);
        }
    }

    public void setTextValue(Combo combo, String value) {
        if (value == null) {
            value = "";
        }
        if (combo != null && !combo.isDisposed()) {
            combo.setText(value);
        }
    }

    public void setFeatureValue(EObject eObject, String featureId, Object value) throws Exception {
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && eStructuralFeature.getName().equalsIgnoreCase(featureId)) {
                if (value != null) {
                    eObject.eSet(eStructuralFeature, value);
                } else {
                    eObject.eUnset(eStructuralFeature);
                }
                return;
            }
            ++i;
        }
        System.out.println("AbstractSwitchyardComposite: Didn't find feature: " + featureId);
        this.showFeatures(eObject);
        throw new Exception("AbstractSwitchyardComposite:Feature ID (" + featureId + ") not found.");
    }

    private void showFeatures(EObject eObject) {
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable()) {
                System.out.println("AbstractSwitchyardComposite:Feature: " + eStructuralFeature.getName());
            }
            ++i;
        }
    }

    public Object getFeatureValue(EObject eObject, String featureId) {
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && eStructuralFeature.getName().equalsIgnoreCase(featureId)) {
                return eObject.eGet(eStructuralFeature);
            }
            ++i;
        }
        System.out.println("AbstractSwitchyardComposite: Didn't find feature: " + featureId);
        this.showFeatures(eObject);
        return null;
    }

    public String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    protected void handleUndo(Control control) {
    }

    protected TransactionalEditingDomain getDomain(EObject object) {
        if (object != null) {
            SwitchyardSCAEditor editor = SwitchyardSCAEditor.getEditor(object);
            return editor == null ? null : editor.getEditingDomain();
        }
        return null;
    }

    protected void wrapOperation(EObject eobject, final List<ModelOperation> ops) {
        TransactionalEditingDomain domain = this.getDomain(eobject);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    Iterator execOps = ops.iterator();
                    while (execOps.hasNext()) {
                        try {
                            ((ModelOperation)execOps.next()).run();
                        }
                        catch (Exception e) {
                            Activator.logError(e);
                            break;
                        }
                    }
                }
            });
        } else {
            Iterator<ModelOperation> execOps = ops.iterator();
            while (execOps.hasNext()) {
                try {
                    execOps.next().run();
                }
                catch (Exception e) {
                    Activator.logError(e);
                    break;
                }
            }
        }
    }

    protected void updateFeature(EObject eObject, String featureId, Object value) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new BasicEObjectOperation(eObject, featureId, value));
        this.wrapOperation(eObject, ops);
    }

    protected void addGridData(Control control, int columns, int style) {
        GridData controlGD = new GridData(style);
        controlGD.horizontalSpan = columns;
        control.setLayoutData((Object)controlGD);
    }

    public class BasicEObjectOperation
    extends ModelOperation {
        private EObject _localObject;
        private String _localFeature;
        private Object _localValue;

        public BasicEObjectOperation(EObject object, String featureId, Object value) {
            this._localObject = object;
            this._localFeature = featureId;
            this._localValue = value;
        }

        @Override
        public void run() throws Exception {
            if (this._localValue instanceof String && ((String)this._localValue).length() == 0) {
                AbstractSwitchyardComposite.this.setFeatureValue(this._localObject, this._localFeature, null);
            } else {
                AbstractSwitchyardComposite.this.setFeatureValue(this._localObject, this._localFeature, this._localValue);
            }
        }
    }

    class ButtonValueChangeListener
    implements IValueChangeListener {
        ButtonValueChangeListener() {
        }

        public void handleValueChange(ValueChangeEvent e) {
            if (!AbstractSwitchyardComposite.this.inUpdate() && e.diff != null && !AbstractSwitchyardComposite.this.inUpdate() && e.diff != null) {
                System.out.println("AbstractSwitchyardComposite:ButtonValueChanged: " + e.diff);
                SWTObservableValueDecorator decorator = (SWTObservableValueDecorator)e.getSource();
                AbstractSwitchyardComposite.this.handleChange((Control)decorator.getWidget());
            }
        }
    }

    class ComboValueChangeListener
    implements IValueChangeListener {
        ComboValueChangeListener() {
        }

        public void handleValueChange(ValueChangeEvent e) {
            if (!AbstractSwitchyardComposite.this.inUpdate() && e.diff != null) {
                System.out.println("AbstractSwitchyardComposite:ComboValueChanged: " + e.diff);
                SWTObservableValueDecorator decorator = (SWTObservableValueDecorator)e.getSource();
                AbstractSwitchyardComposite.this.handleChange((Control)decorator.getWidget());
                ErrorUtils.showErrorMessage(null);
            }
        }
    }

    class TextValueChangeListener
    implements IValueChangeListener {
        TextValueChangeListener() {
        }

        public void handleValueChange(ValueChangeEvent e) {
            if (!AbstractSwitchyardComposite.this.inUpdate() && e.diff != null && !e.diff.getOldValue().equals(e.diff.getNewValue())) {
                System.out.println("AbstractSwitchyardComposite:TextValueChanged: " + e.diff);
                SWTVetoableValueDecorator decorator = (SWTVetoableValueDecorator)e.getSource();
                Control ctrl = (Control)decorator.getWidget();
                if (!ctrl.isDisposed()) {
                    AbstractSwitchyardComposite.this.handleChange((Control)decorator.getWidget());
                    ErrorUtils.showErrorMessage(null);
                }
            }
        }
    }
}

