/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.service;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.util.GraphitiUtil;

public class SCADiagramUpdateServiceFeature
extends AbstractUpdateFeature {
    private boolean _hasDoneChanges;

    public SCADiagramUpdateServiceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        return bo instanceof Service && pe instanceof ContainerShape;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        if (!this.canUpdate(context)) {
            return Reason.createFalseReason();
        }
        ContainerShape cs = (ContainerShape)context.getPictogramElement();
        Service service = (Service)this.getBusinessObjectForPictogramElement((PictogramElement)cs);
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)service)) {
            return Reason.createTrueReason((String)String.format(Messages.updateReason_serviceRemoved, service.getName()));
        }
        String pictogramName = null;
        Text foundText = GraphitiUtil.findChildGA(cs.getGraphicsAlgorithm(), Text.class);
        if (foundText != null) {
            pictogramName = foundText.getValue();
        }
        String businessName = service.getName();
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.contentEquals(businessName);
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)Messages.updateReason_serviceName);
        }
        Set<Contract> existingConnections = this.getExistingConnections((AnchorContainer)cs);
        if (service.getPromote() != null && !existingConnections.remove(service.getPromote())) {
            return Reason.createTrueReason((String)Messages.updateReason_updateConnections);
        }
        if (existingConnections.size() > 0 || cs.getAnchors().size() != 2) {
            return Reason.createTrueReason((String)Messages.updateReason_updateConnections);
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        boolean updateNameNeeded;
        this._hasDoneChanges = false;
        ContainerShape cs = (ContainerShape)context.getPictogramElement();
        Service service = (Service)this.getBusinessObjectForPictogramElement((PictogramElement)cs);
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)service)) {
            RemoveContext removeContext = new RemoveContext(context.getPictogramElement());
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (removeFeature != null && removeFeature.canRemove((IRemoveContext)removeContext)) {
                removeFeature.remove((IRemoveContext)removeContext);
                this._hasDoneChanges = removeFeature.hasDoneChanges();
                return true;
            }
        }
        String pictogramName = null;
        Text foundText = GraphitiUtil.findChildGA(cs.getGraphicsAlgorithm(), Text.class);
        if (foundText != null) {
            pictogramName = foundText.getValue();
        }
        String businessName = service.getName();
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.contentEquals(businessName);
        if (updateNameNeeded) {
            foundText.setValue(businessName);
            this._hasDoneChanges = true;
        }
        if (cs.getAnchors().size() != 2) {
            BoxRelativeAnchor anchor = Graphiti.getPeCreateService().createBoxRelativeAnchor((AnchorContainer)cs);
            Ellipse anchorGa = Graphiti.getGaCreateService().createEllipse((GraphicsAlgorithmContainer)anchor);
            anchorGa.setTransparency(Double.valueOf(0.9));
            anchorGa.setLineVisible(Boolean.valueOf(false));
            Graphiti.getGaLayoutService().setLocationAndSize((GraphicsAlgorithm)anchorGa, -14, -6, 12, 12);
            anchor.setRelativeHeight(0.5);
            anchor.setRelativeWidth(1.0);
            anchor.setUseAnchorLocationAsConnectionEndpoint(true);
            this.link((PictogramElement)anchor, service);
            cs.getAnchors().move(0, (Object)anchor);
            for (Connection connection : new ArrayList(((Anchor)cs.getAnchors().get(1)).getOutgoingConnections())) {
                connection.setStart((Anchor)anchor);
            }
        }
        Set<Contract> existingConnections = this.getExistingConnections((AnchorContainer)cs);
        Anchor anchor = (Anchor)cs.getAnchors().get(0);
        ComponentService promotedService = service.getPromote();
        if (promotedService != null && !existingConnections.remove(promotedService)) {
            PictogramElement[] pictogramElementArray = this.getFeatureProvider().getAllPictogramElementsForBusinessObject((Object)promotedService);
            int n = pictogramElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                if (pe instanceof Anchor) {
                    AddConnectionContext addContext = new AddConnectionContext(anchor, (Anchor)pe);
                    addContext.setNewObject((Object)promotedService);
                    this.updatePictogramElement(this.getFeatureProvider().addIfPossible((IAddContext)addContext));
                    this._hasDoneChanges = true;
                    break;
                }
                ++n2;
            }
        }
        for (Connection connection : new ArrayList(anchor.getOutgoingConnections())) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getEnd());
            if (bo != null && !existingConnections.remove(bo)) continue;
            RemoveContext removeContext = new RemoveContext((PictogramElement)connection);
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (!removeFeature.canExecute((IContext)removeContext)) continue;
            removeFeature.execute((IContext)removeContext);
            boolean bl2 = this._hasDoneChanges = this._hasDoneChanges || removeFeature.hasDoneChanges();
        }
        return this._hasDoneChanges;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    private Set<Contract> getExistingConnections(AnchorContainer container) {
        LinkedHashSet<Contract> existingConnections = new LinkedHashSet<Contract>();
        for (Anchor anchor : container.getAnchors()) {
            for (Connection connection : anchor.getOutgoingConnections()) {
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getEnd());
                if (!(bo instanceof Contract) && bo != null) continue;
                existingConnections.add((Contract)bo);
            }
        }
        return existingConnections;
    }
}

