/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.internal.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.switchyard.tools.ui.editor.diagram.internal.wizards.BaseWizard;
import org.switchyard.tools.ui.editor.diagram.internal.wizards.ILinkedWizard;

public abstract class LinkedWizardBase
extends BaseWizard
implements ILinkedWizard {
    private ILinkedWizard _previous = null;
    private ILinkedWizard _next = null;
    private boolean _finished = false;

    @Override
    public void setPrevious(ILinkedWizard previous) {
        this._previous = previous;
        if (this._previous != null && (this.getWindowTitle() == null || this.getWindowTitle().length() == 0)) {
            this.setWindowTitle(this._previous.getWindowTitle());
        }
    }

    @Override
    public ILinkedWizard getPrevious() {
        return this._previous;
    }

    @Override
    public void setNext(ILinkedWizard next) {
        this._next = next;
        if (next != null) {
            if (next.getStartingPage() == null) {
                next.addPages();
            }
            this._next.setPrevious(this);
        }
    }

    @Override
    public ILinkedWizard getNext() {
        return this._next;
    }

    @Override
    public boolean canFinish() {
        boolean canFinish = super.canFinish();
        if (canFinish && this.getNext() != null) {
            canFinish = canFinish && this.getNext().canFinish();
        }
        return canFinish;
    }

    @Override
    public boolean isFinished() {
        return this._finished;
    }

    public void dispose() {
        super.dispose();
        this._previous = null;
    }

    public boolean performFinish() {
        boolean noFailures = true;
        if (!this._finished) {
            LinkedWizardBase lastWiz = this;
            if (this.getNext() != null && !this.getNext().isFinished()) {
                lastWiz = (LinkedWizardBase)this.getNext();
                while (lastWiz.getNext() != null && !lastWiz.getNext().isFinished()) {
                    lastWiz = (LinkedWizardBase)lastWiz.getNext();
                }
            }
            do {
                lastWiz._finished = lastWiz.doFinish();
                noFailures = noFailures && lastWiz.isFinished();
                lastWiz = (LinkedWizardBase)lastWiz.getPrevious();
            } while (noFailures && lastWiz != null && !lastWiz.isFinished());
        }
        return this._finished && noFailures;
    }

    public abstract boolean doFinish();

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == null && this.getNext() != null) {
            nextPage = this.getNext().getStartingPage();
        }
        return nextPage;
    }

    public void setFinished(boolean finished) {
        this._finished = finished;
    }
}

