/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.compositereference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.model.merge.CompositeMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.ContractMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.util.GraphitiUtil;

public class SCADiagramUpdateCompositeReferenceFeature
extends AbstractUpdateFeature {
    private boolean _hasDoneChanges;

    public SCADiagramUpdateCompositeReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        return bo instanceof Reference && pe instanceof ContainerShape;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        if (!this.canUpdate(context)) {
            return Reason.createFalseReason();
        }
        ContainerShape cs = (ContainerShape)context.getPictogramElement();
        Reference reference = (Reference)this.getBusinessObjectForPictogramElement((PictogramElement)cs);
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)reference)) {
            return Reason.createTrueReason((String)String.format(Messages.updateReason_referenceRemoved, reference.getName()));
        }
        String pictogramName = null;
        Text foundText = GraphitiUtil.findChildGA(cs.getGraphicsAlgorithm(), Text.class);
        if (foundText != null) {
            pictogramName = foundText.getValue();
        }
        String businessName = reference.getName();
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.contentEquals(businessName);
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)Messages.updateReason_referenceName);
        }
        LinkedHashSet<ComponentReference> promotedReferences = new LinkedHashSet<ComponentReference>((Collection<ComponentReference>)reference.getPromote());
        if (reference.getName() != null && reference.getName().length() > 0) {
            ContractMergedModelAdapter mergeAdapter = MergedModelUtil.getAdapter((EObject)reference, ContractMergedModelAdapter.class);
            CompositeMergedModelAdapter composite = MergedModelUtil.getAdapter((EObject)mergeAdapter.getSwitchYard().getComposite(), CompositeMergedModelAdapter.class);
            for (Component component : composite.getComponents()) {
                for (ComponentReference componentReference : component.getReference()) {
                    if (!reference.getName().equals(componentReference.getName())) continue;
                    promotedReferences.add(componentReference);
                }
            }
        }
        Set<Contract> existingConnections = this.getExistingConnections((AnchorContainer)cs);
        for (ComponentReference promotedReference : promotedReferences) {
            if (promotedReference == null || existingConnections.remove(promotedReference)) continue;
            return Reason.createTrueReason((String)Messages.updateReason_updateConnections);
        }
        if (existingConnections.size() > 0 || cs.getAnchors().size() != 2) {
            return Reason.createTrueReason((String)Messages.updateReason_updateConnections);
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        boolean updateNameNeeded;
        this._hasDoneChanges = false;
        ContainerShape cs = (ContainerShape)context.getPictogramElement();
        Reference reference = (Reference)this.getBusinessObjectForPictogramElement((PictogramElement)cs);
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)reference)) {
            RemoveContext removeContext = new RemoveContext(context.getPictogramElement());
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (removeFeature != null && removeFeature.canRemove((IRemoveContext)removeContext)) {
                removeFeature.remove((IRemoveContext)removeContext);
                this._hasDoneChanges = removeFeature.hasDoneChanges();
                return true;
            }
        }
        String pictogramName = null;
        Text foundText = GraphitiUtil.findChildGA(cs.getGraphicsAlgorithm(), Text.class);
        if (foundText != null) {
            pictogramName = foundText.getValue();
        }
        String businessName = reference.getName();
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.contentEquals(businessName);
        if (updateNameNeeded) {
            foundText.setValue(businessName);
            this._hasDoneChanges = true;
        }
        LinkedHashSet<ComponentReference> promotedReferences = new LinkedHashSet<ComponentReference>((Collection<ComponentReference>)reference.getPromote());
        if (reference.getName() != null && reference.getName().length() > 0) {
            ContractMergedModelAdapter mergeAdapter = MergedModelUtil.getAdapter((EObject)reference, ContractMergedModelAdapter.class);
            CompositeMergedModelAdapter composite = MergedModelUtil.getAdapter((EObject)mergeAdapter.getSwitchYard().getComposite(), CompositeMergedModelAdapter.class);
            for (Component component : composite.getComponents()) {
                for (Object componentReference : component.getReference()) {
                    if (!reference.getName().equals(componentReference.getName())) continue;
                    promotedReferences.add((ComponentReference)componentReference);
                }
            }
        }
        if (cs.getAnchors().size() != 2) {
            FixPointAnchor anchor = Graphiti.getPeCreateService().createFixPointAnchor((AnchorContainer)cs);
            Ellipse anchorGa = Graphiti.getGaCreateService().createEllipse((GraphicsAlgorithmContainer)anchor);
            GraphicsAlgorithm containerGa = cs.getGraphicsAlgorithm();
            anchorGa.setTransparency(Double.valueOf(0.9));
            anchorGa.setLineVisible(Boolean.valueOf(false));
            Graphiti.getGaLayoutService().setLocationAndSize((GraphicsAlgorithm)anchorGa, 0, -6, 12, 12);
            anchor.setLocation(Graphiti.getGaService().createPoint((int)(14.0 * (double)containerGa.getWidth() / 100.0), containerGa.getHeight() / 2));
            anchor.setUseAnchorLocationAsConnectionEndpoint(true);
            this.link((PictogramElement)anchor, reference);
            cs.getAnchors().move(0, (Object)anchor);
            for (Connection connection : new ArrayList(((Anchor)cs.getAnchors().get(1)).getIncomingConnections())) {
                connection.setEnd((Anchor)anchor);
            }
        }
        Set<Contract> existingConnections = this.getExistingConnections((AnchorContainer)cs);
        Anchor anchor = (Anchor)cs.getAnchors().get(0);
        block3: for (ComponentReference promotedReference : promotedReferences) {
            if (promotedReference == null || existingConnections.remove(promotedReference)) continue;
            PictogramElement[] pictogramElementArray = this.getFeatureProvider().getAllPictogramElementsForBusinessObject((Object)promotedReference);
            int n = pictogramElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                if (pe instanceof Anchor) {
                    AddConnectionContext addContext = new AddConnectionContext((Anchor)pe, anchor);
                    addContext.setNewObject((Object)reference);
                    this.updatePictogramElement(this.getFeatureProvider().addIfPossible((IAddContext)addContext));
                    this._hasDoneChanges = true;
                    continue block3;
                }
                ++n2;
            }
        }
        for (Connection connection : new ArrayList(anchor.getIncomingConnections())) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getStart());
            if (bo != null && !existingConnections.remove(bo)) continue;
            RemoveContext removeContext = new RemoveContext((PictogramElement)connection);
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (!removeFeature.canExecute((IContext)removeContext)) continue;
            removeFeature.execute((IContext)removeContext);
            boolean bl2 = this._hasDoneChanges = this._hasDoneChanges || removeFeature.hasDoneChanges();
        }
        return this._hasDoneChanges;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    private Set<Contract> getExistingConnections(AnchorContainer container) {
        LinkedHashSet<Contract> existingConnections = new LinkedHashSet<Contract>();
        for (Anchor anchor : container.getAnchors()) {
            for (Connection connection : anchor.getIncomingConnections()) {
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getStart());
                if (!(bo instanceof Contract) && bo != null) continue;
                existingConnections.add((Contract)bo);
            }
        }
        return existingConnections;
    }
}

