/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.composite;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.composite.SCADiagramAddCompositeFeature;
import org.switchyard.tools.ui.editor.model.merge.CompositeMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.util.GraphitiUtil;

public class SCADiagramUpdateCompositeFeature
extends AbstractUpdateFeature {
    private boolean _hasDoneChanges;

    public SCADiagramUpdateCompositeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof Composite;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        PictogramElement pictogramElement = context.getPictogramElement();
        String pictogramName = null;
        Text foundText = GraphitiUtil.findChildGA(pictogramElement.getGraphicsAlgorithm(), Text.class);
        if (foundText != null) {
            pictogramName = foundText.getValue();
        }
        Composite composite = (Composite)this.getBusinessObjectForPictogramElement(pictogramElement);
        String businessName = composite.getName();
        boolean bl = pictogramName == null ? businessName != null : (updateNameNeeded = !pictogramName.equals(businessName));
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)Messages.updateReason_compositeName);
        }
        if (this.getChildrenNotInDiagram(composite).length > 0) {
            return Reason.createTrueReason((String)Messages.updateReason_missingComponentsServicesReferences);
        }
        return this.childrenNeedUpdating(pictogramElement);
    }

    public boolean update(IUpdateContext context) {
        this._hasDoneChanges = false;
        PictogramElement pictogramElement = context.getPictogramElement();
        Composite composite = (Composite)this.getBusinessObjectForPictogramElement(pictogramElement);
        String businessName = composite.getName();
        GraphicsAlgorithm ga = pictogramElement.getGraphicsAlgorithm();
        Text text = GraphitiUtil.findChildGA(ga, Text.class);
        if (text != null && !text.getValue().equals(businessName)) {
            text.setValue(businessName);
            this._hasDoneChanges = true;
        }
        boolean layout = false;
        if (this.addMissingChildren(composite, (ContainerShape)pictogramElement)) {
            layout = true;
            this._hasDoneChanges = true;
        }
        if (this.updateChildren((ContainerShape)pictogramElement)) {
            layout = true;
            this._hasDoneChanges = true;
        }
        if (layout) {
            this.layoutPictogramElement(pictogramElement);
        }
        return this._hasDoneChanges;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    private boolean updateChildren(ContainerShape containerShape) {
        boolean changed = false;
        for (Shape shape : new ArrayList(containerShape.getChildren())) {
            UpdateContext updateContext = new UpdateContext((PictogramElement)shape);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)updateContext) || !updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) continue;
            updateFeature.update((IUpdateContext)updateContext);
            boolean bl = changed = changed || updateFeature.hasDoneChanges();
        }
        return changed;
    }

    private boolean addMissingChildren(Composite composite, ContainerShape containerShape) {
        boolean changed = false;
        AddContext addComponentContext = SCADiagramAddCompositeFeature.createComponentAddContext(this.getFeatureProvider(), containerShape);
        AddContext addServiceContext = SCADiagramAddCompositeFeature.createServiceAddContext(this.getFeatureProvider(), containerShape);
        AddContext addReferenceContext = SCADiagramAddCompositeFeature.createReferenceAddContext(this.getFeatureProvider(), containerShape);
        EObject[] eObjectArray = this.getChildrenNotInDiagram(composite);
        int n = eObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            EObject missingChild = eObjectArray[n2];
            if (missingChild instanceof Component) {
                changed = this.addGraphicalRepresentation(addComponentContext, missingChild) != null || changed;
            } else if (missingChild instanceof Service) {
                changed = this.addGraphicalRepresentation(addServiceContext, missingChild) != null || changed;
            } else if (missingChild instanceof Reference) {
                changed = this.addGraphicalRepresentation(addReferenceContext, missingChild) != null || changed;
            }
            ++n2;
        }
        return changed;
    }

    private PictogramElement addGraphicalRepresentation(AddContext context, Object object) {
        context.setNewObject(object);
        PictogramElement pe = super.addGraphicalRepresentation((IAreaContext)context, object);
        if (pe == null) {
            context.setY(context.getY() + 20);
        } else {
            context.setY(context.getY() + pe.getGraphicsAlgorithm().getHeight() + 10);
        }
        return pe;
    }

    private EObject[] getChildrenNotInDiagram(Composite composite) {
        ArrayList<Object> children = new ArrayList<Object>();
        CompositeMergedModelAdapter mergedComposite = MergedModelUtil.getAdapter((EObject)composite, CompositeMergedModelAdapter.class);
        children.addAll(mergedComposite.getServices());
        children.addAll(mergedComposite.getReferences());
        children.addAll(mergedComposite.getComponents());
        return Graphiti.getPeService().getElementsNotInDiagram(children.toArray(new EObject[children.size()]), this.getDiagram());
    }

    private IReason childrenNeedUpdating(PictogramElement pe) {
        if (pe instanceof ContainerShape) {
            EList children = ((ContainerShape)pe).getChildren();
            for (Shape shape : children) {
                IReason reason;
                UpdateContext updateContext = new UpdateContext((PictogramElement)shape);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
                if (updateFeature == null || !(reason = updateFeature.updateNeeded((IUpdateContext)updateContext)).toBoolean()) continue;
                return reason;
            }
        }
        return Reason.createFalseReason();
    }
}

