/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.composite;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.util.ExampleUtil;

public class SCADiagramCreateCompositeFeature
extends AbstractCreateFeature {
    private static final String TITLE = Messages.title_createComposite;
    private static final String USER_QUESTION = Messages.label_compositeName;
    private boolean _hasDoneChanges;

    public SCADiagramCreateCompositeFeature(IFeatureProvider fp) {
        super(fp, Messages.featureName_composite, Messages.featureDescription_composite);
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        String newCompositeName = ExampleUtil.askString(TITLE, USER_QUESTION, "");
        if (newCompositeName == null || newCompositeName.trim().length() == 0) {
            this._hasDoneChanges = false;
            return EMPTY;
        }
        Composite newComposite = ScaFactory.eINSTANCE.createComposite();
        newComposite.setName(newCompositeName);
        this.addGraphicalRepresentation((IAreaContext)context, newComposite);
        this._hasDoneChanges = true;
        return new Object[]{newComposite};
    }

    public String getCreateImageId() {
        return ImageProvider.IMG_16_COMPOSITE;
    }
}

