/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.componentreference;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.model.merge.CompositeMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.ContractMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;

public class UpdateComponentReferenceFeature
extends AbstractUpdateFeature {
    private boolean _hasDoneChanges;

    public UpdateComponentReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return this.getBusinessObjectForPictogramElement(context.getPictogramElement()) instanceof ComponentReference && context.getPictogramElement() instanceof ContainerShape;
    }

    public IReason updateNeeded(IUpdateContext context) {
        ComponentReference reference = (ComponentReference)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)reference)) {
            return Reason.createTrueReason((String)String.format(Messages.updateReason_referenceRemoved, reference.getName()));
        }
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        Set<Contract> existingConnections = this.getExistingConnections((AnchorContainer)container);
        ContractMergedModelAdapter mergeAdapter = MergedModelUtil.getAdapter((EObject)reference, ContractMergedModelAdapter.class);
        CompositeMergedModelAdapter composite = MergedModelUtil.getAdapter((EObject)mergeAdapter.getSwitchYard().getComposite(), CompositeMergedModelAdapter.class);
        for (Reference compositeReference : composite.getReferences()) {
            if (!compositeReference.getPromote().contains((Object)reference) && (reference.getName() == null || !reference.getName().equals(compositeReference.getName())) || existingConnections.remove(compositeReference)) continue;
            return Reason.createTrueReason((String)Messages.updateReason_updateConnections);
        }
        if (reference.getName() != null && reference.getName().length() > 0) {
            for (Component other : composite.getComponents()) {
                if (other == reference.eContainer()) continue;
                for (ComponentService service : other.getService()) {
                    if (!reference.getName().equals(service.getName()) || existingConnections.remove(service)) continue;
                    return Reason.createTrueReason((String)Messages.updateReason_updateConnections);
                }
            }
        }
        return existingConnections.isEmpty() && container.getAnchors().size() == 2 ? Reason.createFalseReason() : Reason.createTrueReason((String)Messages.updateReason_updateConnections);
    }

    public boolean update(IUpdateContext context) {
        BoxRelativeAnchor anchor;
        this._hasDoneChanges = false;
        ComponentReference reference = (ComponentReference)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)reference)) {
            RemoveContext removeContext = new RemoveContext(context.getPictogramElement());
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (removeFeature != null && removeFeature.canRemove((IRemoveContext)removeContext)) {
                removeFeature.remove((IRemoveContext)removeContext);
                this._hasDoneChanges = removeFeature.hasDoneChanges();
                return true;
            }
        }
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        Set<Contract> existingConnections = this.getExistingConnections((AnchorContainer)container);
        ContractMergedModelAdapter mergeAdapter = MergedModelUtil.getAdapter((EObject)reference, ContractMergedModelAdapter.class);
        CompositeMergedModelAdapter composite = MergedModelUtil.getAdapter((EObject)mergeAdapter.getSwitchYard().getComposite(), CompositeMergedModelAdapter.class);
        if (container.getAnchors().size() != 2) {
            anchor = Graphiti.getPeCreateService().createBoxRelativeAnchor((AnchorContainer)container);
            Ellipse anchorGa = Graphiti.getGaCreateService().createEllipse((GraphicsAlgorithmContainer)anchor);
            anchorGa.setFilled(Boolean.valueOf(false));
            anchorGa.setLineVisible(Boolean.valueOf(false));
            Graphiti.getGaLayoutService().setLocationAndSize((GraphicsAlgorithm)anchorGa, -10, -5, 10, 10);
            anchor.setRelativeHeight(0.5);
            anchor.setRelativeWidth(1.0);
            anchor.setUseAnchorLocationAsConnectionEndpoint(true);
            this.link((PictogramElement)anchor, reference);
            container.getAnchors().move(0, (Object)anchor);
            for (Connection connection : new ArrayList(((Anchor)container.getAnchors().get(1)).getOutgoingConnections())) {
                connection.setStart((Anchor)anchor);
            }
        }
        anchor = (Anchor)container.getAnchors().get(0);
        block1: for (Reference compositeReference : composite.getReferences()) {
            if (!compositeReference.getPromote().contains((Object)reference) && (reference.getName() == null || !reference.getName().equals(compositeReference.getName())) || existingConnections.remove(compositeReference)) continue;
            PictogramElement[] pictogramElementArray = this.getFeatureProvider().getAllPictogramElementsForBusinessObject((Object)compositeReference);
            int n = pictogramElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                if (pe instanceof Anchor) {
                    AddConnectionContext addContext = new AddConnectionContext((Anchor)anchor, (Anchor)pe);
                    addContext.setNewObject((Object)reference);
                    this.updatePictogramElement(this.getFeatureProvider().addIfPossible((IAddContext)addContext));
                    this._hasDoneChanges = true;
                    continue block1;
                }
                ++n2;
            }
        }
        if (reference.getName() != null && reference.getName().length() > 0) {
            block3: for (Component other : composite.getComponents()) {
                if (other == reference.eContainer()) continue;
                for (ComponentService service : other.getService()) {
                    if (!reference.getName().equals(service.getName()) || existingConnections.remove(service)) continue;
                    PictogramElement[] pictogramElementArray = this.getFeatureProvider().getAllPictogramElementsForBusinessObject((Object)service);
                    int n = pictogramElementArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        PictogramElement pe = pictogramElementArray[n3];
                        if (pe instanceof Anchor) {
                            AddConnectionContext addContext = new AddConnectionContext((Anchor)anchor, (Anchor)pe);
                            addContext.setNewObject((Object)reference);
                            this.updatePictogramElement(this.getFeatureProvider().addIfPossible((IAddContext)addContext));
                            this._hasDoneChanges = true;
                            continue block3;
                        }
                        ++n3;
                    }
                }
            }
        }
        for (Connection connection : new ArrayList(anchor.getOutgoingConnections())) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getEnd());
            if (bo != null && !existingConnections.remove(bo)) continue;
            RemoveContext removeContext = new RemoveContext((PictogramElement)connection);
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (!removeFeature.canExecute((IContext)removeContext)) continue;
            removeFeature.execute((IContext)removeContext);
            boolean bl = this._hasDoneChanges = this._hasDoneChanges || removeFeature.hasDoneChanges();
        }
        return this._hasDoneChanges;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    private Set<Contract> getExistingConnections(AnchorContainer container) {
        LinkedHashSet<Contract> existingConnections = new LinkedHashSet<Contract>();
        for (Anchor anchor : container.getAnchors()) {
            for (Connection connection : anchor.getOutgoingConnections()) {
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)connection.getEnd());
                if (!(bo instanceof Contract) && bo != null) continue;
                existingConnections.add((Contract)bo);
            }
        }
        return existingConnections;
    }
}

