/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.componentreference;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.model.merge.ComponentMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;

public class SCADiagramAddComponentReferenceFeature
extends AbstractAddShapeFeature {
    public SCADiagramAddComponentReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        ContainerShape targetContainer;
        return context.getNewObject() instanceof ComponentReference && this.getBusinessObjectForPictogramElement((PictogramElement)(targetContainer = context.getTargetContainer())) instanceof Component;
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        Component component = (Component)this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
        ComponentReference reference = (ComponentReference)context.getNewObject();
        if (reference == null) {
            return null;
        }
        List<ComponentReference> references = MergedModelUtil.getAdapter((EObject)component, ComponentMergedModelAdapter.class).getReferences();
        if (!references.contains(reference)) {
            System.err.println("Target component does not contain new reference!!!");
            return null;
        }
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IGaService gaService = Graphiti.getGaService();
        int anchorY = 25 + references.indexOf(reference) * 20;
        int anchorX = targetContainer.getGraphicsAlgorithm().getWidth() - 15 - 10;
        ContainerShape container = peCreateService.createContainerShape(targetContainer, true);
        Image image = gaService.createImage((GraphicsAlgorithmContainer)container, ImageProvider.IMG_COMPONENT_REFERENCE_SCALEABLE);
        gaService.setLocationAndSize((GraphicsAlgorithm)image, anchorX, anchorY, 20, 20);
        image.setStretchH(Boolean.valueOf(true));
        image.setStretchV(Boolean.valueOf(true));
        image.setProportional(Boolean.valueOf(true));
        BoxRelativeAnchor anchor = peCreateService.createBoxRelativeAnchor((AnchorContainer)container);
        Ellipse anchorGa = gaService.createEllipse((GraphicsAlgorithmContainer)anchor);
        anchorGa.setFilled(Boolean.valueOf(false));
        anchorGa.setLineVisible(Boolean.valueOf(false));
        gaService.setLocationAndSize((GraphicsAlgorithm)anchorGa, -10, -5, 10, 10);
        anchor.setRelativeHeight(0.5);
        anchor.setRelativeWidth(1.0);
        anchor.setUseAnchorLocationAsConnectionEndpoint(true);
        ChopboxAnchor chopboxAnchor = peCreateService.createChopboxAnchor((AnchorContainer)container);
        this.link((PictogramElement)container, reference);
        this.link((PictogramElement)anchor, reference);
        this.link((PictogramElement)chopboxAnchor, reference);
        this.layoutPictogramElement((PictogramElement)container);
        if (this.updatePictogramElementNeeded((PictogramElement)container)) {
            this.updatePictogramElement((PictogramElement)container);
        }
        return container;
    }
}

