/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.component;

import java.util.HashSet;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.swt.widgets.Shell;
import org.switchyard.tools.ui.editor.diagram.component.IComponentWizard;
import org.switchyard.tools.ui.editor.diagram.shared.BaseTypeFactory;
import org.switchyard.tools.ui.editor.diagram.shared.ITypeFactory;

public abstract class BaseComponentFactory
extends BaseTypeFactory<Component, Composite, IComponentWizard>
implements ITypeFactory<Component, Composite> {
    @Override
    public Component createType(Shell shell, Composite container) {
        Component component = (Component)super.createType(shell, container);
        if (component != null) {
            if (component.getName() == null) {
                component.setName(this.getComponentName(component.getImplementation(), container));
            } else {
                component.setName(this.makeUniqueComponentName(component.getName(), container));
            }
        }
        return component;
    }

    protected String getComponentName(Implementation implementation, Composite container) {
        return this.makeUniqueComponentName("Component", container);
    }

    protected String makeUniqueComponentName(String baseName, Composite container) {
        HashSet<String> componentNames = new HashSet<String>();
        for (Component component : container.getComponent()) {
            if (component.getName() == null) continue;
            componentNames.add(component.getName());
        }
        String componentName = baseName;
        int count = 1;
        while (componentNames.contains(componentName)) {
            componentName = String.valueOf(baseName) + count++;
        }
        return componentName;
    }
}

